/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PAL1Colorbar
extends AbstractColorbar {
    public PAL1Colorbar() {
        this.colors = new Color[256];
        this.colorCount = 254;
        this.minBin = 1;
        this.maxBin = 254;
        this.minOutlierBin = 0;
        this.maxOutlierBin = 255;
        for (int i = 0; i < this.colorCount; ++i) {
            float bright = (float)i / (float)(this.colorCount - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setMinOutlierColor(Color.blue);
        this.setMaxOutlierColor(Color.red);
        this.setName("untitled");
        this.setType("PA1");
    }

    public PAL1Colorbar(File f) throws IOException, FileNotFoundException {
        super(f, 768, 768);
    }

    public PAL1Colorbar(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 768);
    }

    public PAL1Colorbar(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("PA1");
    }

    public AbstractColorbar copy() throws IOException {
        PAL1Colorbar c = new PAL1Colorbar(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    public byte[] getBytes() {
        byte[] b = new byte[768];
        b[0] = (byte)this.getMinOutlierColor().getRed();
        b[256] = (byte)this.getMinOutlierColor().getGreen();
        b[512] = (byte)this.getMinOutlierColor().getBlue();
        b[255] = (byte)this.getMaxOutlierColor().getRed();
        b[511] = (byte)this.getMaxOutlierColor().getGreen();
        b[767] = (byte)this.getMaxOutlierColor().getBlue();
        for (int i = 0; i < this.colorCount; ++i) {
            Color c = this.getColorAt(i);
            b[1 + i] = (byte)c.getRed();
            b[257 + i] = (byte)c.getGreen();
            b[513 + i] = (byte)c.getBlue();
        }
        return b;
    }

    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid PAL-1 color table");
        }
        this.colors = new Color[256];
        this.colorCount = 254;
        this.minBin = 1;
        this.maxBin = 254;
        this.minOutlierBin = 0;
        this.maxOutlierBin = 255;
        for (int i = 0; i < 256; ++i) {
            this.setBin(i, new Color(0xFF & b[i], 0xFF & b[i + 256], 0xFF & b[i + 512]));
        }
    }

    public String toString() {
        return this.getName() + " PAL-1";
    }

    public boolean hasSpecialOutliers() {
        return true;
    }
}

