/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class GCTColorbar
extends AbstractColorbar {
    public GCTColorbar() {
        this(256);
    }

    public GCTColorbar(int count) {
        this.colorCount = count;
        this.colors = new Color[this.colorCount + 2];
        this.minBin = 0;
        this.maxBin = this.colorCount - 1;
        this.minOutlierBin = this.colorCount + 0;
        this.maxOutlierBin = this.colorCount + 1;
        for (int i = 0; i < this.colorCount; ++i) {
            float bright = (float)i / (float)(this.colorCount - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setMinOutlierColor(Color.black);
        this.setMaxOutlierColor(Color.white);
        this.setName("untitled");
        this.setType("GCT");
    }

    public GCTColorbar(File f) throws IOException, FileNotFoundException {
        super(f, 768, 784);
    }

    public GCTColorbar(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 784);
    }

    public GCTColorbar(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("GCT");
    }

    public AbstractColorbar copy() throws IOException {
        GCTColorbar c = new GCTColorbar(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    public byte[] getBytes() {
        byte[] b = new byte[778];
        for (int i = 0; i < this.colorCount; ++i) {
            Color c = this.getColorAt(i);
            b[i * 3 + 0] = (byte)c.getRed();
            b[i * 3 + 1] = (byte)c.getGreen();
            b[i * 3 + 2] = (byte)c.getBlue();
        }
        b[769] = (byte)this.colorCount;
        b[772] = (byte)this.getMinOutlierColor().getRed();
        b[773] = (byte)this.getMinOutlierColor().getGreen();
        b[774] = (byte)this.getMinOutlierColor().getBlue();
        b[775] = (byte)this.getMaxOutlierColor().getRed();
        b[776] = (byte)this.getMaxOutlierColor().getGreen();
        b[777] = (byte)this.getMaxOutlierColor().getBlue();
        return b;
    }

    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid GCT color table");
        }
        this.colorCount = 256;
        this.colorCount = 256;
        if (b.length >= 772) {
            this.colorCount = b[769] > 0 ? b[769] : 256 + b[769];
        }
        this.minBin = 0;
        this.maxBin = this.colorCount - 1;
        this.minOutlierBin = this.colorCount + 0;
        this.maxOutlierBin = this.colorCount + 1;
        this.badBin = this.colorCount + 2;
        this.missingBin = this.colorCount + 3;
        this.colors = new Color[this.colorCount + 4];
        for (int i = 0; i < this.colorCount; ++i) {
            int ii = i * 3;
            if (i >= 256) {
                ii += 4;
            }
            this.setBin(i, new Color(0xFF & b[ii], 0xFF & b[ii + 1], 0xFF & b[ii + 2]));
        }
        if (b.length >= 778) {
            this.setBin(this.minOutlierBin, new Color(0xFF & b[772], 0xFF & b[773], 0xFF & b[774]));
            this.setBin(this.maxOutlierBin, new Color(0xFF & b[775], 0xFF & b[776], 0xFF & b[777]));
        } else {
            this.setBin(this.minOutlierBin, this.getColorAt(this.minBin));
            this.setBin(this.maxOutlierBin, this.getColorAt(this.maxBin));
        }
    }

    public String toString() {
        return this.getName() + " GCT";
    }

    public boolean hasSpecialOutliers() {
        return true;
    }

    public void insertColorAt(int bin, Color c) {
        int i;
        if (bin < 0 || bin > this.colorCount) {
            throw new IllegalArgumentException("Color index is out of range.");
        }
        if (this.colorCount > 255) {
            throw new IllegalArgumentException("Color count is at maximum.");
        }
        ++this.colorCount;
        Color[] newArray = new Color[this.colorCount + 2];
        for (i = 0; i < bin; ++i) {
            newArray[i] = this.colors[i];
        }
        newArray[bin] = c;
        for (i = bin + 1; i < this.colorCount; ++i) {
            newArray[i] = this.colors[i - 1];
        }
        this.maxBin = this.colorCount - 1;
        this.minOutlierBin = this.colorCount;
        this.maxOutlierBin = this.colorCount + 1;
        this.colors = newArray;
    }

    public Color deleteColorAt(int bin) {
        int i;
        if (bin < 0 || bin >= this.colorCount) {
            throw new IllegalArgumentException("Color index is out of range.");
        }
        if (this.colorCount < 2) {
            throw new IllegalArgumentException("Color count is at minimum.");
        }
        --this.colorCount;
        Color[] newArray = new Color[this.colorCount + 2];
        Color victim = this.colors[bin];
        for (i = 0; i < bin; ++i) {
            newArray[i] = this.colors[i];
        }
        for (i = bin; i < this.colorCount; ++i) {
            newArray[i] = this.colors[i + 1];
        }
        this.maxBin = this.colorCount - 1;
        this.minOutlierBin = this.colorCount;
        this.maxOutlierBin = this.colorCount + 1;
        this.colors = newArray;
        return victim;
    }
}

