/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class AbstractColorbar {
    protected static final String PATH_SEP = System.getProperty("file.separator");
    protected URL url;
    protected String identifier;
    protected String fname;
    protected String fext;
    protected Color[] colors;
    protected int colorCount;
    protected int minBin;
    protected int maxBin;
    protected int minOutlierBin;
    protected int maxOutlierBin;
    protected int badBin;
    protected int missingBin;

    protected AbstractColorbar() {
    }

    protected AbstractColorbar(File f, int min, int max) throws IOException, FileNotFoundException, IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.url = f.toURL();
        this.identifier = this.url.toString();
        this.extractName(this.identifier);
        this.fillColorTable(this.readBytes(new FileInputStream(f), min, max));
    }

    protected AbstractColorbar(URL url, int min, int max) throws IOException, IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.url = url;
        this.identifier = url.toString();
        this.extractName(this.identifier);
        this.fillColorTable(this.readBytes(new DataInputStream(new BufferedInputStream(url.openStream())), min, max));
    }

    public AbstractColorbar(byte[] b) throws IOException, FileNotFoundException {
        this.fillColorTable(b);
    }

    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        FileOutputStream ostream = new FileOutputStream(f);
        ostream.write(this.getBytes());
        ostream.close();
        return true;
    }

    public abstract AbstractColorbar copy() throws IOException;

    protected abstract byte[] getBytes();

    protected abstract void fillColorTable(byte[] var1) throws IOException;

    private byte[] readBytes(InputStream istream, int min, int max) throws IOException, IllegalArgumentException {
        if (min <= 0 || max <= 0) {
            throw new IllegalArgumentException("Bytecount must be positive");
        }
        if (min > max) {
            throw new IllegalArgumentException("Max bytecount must be >= min");
        }
        byte[] b = new byte[max];
        int bytesRead = istream.read(b);
        istream.close();
        if (bytesRead < min) {
            throw new IOException("Invalid color table.  Could not read at least " + min + " bytes.");
        }
        return b;
    }

    protected void extractName(String src) {
        StringBuffer dst = new StringBuffer("");
        int lastSeparator = src.lastIndexOf(PATH_SEP);
        int lastSlash = src.lastIndexOf("/");
        int lastDot = src.lastIndexOf(".");
        if (lastSlash > lastSeparator) {
            lastSeparator = lastSlash;
        }
        if (lastDot < lastSeparator) {
            lastDot = -1;
        }
        if (lastDot > -1) {
            this.setName(src.substring(lastSeparator + 1, lastDot));
            this.setType(src.substring(lastDot + 1).toUpperCase());
        } else {
            this.setName(src.substring(lastSeparator + 1));
        }
    }

    public String getName() {
        return this.fname;
    }

    public void setName(String s) {
        this.fname = s;
    }

    public String getType() {
        return this.fext;
    }

    protected void setType(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.fext = s.toLowerCase();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getName();
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public boolean hasSpecialOutliers() {
        return false;
    }

    public Color getColorAt(int bin) {
        if (bin < 0 || bin >= this.colorCount) {
            return Color.black;
        }
        return this.colors[this.minBin + bin];
    }

    public Color getColorAt(int bin, boolean flipped) {
        if (bin < 0 || bin >= this.colorCount) {
            return Color.black;
        }
        if (flipped) {
            return this.colors[this.maxBin - bin];
        }
        return this.colors[this.minBin + bin];
    }

    public void setColorAt(int bin, Color c) {
        if (bin < 0 || bin >= this.colorCount) {
            throw new IllegalArgumentException("Bad color table entry number");
        }
        this.colors[this.minBin + bin] = c;
    }

    public int getRGBAt(int bin) {
        if (bin < 0 || bin >= this.colorCount) {
            return 0;
        }
        return this.colors[this.minBin + bin].getRGB();
    }

    public int getRGBAt(int bin, boolean flipped) {
        if (bin < 0 || bin >= this.colorCount) {
            return 0;
        }
        if (flipped) {
            return this.colors[this.maxBin - bin].getRGB();
        }
        return this.colors[this.minBin + bin].getRGB();
    }

    public void insertColorAt(int bin, Color c) {
        throw new IllegalArgumentException("Colorbar format does not allow for insertions.");
    }

    public Color deleteColorAt(int bin) {
        throw new IllegalArgumentException("Colorbar format does not allow for deletions.");
    }

    public Color getMinOutlierColor() {
        return this.colors[this.minOutlierBin];
    }

    public Color getMinOutlierColor(boolean flipped) {
        if (flipped) {
            return this.colors[this.maxOutlierBin];
        }
        return this.colors[this.minOutlierBin];
    }

    public int getMinOutlierRGB() {
        return this.colors[this.minOutlierBin].getRGB();
    }

    public void setMinOutlierColor(Color c) {
        this.colors[this.minOutlierBin] = c;
    }

    public int getMinOutlierRGB(boolean flipped) {
        if (flipped) {
            return this.colors[this.maxOutlierBin].getRGB();
        }
        return this.colors[this.minOutlierBin].getRGB();
    }

    public Color getMaxOutlierColor() {
        return this.colors[this.maxOutlierBin];
    }

    public Color getMaxOutlierColor(boolean flipped) {
        if (flipped) {
            return this.colors[this.minOutlierBin];
        }
        return this.colors[this.maxOutlierBin];
    }

    public void setMaxOutlierColor(Color c) {
        this.colors[this.maxOutlierBin] = c;
    }

    public int getMaxOutlierRGB() {
        return this.colors[this.maxOutlierBin].getRGB();
    }

    public int getMaxOutlierRGB(boolean flipped) {
        if (flipped) {
            return this.colors[this.minOutlierBin].getRGB();
        }
        return this.colors[this.maxOutlierBin].getRGB();
    }

    protected Color getBin(int bin) {
        return this.colors[bin];
    }

    public void setBin(int bin, Color c) {
        this.colors[bin] = c;
    }
}

