/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class ACTColorbar
extends AbstractColorbar {
    public ACTColorbar() {
        this(256);
    }

    public ACTColorbar(int count) {
        this.colorCount = count;
        this.minBin = 0;
        this.maxBin = this.colorCount - 1;
        this.minOutlierBin = this.minBin;
        this.maxOutlierBin = this.maxBin;
        this.colors = new Color[this.colorCount];
        for (int i = 0; i < this.colorCount; ++i) {
            float bright = (float)i / (float)(this.colorCount - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("ACT");
    }

    public ACTColorbar(File f) throws IOException, FileNotFoundException {
        super(f, 768, 772);
    }

    public ACTColorbar(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 772);
    }

    public ACTColorbar(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("ACT");
    }

    public AbstractColorbar copy() throws IOException {
        ACTColorbar c = new ACTColorbar(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    public byte[] getBytes() {
        byte[] b = new byte[772];
        for (int i = 0; i < this.colorCount; ++i) {
            Color c = this.getColorAt(i);
            b[i * 3 + 0] = (byte)c.getRed();
            b[i * 3 + 1] = (byte)c.getGreen();
            b[i * 3 + 2] = (byte)c.getBlue();
        }
        b[769] = (byte)this.colorCount;
        return b;
    }

    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid ACT color table");
        }
        this.colorCount = 256;
        this.minBin = 0;
        this.maxBin = 255;
        this.colorCount = 256;
        if (b.length == 772) {
            this.colorCount = b[769] > 0 ? b[769] : 256 + b[769];
        }
        this.maxBin = this.colorCount - 1;
        this.minOutlierBin = this.minBin;
        this.maxOutlierBin = this.maxBin;
        this.colors = new Color[this.colorCount];
        for (int i = 0; i < this.colorCount; ++i) {
            this.setBin(i, new Color(0xFF & b[i * 3], 0xFF & b[i * 3 + 1], 0xFF & b[i * 3 + 2]));
        }
    }

    public String toString() {
        return this.getName() + " ACT";
    }

    public void insertColorAt(int bin, Color c) {
        int i;
        if (bin < 0 || bin > this.colorCount) {
            throw new IllegalArgumentException("Color bin index is out of range.");
        }
        if (this.colorCount > 255) {
            throw new IllegalArgumentException("Can not add any more colors.");
        }
        ++this.colorCount;
        Color[] newArray = new Color[this.colorCount];
        for (i = 0; i < bin; ++i) {
            newArray[i] = this.colors[i];
        }
        newArray[bin] = c;
        for (i = bin + 1; i < this.colorCount; ++i) {
            newArray[i] = this.colors[i - 1];
        }
        this.maxOutlierBin = this.maxBin = this.colorCount - 1;
        this.colors = newArray;
    }

    public Color deleteColorAt(int bin) {
        int i;
        if (bin < 0 || bin >= this.colorCount) {
            throw new IllegalArgumentException("Color bin index is out of range.");
        }
        if (this.colorCount < 2) {
            throw new IllegalArgumentException("Can not delete last remaining color.");
        }
        --this.colorCount;
        Color[] newArray = new Color[this.colorCount];
        Color victim = this.colors[bin];
        for (i = 0; i < bin; ++i) {
            newArray[i] = this.colors[i];
        }
        for (i = bin; i < this.colorCount; ++i) {
            newArray[i] = this.colors[i + 1];
        }
        this.maxOutlierBin = this.maxBin = this.colorCount - 1;
        this.colors = newArray;
        return victim;
    }
}

