/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.ControlCurve;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class NatCubic
extends ControlCurve {
    protected int steps = 12;

    public NatCubic(int i) {
        this();
        this.steps = i;
        if (this.steps < 2) {
            this.steps = 2;
        }
    }

    public NatCubic() {
    }

    public void paint(Graphics2D g2d) {
        int isize = this.pts.size();
        if (this.pts.size() >= 2) {
            Object[] ptsA = this.pts.toArray();
            float[] ptsX = new float[isize];
            float[] ptsY = new float[isize];
            for (int i = 0; i < isize; ++i) {
                ptsX[i] = (float)((Point2D.Double)ptsA[i]).x;
                ptsY[i] = (float)((Point2D.Double)ptsA[i]).y;
            }
            Cubic[] x = this.calcNaturalCubic(isize - 1, ptsX);
            Cubic[] y = this.calcNaturalCubic(isize - 1, ptsY);
            GeneralPath gp = new GeneralPath();
            gp.moveTo(x[0].eval(0.0f), y[0].eval(0.0f));
            for (int i = 0; i < x.length; ++i) {
                for (int j = 1; j <= this.steps; ++j) {
                    float u = (float)j / (float)this.steps;
                    gp.lineTo(x[i].eval(u), y[i].eval(u));
                }
            }
            g2d.draw(gp);
        }
    }

    Cubic[] calcNaturalCubic(int n, float[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = 3.0f * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0f * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0f * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (int i2 = 0; i2 < n; ++i2) {
            C[i2] = new Cubic(x[i2], D[i2], 3.0f * (x[i2 + 1] - x[i2]) - 2.0f * D[i2] - D[i2 + 1], 2.0f * (x[i2] - x[i2 + 1]) + D[i2] + D[i2 + 1]);
        }
        return C;
    }

    public class Cubic {
        float a;
        float b;
        float c;
        float d;

        public Cubic(float a, float b, float c, float d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public float eval(float u) {
            return ((this.d * u + this.c) * u + this.b) * u + this.a;
        }
    }
}

