/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.colorbar.ACTColorbar;
import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import gov.nasa.giss.graphics.colorbar.CWCColorbar;
import gov.nasa.giss.graphics.colorbar.GCTColorbar;
import gov.nasa.giss.graphics.colorbar.PAL1Colorbar;
import gov.nasa.giss.graphics.colorbar.PAL2Colorbar;
import gov.nasa.giss.graphics.colorbar.PALColorbar;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ColorbarFactory {
    private static final String ACT_EXT = "act";
    private static final String CWC_EXT = "cwc";
    private static final String GCT_EXT = "gct";
    private static final String PA1_EXT = "pa1";
    private static final String PA2_EXT = "pa2";
    private static final String PAL_EXT = "pal";
    public static final String[] EXTENSIONS = new String[]{"act", "cwc", "gct", "pa1", "pa2", "pal"};

    private ColorbarFactory() {
    }

    public static boolean isColorbarName(File f) {
        return ColorbarFactory.isColorbarName(f.getName());
    }

    public static boolean isColorbarName(String fname) {
        String lcname = fname.toLowerCase();
        return lcname.endsWith(".pal") || lcname.endsWith(".pa1") || lcname.endsWith(".pa2") || lcname.endsWith(".act") || lcname.endsWith(".gct") || lcname.endsWith(".cwc");
    }

    public static AbstractColorbar create(String type) {
        return new ACTColorbar(65);
    }

    public static AbstractColorbar open(Frame listener) throws IOException, FileNotFoundException, MalformedURLException {
        FileDialog fd = new FileDialog(listener, "Please select a colorbar file.", 0);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return ColorbarFactory.isColorbarName(name) || new File(dir, name).isDirectory();
            }
        };
        fd.setFilenameFilter(filter);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            throw new FileNotFoundException("No file was selected");
        }
        return ColorbarFactory.initFromFile(new File(fd.getDirectory(), fd.getFile()));
    }

    public static AbstractColorbar open(File f) throws IOException, FileNotFoundException {
        return ColorbarFactory.initFromFile(f);
    }

    public static AbstractColorbar open(URL url) throws IOException, FileNotFoundException {
        if (url == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (url.getFile().toLowerCase().endsWith(".pal")) {
            return new PALColorbar(url);
        }
        if (url.getFile().toLowerCase().endsWith(".pa1")) {
            return new PAL1Colorbar(url);
        }
        if (url.getFile().toLowerCase().endsWith(".pa2")) {
            return new PAL2Colorbar(url);
        }
        if (url.getFile().toLowerCase().endsWith(".act")) {
            return new ACTColorbar(url);
        }
        if (url.getFile().toLowerCase().endsWith(".gct")) {
            return new GCTColorbar(url);
        }
        if (url.getFile().toLowerCase().endsWith(".cwc")) {
            return new CWCColorbar(url);
        }
        throw new FileNotFoundException("Colorbar filename has unknown extension.");
    }

    public static AbstractColorbar open(byte[] b, String name) throws IOException {
        AbstractColorbar c = null;
        if (name.toLowerCase().endsWith(".pal")) {
            c = new PALColorbar(b);
        } else if (name.toLowerCase().endsWith(".pa1")) {
            c = new PAL1Colorbar(b);
        } else if (name.toLowerCase().endsWith(".pa2")) {
            c = new PAL2Colorbar(b);
        } else if (name.toLowerCase().endsWith(".act")) {
            c = new ACTColorbar(b);
        } else if (name.toLowerCase().endsWith(".gct")) {
            c = new GCTColorbar(b);
        } else if (name.toLowerCase().endsWith(".cwc")) {
            c = new CWCColorbar(b);
        } else {
            throw new IOException("ERROR: Unknown color table type: " + name);
        }
        if (c != null) {
            c.setName(name);
        }
        return c;
    }

    private static AbstractColorbar initFromFile(File f) throws FileNotFoundException, IllegalArgumentException, IOException {
        if (f == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        if (f.getName().toLowerCase().endsWith(".pal")) {
            return new PALColorbar(f);
        }
        if (f.getName().toLowerCase().endsWith(".pa1")) {
            return new PAL1Colorbar(f);
        }
        if (f.getName().toLowerCase().endsWith(".pa2")) {
            return new PAL2Colorbar(f);
        }
        if (f.getName().toLowerCase().endsWith(".act")) {
            return new ACTColorbar(f);
        }
        if (f.getName().toLowerCase().endsWith(".gct")) {
            return new GCTColorbar(f);
        }
        if (f.getName().toLowerCase().endsWith(".cwc")) {
            return new CWCColorbar(f);
        }
        throw new IllegalArgumentException("ERROR: File is not a colorbar: " + f.getName());
    }
}

