/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;

public class Bezier {
    private boolean closed = false;
    private Point2D.Double[] anchors;
    private Point2D.Double[][] controls;

    public Bezier(boolean b, Point2D.Double[] a) {
        this.closed = b;
        this.setAnchors(a);
    }

    public Bezier(boolean b, ArrayList al) {
        this.closed = b;
        this.setAnchors(al);
    }

    public Bezier(boolean b, Vector v) {
        this.closed = b;
        this.setAnchors(v);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean b) {
        this.closed = b;
        this.controls = null;
    }

    public Point2D.Double[] getAnchors() {
        return this.anchors;
    }

    public void setAnchors(Point2D.Double[] a) {
        this.anchors = a;
        this.controls = null;
    }

    public void setAnchors(ArrayList al) {
        this.anchors = new Point2D.Double[al.size()];
        for (int i = 0; i < this.anchors.length; ++i) {
            this.anchors[i] = (Point2D.Double)al.get(i);
        }
        this.controls = null;
    }

    public void setAnchors(Vector v) {
        this.anchors = new Point2D.Double[v.size()];
        for (int i = 0; i < this.anchors.length; ++i) {
            this.anchors[i] = (Point2D.Double)v.get(i);
        }
        this.controls = null;
    }

    public Point2D.Double[][] getControls() {
        if (this.controls == null) {
            this.interpolateControls();
        }
        return this.controls;
    }

    public void paint(Graphics2D g2d) {
        if (this.controls == null) {
            this.interpolateControls();
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)this.anchors[0].x, (float)this.anchors[0].y);
        int numIntervals = this.closed ? this.anchors.length : this.anchors.length - 1;
        for (int i = 0; i < numIntervals; ++i) {
            if (this.closed && i == numIntervals - 1) {
                gp.curveTo((float)this.controls[i][0].x, (float)this.controls[i][0].y, (float)this.controls[i][1].x, (float)this.controls[i][1].y, (float)this.anchors[0].x, (float)this.anchors[0].y);
                continue;
            }
            gp.curveTo((float)this.controls[i][0].x, (float)this.controls[i][0].y, (float)this.controls[i][1].x, (float)this.controls[i][1].y, (float)this.anchors[i + 1].x, (float)this.anchors[i + 1].y);
        }
        g2d.draw(gp);
    }

    private void interpolateControls() {
        int numIntervals = this.closed ? this.anchors.length : this.anchors.length - 1;
        int istart = this.closed ? 0 : 1;
        int lastAnchor = this.anchors.length - 1;
        int lastInterval = numIntervals - 1;
        double smoothness = 0.9;
        this.controls = new Point2D.Double[numIntervals][2];
        for (int i = istart; i < numIntervals; ++i) {
            int im1 = i - 1 < 0 ? lastAnchor : i - 1;
            int ip1 = i + 1 > lastAnchor ? 0 : i + 1;
            double xc1 = 0.5 * (this.anchors[im1].x + this.anchors[i].x);
            double yc1 = 0.5 * (this.anchors[im1].y + this.anchors[i].y);
            double xc2 = 0.5 * (this.anchors[i].x + this.anchors[ip1].x);
            double yc2 = 0.5 * (this.anchors[i].y + this.anchors[ip1].y);
            double len1 = this.anchors[i].distance(this.anchors[im1]);
            double len2 = this.anchors[i].distance(this.anchors[ip1]);
            double k1 = len1 / (len1 + len2);
            double xm1 = xc1 + (xc2 - xc1) * k1;
            double ym1 = yc1 + (yc2 - yc1) * k1;
            this.controls[im1][1] = new Point2D.Double(this.anchors[i].x + (xc1 - xm1) * 0.9, this.anchors[i].y + (yc1 - ym1) * 0.9);
            this.controls[i][0] = new Point2D.Double(this.anchors[i].x + (xc2 - xm1) * 0.9, this.anchors[i].y + (yc2 - ym1) * 0.9);
        }
        if (!this.closed) {
            this.controls[0][0] = new Point2D.Double(this.anchors[0].x, this.anchors[0].y);
            this.controls[lastInterval][1] = new Point2D.Double(this.anchors[lastAnchor].x, this.anchors[lastAnchor].y);
        }
    }
}

