/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.geom;

public class Point3DCartesian {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final int Z_AXIS = 3;
    public static final int IN_DEGREES = 1;
    public static final int IN_RADIANS = 2;
    protected static final double RAD_PER_DEG = Math.PI / 180;
    protected static final double DEG_PER_RAD = 57.29577951308232;
    protected double x;
    protected double y;
    protected double z;
    protected double r;
    protected double theta;
    protected double phi;
    private double rho;
    private boolean needUpdate = true;

    public Point3DCartesian() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point3DCartesian(double x, double y, double z) {
        this.setLocation(x, y, z);
    }

    public void setLocation(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.needUpdate = true;
    }

    public void translate(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
        this.needUpdate = true;
    }

    public void rotateAxis(int axis, double angle, int units) {
        if (axis != 1 && axis != 2 && axis != 3) {
            throw new IllegalArgumentException("Bad rotation axis ID");
        }
        if (units != 1 && units != 2) {
            throw new IllegalArgumentException("Bad rotation units ID.");
        }
        if (units == 1) {
            angle *= Math.PI / 180;
        }
        double cosA = Math.cos(angle);
        double sinA = Math.sin(angle);
        double xPrime = this.x;
        double yPrime = this.y;
        double zPrime = this.z;
        switch (axis) {
            case 1: {
                xPrime = this.x;
                yPrime = this.y * cosA + this.z * sinA;
                zPrime = -this.y * sinA + this.z * cosA;
                break;
            }
            case 2: {
                xPrime = this.x * cosA - this.z * sinA;
                yPrime = this.y;
                zPrime = this.x * sinA + this.z * cosA;
                break;
            }
            case 3: {
                xPrime = this.x * cosA + this.y * sinA;
                yPrime = -this.x * sinA + this.y * cosA;
                zPrime = this.z;
            }
        }
        this.x = xPrime;
        this.y = yPrime;
        this.z = zPrime;
        this.needUpdate = true;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getR() {
        this.update();
        return this.r;
    }

    public double getTheta() {
        this.update();
        return this.theta;
    }

    public double getPhi() {
        this.update();
        return this.phi;
    }

    private void update() {
        if (this.needUpdate) {
            double xx = this.x * this.x;
            double yy = this.y * this.y;
            double zz = this.z * this.z;
            this.rho = Math.sqrt(xx + yy);
            this.r = Math.sqrt(xx + yy + zz);
            this.theta = Math.atan2(this.y, this.x) * 57.29577951308232;
            this.phi = this.r == 0.0 ? 0.0 : Math.acos(this.z / this.r) * 57.29577951308232;
        }
        this.needUpdate = false;
    }
}

