<?php

	//remarks.php functions using database-specific mysql functions
	function quote_smart($value)
	{  		
   		if (get_magic_quotes_gpc()) 
       		$value = stripslashes($value); // Stripslashes if input already escaped
		  		
   		if (!is_numeric($value)) 
       			$value = "'" . pg_escape_string($value) . "'"; // Quote if not a number or a numeric string
		return $value;
	}

	function doQuery($query,$location,&$sql) 
	//'&' in the argument means the argument is passed by reference so that
	//  the value of $error is passed back to the calling code
	{
		$query = str_replace("\"", "'", $query); //replace " with ' in query string (postgreSQL requirement)
		$sql=pg_query($query);
		$error=false;
		$error=reportError($location,"", pg_result_error() );
		return($error);
	}

	function fetchArray($sql)
	//returns the next row in $sql
	{
		$row=pg_fetch_array($sql);
		return $row;
	}

	function freeResult($sql)
	//frees the result set from the database
	{
		pg_free_result($sql);
	}

	function connectToDatabase()
	{
		$x=explode(":",DB_URL);
		$host=$x[0];
		$port=$x[1];

		$connect_string="host=$host port=$port dbname=".DB_USERNAME." user=".DB_USERNAME." password=".DB_PASSWORD;
	
		$connect = pg_connect($connect_string) or die("Cannot connect to database: ".pg_last_error($connect));
					
		// create database table if needed	
		$table = getTableName();
		$query_string="create table ".$table." (id serial not null, imageID char(200), date timestamp not null default now(), name char(100), msg text, ip1 char(100), ip2 char(100), refer char(255), primary key (id))";

		$x=pg_query($query_string);

		if( pg_result_error()!=0 )
			echo( reportError("Error Creating Table $table", "", pg_result_error($x)) );
	}


?>
