
import se.datadosen.component.ControlPanel;

import java.awt.*;
import javax.swing.*;

public class SkinSlideSection extends SkinAbstractSection
{
	public SkinSlideSection(SkinPanel ui)
	{
		super(ui);

		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();

		setLayout( gridbag );
		constraints.fill = GridBagConstraints.BOTH;
		constraints.anchor = GridBagConstraints.NORTHWEST;
		constraints.weightx = 1.0;

		addToContainer(getSlideShowPanel(), this, gridbag, constraints);
		addToContainer(getSlidePageThumbnailsPanel(), this, gridbag, constraints);
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		addToContainer(getSlideMiscPanel(), this, gridbag, constraints);
		addToContainer(getSlideContentPanel(), this, gridbag, constraints);
		addToContainer(getSlideCommentPanel(), this, gridbag, constraints);
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		constraints.gridheight = GridBagConstraints.REMAINDER;
		constraints.weighty = 1.0;
		addToContainer(Box.createGlue(), this, gridbag, constraints);
	}

	private ControlPanel getSlideShowPanel()
	{
		ControlPanel ccSlideShow = createControlPanel("Slide Show", 3);

		ccSlideShow.add("hfill", ui.includeSlideShow);
		ccSlideShow.add("br hfill", ui.cyclicSlideShow);
		ccSlideShow.add("br", new JLabel("Delay (sec)"));
		ccSlideShow.add("tab", ui.slideShowDelay);
		ccSlideShow.add("br", new JLabel("Delay on Movies (sec)"));
		ccSlideShow.add("tab", ui.slideShowMovieDelay);
		ccSlideShow.add("br", new JLabel("Delay on Comments (sec)"));
		ccSlideShow.add("tab", ui.slideShowCommentDelay);
		return ccSlideShow;
	}

	private ControlPanel getSlidePageThumbnailsPanel()
	{
		ControlPanel ccSlidePageThumbnails = createControlPanel("Slide Page Thumbnails", 3, 5);

		ccSlidePageThumbnails.add("hfill", ui.includeSlidePageThumbnails);
		ccSlidePageThumbnails.add("br", new JLabel("Count"));
		ccSlidePageThumbnails.add(ui.slidePageThumbnailCount);
		ccSlidePageThumbnails.add("br", new JLabel("Ratio"));
		ccSlidePageThumbnails.add(ui.slidePageThumbnailRatio);
		ccSlidePageThumbnails.add(new JLabel("%"));
		return ccSlidePageThumbnails;
	}

	private ControlPanel getSlideMiscPanel()
	{
		ControlPanel ccMisc = createControlPanel("Misc", 3);

		ccMisc.add(new JLabel("Movie Slides Dimension"));
		ccMisc.add("hfill", ui.movieSlideDimension);
		ccMisc.add("br hfill", ui.prefetchSiblingSlides);
		ccMisc.add("br hfill", ui.includeBlendingEffectOnSlides);
		ccMisc.add("br hfill", ui.includeMoveForwardFacility);
		return ccMisc;
	}

	private ControlPanel getSlideContentPanel()
	{
		ControlPanel ccSlideContent = createControlPanel("Slide Displayed Information", 3);

		ccSlideContent.add(new JLabel("Slide HTML Title"));
		ccSlideContent.add("tab", ui.slideHtmlTitleContent);

		ccSlideContent.add("br", new JLabel("Breadcrumb Trail Content"));
		ccSlideContent.add("tab", ui.slideBreadcrumbTrailContent);

		ccSlideContent.add("br", new JLabel("Slide Caption Content"));
		ccSlideContent.add("tab hfill", ui.slideCaptionContent);
		return ccSlideContent;
	}

	private ControlPanel getSlideCommentPanel()
	{
		ControlPanel ccSlideComment = createControlPanel("Slide Comment");

		ccSlideComment.add("hfill", ui.enableDedicatedSlideCommentSection );

		ccSlideComment.add("br", new JLabel("Horizontal Align"));
		ccSlideComment.add("tab", ui.slideCommentHorizontalAlign);
		ccSlideComment.add(new JLabel("Vertical Position"));
		ccSlideComment.add(ui.slideCommentVerticalPosition);
		return ccSlideComment;
	}
}
