
import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;

import javax.swing.*;

public class SkinRemarksSection extends SkinAbstractSection
{
	public SkinRemarksSection(SkinPanel ui)
	{
		super(new RiverLayout(0, 0), ui);

		ControlPanel ccDatabase = createControlPanel("Database", 5, 3);
		ControlPanel ccNotification = createControlPanel("Notification", 5, 3);
		ControlPanel ccAlbum = createControlPanel("Album", 5, 3);

		ccDatabase.add(new JLabel("Type:"));
		ccDatabase.add("tab", ui.remarksDatabaseType);
		ccDatabase.add("tab", new JLabel("URL:"));
		ccDatabase.add("tab", ui.remarksDatabaseUrl);
		ccDatabase.add("br", new JLabel("DB Name:"));
		ccDatabase.add("tab", ui.remarksDatabaseName);
		ccDatabase.add("tab", new JLabel("Table Name:"));
		ccDatabase.add("tab", ui.remarksDatabaseTableName);
		ccDatabase.add("br", new JLabel("User Name:"));
		ccDatabase.add("tab", ui.remarksDatabaseUserName);
		ccDatabase.add("tab", new JLabel("Password:"));
		ccDatabase.add("tab", ui.remarksDatabasePassword);

		ccAlbum.add(new JLabel("Admin Username:"));
		ccAlbum.add("tab", ui.remarksAdminUser);
		ccAlbum.add("tab", new JLabel("Admin Password:"));
		ccAlbum.add("tab", ui.remarksAdminPassword);
		ccAlbum.add("br", new JLabel("Date Format:"));
		ccAlbum.add("tab", ui.remarksDateFormat);
		ccAlbum.add("tab", new JLabel("Date Suffix:"));
		ccAlbum.add("tab", ui.remarksDateSuffix);
		ccAlbum.add("br", ui.remarksUseCaptcha);
		ccAlbum.add("tab", Box.createGlue());
		ccAlbum.add("tab", new JLabel("CAPTCHA Digits:"));
		ccAlbum.add("tab", ui.remarksCaptchaDigits);
		ccAlbum.add("br hfill", ui.remarksUseModeration);

		ccNotification.add("hfill", ui.remarksNotifyViaEmail);
		ccNotification.add("br", new JLabel("'To' E-Mail:"));
		ccNotification.add("tab", ui.remarksNotifyToEmail);
		ccNotification.add("tab", new JLabel("'From' E-Mail:"));
		ccNotification.add("tab", ui.remarksNotifyFromEmail);

		add(new JLabel("Note: This feature needs server side PHP support as well as a database server (either MySQL or PostgreSQL); the album"));
		add("br", new JLabel("           will need to be viewed from a web server for the feature to function."));
		add("br hfill", ui.includeViewerRemarksOnSlides );
		add("tab hfill", ui.includeViewerRemarksOnFolders );
		add("br", new JLabel("Remarks Section Display Status"));
		add(ui.remarksSectionDisplayStatus);
		add("br hfill", ccDatabase);
		add("br hfill", ccAlbum);
		add("br hfill", ccNotification);
	}
}
