
import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;

import javax.swing.*;

public class SkinGeneralSection extends SkinAbstractSection
{
	public SkinGeneralSection(SkinPanel ui)
	{
		super(new RiverLayout(0, 0), ui);

		add("p vtop hfill", getGeneralPanel());
		add("p hfill", getMetaTagsPanel());
	}

	private ControlPanel getGeneralPanel()
	{
		ControlPanel ccGeneral = createControlPanel("General", 5, 3);

		ccGeneral.add("hfill", ui.includeKeyboardSupport);
		ccGeneral.add("tab hfill", ui.includeSaveProtection);
		ccGeneral.add("br hfill", ui.includeFirstLastPageActions);
		ccGeneral.add("tab hfill", ui.includeJumpToPageAction);
		ccGeneral.add("br", Box.createGlue());
		ccGeneral.add("tab hfill", ui.includeNavigationHelpTips);
		ccGeneral.add("br", new JLabel("Navigation Bar Location"));
		ccGeneral.add(ui.navigationBarVerticalLocation);
		ccGeneral.add("tab", new JLabel("Context Help Style"));
		ccGeneral.add(ui.contextHelpStyle);
		ccGeneral.add("br", new JLabel("Icon Set"));
		ccGeneral.add(ui.iconSet);
		ccGeneral.add("tab", new JLabel("Language"));
		ccGeneral.add(ui.language);
		ccGeneral.add("br", new JLabel("Album Title"));
		ccGeneral.add("hfill", ui.title);
		ccGeneral.add("br", new JLabel("External HOME Path"));
		ccGeneral.add("hfill", ui.externalHomePath);
		ccGeneral.add("br", new JLabel("Copyright Message"));
		ccGeneral.add("hfill", ui.albumCopyright);
		ccGeneral.add("br", Box.createVerticalStrut(15));
		ccGeneral.add("br", new JLabel("Note: Please make sure you've started External HOME Path with http:// if it's an absolute URL."));
		ccGeneral.add("br", new JLabel("           Otherwise it will be treated as a relative one."));
		return ccGeneral;
	}

	private ControlPanel getMetaTagsPanel()
	{
		ControlPanel ccMetaTags = createControlPanel("Meta Tags", 3);

		ccMetaTags.add(new JLabel("Note: Meta tags are inserted into head section of your album pages"));

		ccMetaTags.add("br hfill", ui.includeMetaTagsOnIndex);
		ccMetaTags.add("hfill", ui.includeMetaTagsOnSlides);

		ccMetaTags.add("br hfill", ui.includeMetaTagCopyright);
		ccMetaTags.add("br", new JLabel("Meta-Tag Description"));
		ccMetaTags.add("tab hfill", ui.metaTagDescription);
		ccMetaTags.add("br", new JLabel("Meta-Tag Keywords"));
		ccMetaTags.add("tab hfill", ui.metaTagKeywords);
		ccMetaTags.add("br", new JLabel("Meta-Tag Rating"));
		ccMetaTags.add("tab", ui.metaTagRating);
		ccMetaTags.add("br", new JLabel("Meta-Tag Robots"));
		ccMetaTags.add("tab", ui.metaTagRobots);
		return ccMetaTags;
	}
}
