
import edu.stanford.ejalbert.BrowserLauncher;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAlbumFrame;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import javax.swing.*;

public class SkinFramesSection extends SkinAbstractSection
{
	private JAlbumFrame window;
	private AlbumBean engine;
	private FramePreviewPanel pnlFramePreview;

	public SkinFramesSection( SkinPanel ui, JAlbumFrame window, AlbumBean engine )
	{
		super( new BorderLayout( 0, 0 ), ui );
		this.window = window;
		this.engine = engine;

		pnlFramePreview = new FramePreviewPanel(window, engine);

		JLabel lblWarning = new JLabel( "Note: Use Rebuild All if these settings are changed between album generations." );
		JPanel pnlMain = new JPanel();

		pnlMain.setLayout( new BoxLayout( pnlMain, BoxLayout.Y_AXIS ) );
		pnlMain.add( getSlideFramePanel() );
		pnlMain.add( getMovieSlideFramePanel() );
		pnlMain.add( getThumbnailFramePanel() );
		pnlMain.add( getFolderThumbnailFramePanel() );
		pnlMain.add( getDownloadFramePanel() );

		add( lblWarning, BorderLayout.NORTH );
		add( pnlMain, BorderLayout.WEST );
		add( pnlFramePreview, BorderLayout.CENTER );
	}

	private ControlPanel getSlideFramePanel()
	{
		PreviewAction slideFramePreviewAction = new PreviewAction( BPPFrameHandler.APPLY_LEVEL_SLIDE, Constants.USER_VAR_SLIDE_FRAME_TYPE );
		EditAction slideFrameEditAction = new EditAction( Constants.USER_VAR_SLIDE_FRAME_TYPE );
		ControlPanel ccFrame = createControlPanel( "Slide", 1, 1 );

		ccFrame.add( new JLabel( "Type" ) );
		ccFrame.add( "tab", ui.slideFrameType );
		ccFrame.add( "br", new JLabel( "Ratio" ) );
		ccFrame.add( "tab", ui.slideFrameRatio );
		ccFrame.add( new JLabel( "%" ) );
		ccFrame.add( "br", new JLabel() );
		ccFrame.add( "tab", new JButton( slideFramePreviewAction ) );
		ccFrame.add( new JButton( slideFrameEditAction ) );
		return ccFrame;
	}

	private ControlPanel getMovieSlideFramePanel()
	{
		PreviewAction movieSlideFramePreviewAction = new PreviewAction( BPPFrameHandler.APPLY_LEVEL_MOVIE_SLIDE, Constants.USER_VAR_MOVIE_SLIDE_FRAME_TYPE );
		EditAction movieSlideFrameEditAction = new EditAction( Constants.USER_VAR_MOVIE_SLIDE_FRAME_TYPE );
		ControlPanel ccFrame = createControlPanel( "Movie Slide", 1, 1 );

		ccFrame.add( new JLabel( "Type" ) );
		ccFrame.add( "tab", ui.movieSlideFrameType );
		ccFrame.add( "br", new JLabel( "Ratio" ) );
		ccFrame.add( "tab", ui.movieSlideFrameRatio );
		ccFrame.add( new JLabel( "%" ) );
		ccFrame.add( "br", new JLabel() );
		ccFrame.add( "tab", new JButton( movieSlideFramePreviewAction ) );
		ccFrame.add( new JButton( movieSlideFrameEditAction ) );
		return ccFrame;
	}

	private ControlPanel getThumbnailFramePanel()
	{
		PreviewAction thumbFramePreviewAction = new PreviewAction( BPPFrameHandler.APPLY_LEVEL_THUMBNAIL, Constants.USER_VAR_SLIDE_THUMBNAIL_FRAME_TYPE );
		EditAction thumbFrameEditAction = new EditAction( Constants.USER_VAR_SLIDE_THUMBNAIL_FRAME_TYPE );
		ControlPanel ccFrame = createControlPanel( "Thumbnail", 1, 1 );

		ccFrame.add( new JLabel( "Type" ) );
		ccFrame.add( "tab", ui.thumbnailFrameType );
		ccFrame.add( "br", new JLabel( "Ratio" ) );
		ccFrame.add( "tab", ui.thumbnailFrameRatio );
		ccFrame.add( new JLabel( "%" ) );
		ccFrame.add( "br", new JLabel() );
		ccFrame.add( "tab", new JButton( thumbFramePreviewAction ) );
		ccFrame.add( new JButton( thumbFrameEditAction ) );
		return ccFrame;
	}

	private ControlPanel getFolderThumbnailFramePanel()
	{
		PreviewAction folderFramePreviewAction = new PreviewAction( BPPFrameHandler.APPLY_LEVEL_FOLDER, Constants.USER_VAR_FOLDER_THUMBNAIL_FRAME_TYPE );
		EditAction folderFrameEditAction = new EditAction( Constants.USER_VAR_FOLDER_THUMBNAIL_FRAME_TYPE );
		ControlPanel ccFrame = createControlPanel( "Folder Thumbnail", 1, 1 );

		ccFrame.add( new JLabel( "Type" ) );
		ccFrame.add( "tab", ui.folderThumbnailFrameType );
		ccFrame.add( "br", new JLabel( "Ratio" ) );
		ccFrame.add( "tab", ui.folderThumbnailFrameRatio );
		ccFrame.add( new JLabel( "%" ) );
		ccFrame.add( "br", new JLabel() );
		ccFrame.add( "tab", new JButton( folderFramePreviewAction ) );
		ccFrame.add( new JButton( folderFrameEditAction ) );
		return ccFrame;
	}

	private JPanel getDownloadFramePanel()
	{
		JPanel pnl = new JPanel(new BorderLayout());
		JLinkLabel downloadLink = new JLinkLabel("View & Download more Frames...");

		downloadLink.setURL(Constants.SKIN_FRAME_DOWNLOAD_URL);
		downloadLink.setToolTipText(Constants.SKIN_FRAME_DOWNLOAD_URL);

		pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		pnl.add(downloadLink, BorderLayout.NORTH);
		pnl.add(Box.createGlue(), BorderLayout.CENTER);
		return pnl;
	}

	private class EditAction extends AbstractAction
	{
		//private String frameTypeVariableName;

		public EditAction( String frameTypeVariableName )
		{
			super( "Edit" );
			putValue( Action.SHORT_DESCRIPTION, "Click to open the folder containing the currently selected frame's configuration." );
			//putValue(Action.SHORT_DESCRIPTION, "Click to edit the currently selected frame's configuration.");
			//this.frameTypeVariableName = frameTypeVariableName;
		}

		public void actionPerformed( ActionEvent e )
		{
			try
			{
				/*window.ui2Engine();

				String selectedFrameType = (String) engine.getSkinVariables().get(frameTypeVariableName);

				if( selectedFrameType==null || selectedFrameType.trim().equals("") )
					return;*/

				File framePack = new File( new BPPCompiledScript( engine ).skinDirectory, Constants.SKIN_FRAME_CONFIG_DIR /*+ selectedFrameType + Constants.SKIN_FRAME_CONFIG_EXTENSION*/ );

				BrowserLauncher.openLocal( framePack );
			}
			catch( Exception ex )
			{
				ex.printStackTrace();
				window.messageBox( "Can not edit the currently selected frame! Please check the logs..." );
			}
		}
	}

	private class PreviewAction extends AbstractAction
	{
		private String frameTypeVariableName;
		private int applyLevel = -1;

		public PreviewAction( int applyLevel, String frameTypeVariableName )
		{
			super( "Preview" );
			putValue( Action.SHORT_DESCRIPTION, "Click to see a preview of the currently selected frame." );
			this.applyLevel = applyLevel;
			this.frameTypeVariableName = frameTypeVariableName;
		}

		public void actionPerformed( ActionEvent e )
		{
			try
			{
				window.ui2Engine();
				String selectedFrameType = ( String ) engine.getSkinVariables().get( frameTypeVariableName );

				pnlFramePreview.setCurrentPreview( applyLevel, selectedFrameType );
			}
			catch( Exception ex )
			{
				ex.printStackTrace();
				window.messageBox( "Can not display a preview for the currently selected frame! Please check the logs..." );
			}
		}
	}
}
