
import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;

import java.awt.*;
import javax.swing.*;

public class SkinAdvancedSection extends SkinAbstractSection
{
	public SkinAdvancedSection(SkinPanel ui)
	{
		super( new RiverLayout(0, 0), ui );

		add("p vtop hfill", getPhotographicInfoPanel());
		add("p hfill", getTextTruncationPanel());
		add("p hfill", getOnlinePrintingPanel());
		add("p hfill", getVoiceAnnotationPanel());
	}

	private ControlPanel getTextTruncationPanel()
	{
		ControlPanel ccTextTruncation = createControlPanel("Text Truncation", 3, 1);

		ccTextTruncation.add(new JLabel("Long text strings may ruin the layout of your albums. You can specify below the maximum length of text"));
		ccTextTruncation.add("br", new JLabel("strings in two locations (use -1 to specify 'unlimited length'):"));

		ccTextTruncation.add("br hfill", ui.enableTextTruncation);
		ccTextTruncation.add("br", new JLabel("Folder Title Length on Top Path Bar"));
		ccTextTruncation.add("tab", ui.maximumFolderLengthOnPathBar);
		ccTextTruncation.add("tab", Box.createHorizontalStrut(30));
		ccTextTruncation.add(new JLabel("Thumbnail Caption Length"));
		ccTextTruncation.add("tab", ui.maximumThumbnailCaptionLength);
		return ccTextTruncation;
	}

	private ControlPanel getPhotographicInfoPanel()
	{
		ControlPanel ccExifInfo = createControlPanel("Photographic Information", 3, 1);
		JScrollPane scroll = new JScrollPane(ui.customMetadataFields);

		scroll.setPreferredSize( new Dimension(100, 100) );
		ccExifInfo.add(new JLabel("Meta-data Display Mode"));
		ccExifInfo.add("tab", ui.metadataDisplayMode);
		ccExifInfo.add("br", new JLabel("Meta-data Custom Fields"));
		ccExifInfo.add("tab hfill vfill", scroll);
		return ccExifInfo;
	}

	private ControlPanel getOnlinePrintingPanel()
	{
		ControlPanel ccOnlinePrinting = createControlPanel("On-line print ordering", 3, 1);

		ccOnlinePrinting.add(new JLabel("Printing service linking"));
		ccOnlinePrinting.add(ui.printing);

		ccOnlinePrinting.add("p", new JLabel("Each slide may contain a link that puts that image into a shopping cart for printing and delivery."));
		return ccOnlinePrinting;
	}

	private Component getVoiceAnnotationPanel()
	{
		ControlPanel ccVoiceAnnotation = createControlPanel("Voice Annotation", 3, 1);

		ccVoiceAnnotation.add(ui.showAudioConsole);
		ccVoiceAnnotation.add(Box.createHorizontalStrut(30));
		ccVoiceAnnotation.add(new JLabel("Audio Console Dimension"));
		ccVoiceAnnotation.add(ui.audioConsoleDimension);
		return ccVoiceAnnotation;
	}
}
