
import se.datadosen.component.*;

import javax.swing.*;

public class SkinAboutSection extends SkinAbstractSection
{
	public SkinAboutSection(SkinPanel ui)
	{
		super( new RiverLayout(2, 2), ui );

		add("p hfill", getAboutPanel());
	}

	private ControlPanel getAboutPanel()
	{
		ControlPanel ccAbout = createControlPanel("About...", 5);
		JLinkLabel homeLink = new JLinkLabel(Constants.SKIN_HOME_URL);
		JLinkLabel docLink = new JLinkLabel(Constants.SKIN_DOCUMENTATION_URL);
		JLinkLabel historyLink = new JLinkLabel(Constants.SKIN_CHANGES_HISTORY_URL);
		JLinkLabel forumsLink = new JLinkLabel(Constants.SKIN_FORUM_URL);
		JLinkLabel contactLink = new JLinkLabel(Constants.SKIN_AUTHOR_EMAIL);

		homeLink.setURL(Constants.SKIN_HOME_URL);
		homeLink.setToolTipText(Constants.SKIN_HOME_URL);

		docLink.setURL("http://bppdocs.camner.net");
		docLink.setToolTipText("http://bppdocs.camner.net");

		historyLink.setURL(Constants.SKIN_CHANGES_HISTORY_URL);
		historyLink.setToolTipText(Constants.SKIN_CHANGES_HISTORY_URL);

		forumsLink.setURL(Constants.SKIN_FORUM_URL);
		forumsLink.setToolTipText(Constants.SKIN_FORUM_URL);

		contactLink.setURL("mailto:" + Constants.SKIN_AUTHOR_EMAIL);
		contactLink.setToolTipText(Constants.SKIN_AUTHOR_EMAIL);

		ccAbout.add(new JLabel("Skin Date/Version:"));
		ccAbout.add("tab", new JLabel(Constants.SKIN_RELEASE_DATE + " (" + Constants.SKIN_VERSION + ")"));
		ccAbout.add("br", new JLabel("Home Page:"));
		ccAbout.add("tab", homeLink);
		ccAbout.add("br", new JLabel("Documentation & User Guide:"));
		ccAbout.add("tab", docLink);
		ccAbout.add("br", new JLabel("Changes History:"));
		ccAbout.add("tab", historyLink);
		ccAbout.add("br", new JLabel("Forums:"));
		ccAbout.add("tab", forumsLink);
		ccAbout.add("br", new JLabel("Contact Author:"));
		ccAbout.add("tab", new JLabel(Constants.SKIN_AUTHOR_NAME + " ("));
		ccAbout.add(contactLink);
		ccAbout.add(new JLabel(")"));
		return ccAbout;
	}
}
