
import se.datadosen.jalbum.AlbumBean;

import java.text.MessageFormat;
import java.util.Map;
import java.io.File;
import java.awt.*;

public class OriginalSlide extends AbstractSlide
{
	private static final String IMAGE_TEMPLATE = "<img src=\"{0}\" alt=\"{1}\"/>";
	private static final String LINK_TEMPLATE = "<a href=\"{0}\" title=\"{1}\">{2}</a>";

	public OriginalSlide(AlbumBean engine)
	{
		super(engine);
	}

	public String getCurrentOriginalSlideContent()
	{
		Map vars = (Map)fileVariables.get(currentFile);
		String block;

		if( isMovieFile(currentFile) )
		{
			fixMediaLocation( currentFile );
			block = getMovieBlock(currentFile.getName(), getMovieSlideSize());
		}
		else if( isAudioFile(currentFile) )
		{
			fixMediaLocation( currentFile );
			if( !outputDirectory.equals(imageDirectory) )
			{
				// Deleting the wrongly copied standalone-audio file by JAlbum (the standalone-audios should be located
				// inside "slides"/current folder instead of the root for security reasons)
				File invalidDestAudio = new File(outputDirectory.getPath(), currentFile.getName());

				if( invalidDestAudio.exists() )
					invalidDestAudio.delete();
			}

			Dimension audioConsoleSize = getAudioConsoleSize();
			Object[] args = new Object[] {currentFile.getName(), new Integer(audioConsoleSize.width), new Integer(audioConsoleSize.height)};

			block = MessageFormat.format(MediaUtils.getAudioBlockTemplate(), args);
		}
		else
		{
			if( isVariableValueEqual( Constants.USER_VAR_INCLUDE_MOVE_FORWARD_FACILITY, imageDirectory, true ) )
			{
				if( !isEmptyString(nextPage) )
				{
					block = MessageFormat.format(IMAGE_TEMPLATE, new Object[] {vars.get("originalPath"), texts.getString("next-slide")});
					block = MessageFormat.format(LINK_TEMPLATE, new Object[] {"javascript:nextPage()", texts.getString("next-slide"), block});
				}
				else
					block = MessageFormat.format(IMAGE_TEMPLATE, new Object[] {vars.get("originalPath"), texts.getString("on-last-slide")});
			}
			else
			{
				block = MessageFormat.format(IMAGE_TEMPLATE, new Object[] {vars.get("originalPath"), texts.getString("up")});
				block = MessageFormat.format(LINK_TEMPLATE, new Object[] {vars.get("currentPage"), texts.getString("up"), block});
			}
		}

		return block;
	}
}
