import java.io.File;
import java.util.*;

/**
 * User: armond
 */
public final class MediaUtils
{
/*
	private static final String MOVIE_BLOCK_TEMPLATE = "<embed align=\"center\" src=\"{0}\"" +
			" width=\"{1}\" height=\"{2}\" autoplay=\"true\" controller=\"true\" cache=\"true\"" +
			" pluginspage=\"http://www.apple.com/quicktime/download/\"></embed>\n";

	protected static final String VOICE_ANNOTATION_BLOCK_TEMPLATE = "<embed src=\"{0}\" width=\"{1}\" height=\"{2}\" controls=\"console\" autostart=\"true\"></embed>";
	protected static final String VOICE_ANNOTATION_HIDDEN_BLOCK_TEMPLATE = "<embed src=\"{0}\" hidden=\"true\" width=\"0\" height=\"0\" autostart=\"true\"></embed>";
	private static final String[] SUPPORTED_AUDIO_TYPES = new String[] {"wav", "mp3", "wma", "voc", "mid", "au", "rm"};
	private static final String[] SUPPORTED_MOVIE_TYPES = {".AVI", ".MOV", ".MPG", ".MPEG", ".WMV", ".MP4", ".DIVX", ".XVID", ".3GP"};
*/
	private static String[] supportedVideoTypes = null;
	private static String audioBlockTemplate = null;
	private static String audioHiddenBlockTemplate = null;
	private static Map videoBlockTemplate = null;
	private static final String DEFAULT_VIDEO_BLOCK_TEMPLATE = "DEFAULT_VIDEO_BLOCK_TEMPLATE";

	private static String[] supportedAudioTypes = null;

	private static File skinDirectory;

	public static void setSkinDirectory( File skinDirectory )
	{
		MediaUtils.skinDirectory = skinDirectory;
	}

	private static String[] readExtensionsConfigFile( File file)
	{
		String fileContent = GeneralUtils.readTextFile( file );
		StringTokenizer st = new StringTokenizer( fileContent, "\r\n" );
		List extensions = new ArrayList();

		while( st.hasMoreTokens() )
			extensions.add( st.nextToken() );

		return (String[]) extensions.toArray( new String[0] );
	}

	public static String[] getSupportedVideoTypes()
	{
		if( supportedVideoTypes==null )
			supportedVideoTypes = readExtensionsConfigFile( new File( skinDirectory, Constants.SKIN_SUPPORTED_VIDEO_TYPES ) );

		return supportedVideoTypes;
	}

	public static String[] getSupportedAudioTypes()
	{
		if( supportedAudioTypes==null )
			supportedAudioTypes = readExtensionsConfigFile( new File( skinDirectory, Constants.SKIN_SUPPORTED_AUDIO_TYPES ) );

		return supportedAudioTypes;
	}

	public static String getAudioBlockTemplate()
	{
		if( audioBlockTemplate==null )
			audioBlockTemplate = GeneralUtils.readTextFile( new File( skinDirectory, Constants.SKIN_AUDIO_BLOCK_CONFIG_NAME ) );

		return audioBlockTemplate;
	}

	public static String getAudioHiddenBlockTemplate()
	{
		if( audioHiddenBlockTemplate==null )
			audioHiddenBlockTemplate = GeneralUtils.readTextFile( new File( skinDirectory, Constants.SKIN_AUDIO_HIDDEN_BLOCK_CONFIG_NAME ) );

		return audioHiddenBlockTemplate;
	}

	public static String getVideoBlockTemplate(String videoType)
	{
		if( videoBlockTemplate==null )
		{
			File file = new File( skinDirectory, Constants.SKIN_VIDEO_BLOCK_CONFIG_NAME + Constants.SKIN_BLOCK_CONFIG_EXTENTION );
			String[] supportedVideoTypes = getSupportedVideoTypes();

			videoBlockTemplate = new HashMap();
			videoBlockTemplate.put( DEFAULT_VIDEO_BLOCK_TEMPLATE, GeneralUtils.readTextFile( file ) );

			for( int i = 0; i < supportedVideoTypes.length; i++ )
			{
				String supportedVideoType = supportedVideoTypes[i];

				file = new File( skinDirectory, Constants.SKIN_VIDEO_BLOCK_CONFIG_NAME + "-" + supportedVideoType + Constants.SKIN_BLOCK_CONFIG_EXTENTION );
				if( file.exists() )
					videoBlockTemplate.put( supportedVideoType, GeneralUtils.readTextFile( file ) );
			}
		}

		if( videoBlockTemplate.containsKey( videoType ) )
			return (String) videoBlockTemplate.get( videoType );
		else
			return (String) videoBlockTemplate.get( DEFAULT_VIDEO_BLOCK_TEMPLATE );
	}
}
