
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import javax.swing.*;

public class FrameTypeComboBox extends JComboBox
{
	private File framesDirectory;

	public FrameTypeComboBox(File framesDirectory)
	{
		if( framesDirectory==null || !framesDirectory.isDirectory() )
			throw new IllegalArgumentException("The frames' directory object is not a real directory!");

		this.framesDirectory = framesDirectory;
		setModel( new FrameTypeComboBoxModel() );

		Dimension size = new Dimension( 120, getPreferredSize().height);

		setSize( size );
		setPreferredSize( size );

		addFocusListener( new FocusAdapter() {
			public void focusGained(FocusEvent e)
			{
				((FrameTypeComboBoxModel)getModel()).updateContent();
			}
		});
	}

	private class FrameTypeComboBoxModel extends DynamicComboBoxModel implements FilenameFilter
	{
		public FrameTypeComboBoxModel()
		{
			updateContent();
		}

		public void updateContent()
		{
			File[] files = framesDirectory.listFiles(this);

			model.clear();
			model.add("");
			for( int i = 0; i<files.length; i++ )
			{
				File file = files[i];
				String frameName = file.getName().substring(0, file.getName().toLowerCase().indexOf(Constants.SKIN_FRAME_CONFIG_EXTENSION));

				model.add(frameName);
			}

			Collections.sort(model);
			if( !model.contains(selectedObject) )
				selectedObject = model.get(0);
			fireContentsChanged(this, -1, -1);
		}

		public boolean accept(File dir, String name)
		{
			return name.toLowerCase().endsWith(Constants.SKIN_FRAME_CONFIG_EXTENSION) && (new File(dir, name).isFile());
		}
	}
}
