/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util.httpClient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpResponse {
    private int statusCode;
    private String reason;
    private Hashtable headers;
    private ByteArrayOutputStream rawContent = new ByteArrayOutputStream();

    public HttpResponse(int statusCode, String reason, Hashtable headers, InputStream input) throws IOException {
        this.statusCode = statusCode;
        this.reason = reason;
        this.headers = headers;
        String contentLength = this.getHeader("Content-Length");
        String transferEncoding = this.getHeader("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            DataInputStream data = new DataInputStream(input);
            int bytesLeft = this.getChunkSize(data);
            while (bytesLeft > 0) {
                int d2;
                while ((d2 = data.read()) > -1 && bytesLeft-- != 0) {
                    this.rawContent.write(d2);
                }
                bytesLeft = this.getChunkSize(data);
            }
        } else {
            int bytesLeft;
            int n2 = bytesLeft = contentLength != null ? Integer.parseInt(contentLength) : -1;
            if (statusCode == 200) {
                int d3;
                while ((d3 = input.read()) > -1 && bytesLeft-- != 0) {
                    this.rawContent.write(d3);
                }
            }
        }
        this.rawContent.close();
    }

    private int getChunkSize(DataInputStream input) throws IOException {
        String chunkSizeLine = input.readLine();
        if (chunkSizeLine.equals("")) {
            chunkSizeLine = input.readLine();
        }
        StringTokenizer tokens = new StringTokenizer(chunkSizeLine);
        String chunkSize = tokens.nextToken();
        chunkSize = chunkSize.trim();
        return Integer.parseInt(chunkSize, 16);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonLine() {
        return this.reason;
    }

    public Hashtable getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        return (String)this.headers.get(key.toUpperCase());
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.rawContent.toByteArray());
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        return this.rawContent.toString("UTF-8");
    }
}

