/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JColorSelector;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Attributizer;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.PersistentList;

public class PropertyBinder {
    public static Properties getProperties(JComponentHolder jComponentHolder) {
        return PropertyBinder.getProperties(jComponentHolder, new Properties());
    }

    public static Properties getProperties(JComponentHolder jComponentHolder, Properties existing) {
        Properties props = existing;
        try {
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            for (int i2 = 0; i2 < fields.length; ++i2) {
                String name = fields[i2].getName();
                fields[i2].setAccessible(true);
                int mods = fields[i2].getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) continue;
                Object comp = fields[i2].get(jComponentHolder);
                if (comp instanceof JComponentHolder) {
                    Properties subProps = PropertyBinder.getProperties((JComponentHolder)comp);
                    props.putAll((Map<?, ?>)subProps);
                    continue;
                }
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        props.setProperty(name, tc.getText());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        Object sel = jc.getSelectedItem();
                        if (sel == null) continue;
                        if (sel instanceof Item) {
                            sel = ((Item)sel).value.toString();
                        }
                        props.setProperty(name, sel.toString());
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb2 = (JCheckBox)comp;
                        props.setProperty(name, cb2.isSelected() ? "true" : "false");
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs2 = (JColorSelector)comp;
                        props.setProperty(name, cs2.getHTMLColor());
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        props.setProperty(name, "" + js.getValue());
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    props.setProperty(name, PropertyBinder.toAttributes(((PersistentList)comp).getContent()));
                    continue;
                }
                if (comp instanceof ButtonGroup) {
                    ButtonGroup bg2 = (ButtonGroup)comp;
                    Enumeration<AbstractButton> buttons = bg2.getElements();
                    while (buttons.hasMoreElements()) {
                        AbstractButton button = buttons.nextElement();
                        if (!button.isSelected()) continue;
                        props.setProperty(name, button.getActionCommand());
                    }
                    continue;
                }
                if (!(comp instanceof Attributizer)) continue;
                Attributizer attr = (Attributizer)comp;
                props.setProperty(name, attr.getAttributes());
            }
            return props;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static void syncUI(Map props, JComponentHolder jComponentHolder) {
        try {
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            block4: for (int i2 = 0; i2 < fields.length; ++i2) {
                String name = fields[i2].getName();
                fields[i2].setAccessible(true);
                int mods = fields[i2].getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) continue;
                Object comp = fields[i2].get(jComponentHolder);
                if (!props.containsKey(name) && !(comp instanceof JComponentHolder)) continue;
                if (comp instanceof JComponentHolder) {
                    PropertyBinder.syncUI(props, (JComponentHolder)comp);
                    continue;
                }
                String value = props.get(name).toString();
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        tc.setText(value);
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        boolean setOk = false;
                        for (int k2 = 0; k2 < jc.getItemCount(); ++k2) {
                            Object item = jc.getItemAt(k2);
                            if (item instanceof Integer) {
                                item = ((Integer)item).toString();
                            }
                            if (!item.equals(value)) continue;
                            jc.setSelectedIndex(k2);
                            setOk = true;
                            break;
                        }
                        if (setOk) continue;
                        jc.setSelectedItem(value);
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb2 = (JCheckBox)comp;
                        cb2.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs2 = (JColorSelector)comp;
                        cs2.setColor(value);
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        js.setValue(Integer.parseInt(value));
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    try {
                        String val;
                        ArrayList<String> values = new ArrayList<String>();
                        Properties p2 = AttributeTokenizer.getProperties(value);
                        int j2 = 1;
                        while ((val = p2.getProperty("item" + j2)) != null) {
                            values.add(val);
                            ++j2;
                        }
                        ((PersistentList)comp).setContent(values.toArray(new String[values.size()]));
                        continue;
                    }
                    catch (ElementException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (!(comp instanceof ButtonGroup)) continue;
                ButtonGroup bg2 = (ButtonGroup)comp;
                Enumeration<AbstractButton> buttons = bg2.getElements();
                while (buttons.hasMoreElements()) {
                    AbstractButton button = buttons.nextElement();
                    String ac = button.getActionCommand();
                    if (ac == null || !ac.equals(value)) continue;
                    bg2.setSelected(button.getModel(), true);
                    continue block4;
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private static String toAttributes(String[] values) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (!first) {
                buf.append(' ');
            }
            first = false;
            buf.append("item" + (i2 + 1) + "=\"" + values[i2] + "\"");
        }
        return buf.toString();
    }
}

