/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import se.datadosen.component.JSmartTextArea;

public class Debug {
    public static void showErrorDialog(Component parent, Throwable t2) {
        if (t2 instanceof RuntimeException) {
            Debug.showStackTraceDialog(parent, t2);
        } else {
            JOptionPane.showMessageDialog(parent, t2.toString(), "An error occured", 0);
        }
    }

    public static void showStackTraceDialog(Component parent, Throwable t2) {
        t2.printStackTrace(System.out);
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println("An unexpected error occured. Please see detailed description below:");
        err.println("");
        t2.printStackTrace(err);
        err.close();
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        sp.getViewport().add((Component)ta, null);
        JOptionPane.showMessageDialog(parent, sp, "Unexpected error occured", 0);
    }

    public static void showCopyableError(Component parent, Throwable t2, String title) {
        JScrollPane sp = new JScrollPane();
        StringWriter sw = new StringWriter();
        PrintWriter err = new PrintWriter(sw);
        err.println(t2.getMessage());
        err.close();
        JSmartTextArea ta = new JSmartTextArea(sw.toString());
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setColumns(80);
        ta.setRows(15);
        sp.getViewport().add((Component)ta, null);
        JOptionPane.showMessageDialog(parent, sp, title, 0);
    }

    public static void printClassInfo(Class c2) {
        System.out.println("Class info:");
        do {
            System.out.println(c2.getName() + " Loader: " + c2.getClassLoader());
        } while ((c2 = c2.getSuperclass()) != null);
    }
}

