/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.IOException;
import se.datadosen.util.Segment;

class APP1Segment {
    boolean bigEndian = false;
    Segment seg;
    byte[] data;
    int entries;
    int firstEntryOffset;

    public APP1Segment(Segment seg) throws IOException {
        if (seg.getId() != -31) {
            throw new IOException("Not an APP1 segment");
        }
        this.seg = seg;
        this.data = seg.getData();
        String exifId = new String(this.data, 0, 4);
        if (!"Exif".equals(exifId)) {
            throw new IOException("Couldn't find Exif id in APP1 segment: " + exifId);
        }
        String byteOrder = new String(this.data, 6, 2);
        this.bigEndian = "MM".equals(byteOrder);
        int countOffset = this.get32Bits(10) + 6;
        this.firstEntryOffset = countOffset + 2;
        this.entries = this.get16Bits(countOffset);
    }

    public int getEntryCount() {
        return this.entries;
    }

    boolean nextIFD() {
        int offsetOfNextIFDOffset = this.firstEntryOffset + this.entries * 12;
        int nextIFDOffset = this.get32Bits(offsetOfNextIFDOffset) + 6;
        if (nextIFDOffset == 6) {
            return false;
        }
        if (nextIFDOffset >= this.data.length) {
            return false;
        }
        this.entries = this.get16Bits(nextIFDOffset);
        this.firstEntryOffset = nextIFDOffset + 2;
        return true;
    }

    public Entry getEntry(int i2) {
        if (i2 >= this.entries) {
            throw new IndexOutOfBoundsException();
        }
        return new Entry(this.firstEntryOffset + 12 * i2);
    }

    private int get16Bits(int offset) {
        if (this.bigEndian) {
            return this.data[offset] << 8 & 0xFF00 | this.data[offset + 1] & 0xFF;
        }
        return this.data[offset + 1] << 8 & 0xFF00 | this.data[offset] & 0xFF;
    }

    private void set16Bits(int value, int offset) {
        if (this.bigEndian) {
            this.data[offset] = (byte)(value >> 8 & 0xFF);
            this.data[offset + 1] = (byte)(value & 0xFF);
        } else {
            this.data[offset] = (byte)(value & 0xFF);
            this.data[offset + 1] = (byte)(value >> 8 & 0xFF);
        }
    }

    private int get32Bits(int offset) {
        if (this.bigEndian) {
            return this.data[offset] << 24 & 0xFF000000 | this.data[offset + 1] << 16 & 0xFF0000 | this.data[offset + 2] << 8 & 0xFF00 | this.data[offset + 3] & 0xFF;
        }
        return this.data[offset + 3] << 24 & 0xFF000000 | this.data[offset + 2] << 16 & 0xFF0000 | this.data[offset + 1] << 8 & 0xFF00 | this.data[offset] & 0xFF;
    }

    class Entry {
        public static final int SIZE = 12;
        int tagNr;
        int offset;

        public Entry(int offset) {
            this.offset = offset;
            this.tagNr = APP1Segment.this.get16Bits(offset);
        }

        public int getTagNr() {
            return this.tagNr;
        }

        public int getValue() {
            return APP1Segment.this.get16Bits(this.offset + 8);
        }

        public void setValue(int newValue) throws IOException {
            APP1Segment.this.set16Bits(newValue, this.offset + 8);
            this.writeToDisk();
        }

        private void writeToDisk() throws IOException {
            APP1Segment.this.seg.file.seek(APP1Segment.this.seg.getDataOffset() + (long)this.offset);
            APP1Segment.this.seg.file.write(APP1Segment.this.data, this.offset, 12);
        }
    }
}

