/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Element {
    String name;
    boolean evalScriptlet = false;
    boolean definitionScriptlet = false;
    String preElement;
    String content;
    String postElement;
    int postIndex;
    Map attributes = new HashMap();
    List contentElements;

    public Element() {
    }

    public Element(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPreElement() {
        return this.preElement;
    }

    public String getPostElement() {
        return this.postElement;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public String getContent() {
        return this.content;
    }

    public List getContentElements() {
        return this.contentElements;
    }

    public void setContentElements(List contentElements) {
        this.contentElements = contentElements;
    }

    public void addContentElement(Element el) {
        if (this.contentElements == null) {
            this.contentElements = new LinkedList();
        }
        this.contentElements.add(el);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attr) {
        this.attributes = attr;
    }

    public void setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, "" + value);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, "" + value);
    }

    public String getAttribute(String attr) {
        return (String)this.attributes.get(attr);
    }

    public boolean getBooleanAttribute(String attr) {
        return "true".equals(this.getAttribute(attr));
    }

    public String getAttribute(String attr, String def) {
        String val = this.getAttribute(attr);
        return val != null ? val : def;
    }

    public boolean isEvalScriptlet() {
        return this.evalScriptlet;
    }

    public boolean isDefinitionScriptlet() {
        return this.definitionScriptlet;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.spaces(indent) + "<" + this.name);
        Iterator it = this.attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            buf.append(" " + e2.getKey() + "=\"" + e2.getValue() + "\"");
        }
        if (this.contentElements != null && this.contentElements.size() > 0) {
            buf.append(">\n");
            it = this.contentElements.iterator();
            while (it.hasNext()) {
                Element el = (Element)((Object)it.next());
                buf.append(el.toString(indent + 2));
            }
            buf.append(this.spaces(indent) + "</" + this.name + ">\n");
        } else {
            buf.append("/>\n");
        }
        return buf.toString();
    }

    private String spaces(int count) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < count; ++i2) {
            buf.append(' ');
        }
        return buf.toString();
    }
}

