/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NoValidSkinException;

public class SkinManager {
    public static final String JALBUM_SKIN_EXTENSION = ".jaskin";
    private Set ignoreDirs = new HashSet(){
        {
            this.add("__MACOSX");
        }
    };
    private ProgressMonitor progressMonitor;

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void addIgnoreDir(String dir2) {
        this.ignoreDirs.add(dir2);
    }

    private boolean isIgnored(String path) {
        Iterator it = this.ignoreDirs.iterator();
        while (it.hasNext()) {
            String ignoreDir = (String)it.next();
            if (!path.startsWith(ignoreDir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInstallSkin(File skinFile, File skinsDir) throws ZipException, IOException {
        ZipFile zf = new ZipFile(skinFile);
        try {
            if (this.progressMonitor != null) {
                this.progressMonitor.setMinimum(1);
                this.progressMonitor.setMaximum(zf.size());
            }
            File destDir = skinsDir;
            String currentPath = "";
            int counter = 1;
            Enumeration<? extends ZipEntry> files = zf.entries();
            while (files.hasMoreElements()) {
                ZipEntry e2 = files.nextElement();
                String p2 = this.pathOf(e2);
                if (!this.isIgnored(p2)) {
                    if (!p2.equals(currentPath)) {
                        currentPath = p2;
                        destDir = new File(skinsDir, currentPath);
                        destDir.mkdirs();
                    }
                    File destFile = new File(destDir, this.nameOf(e2));
                    if (e2.isDirectory()) {
                        if (!this.isIgnored(this.nameOf(e2))) {
                            destFile.mkdir();
                        }
                    } else {
                        BufferedInputStream in = new BufferedInputStream(zf.getInputStream(e2));
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                        try {
                            byte[] buffer;
                            int bytesRead;
                            while ((bytesRead = in.read(buffer = new byte[65536])) != -1) {
                                out.write(buffer, 0, bytesRead);
                            }
                        }
                        finally {
                            in.close();
                            out.close();
                            destFile.setLastModified(e2.getTime());
                        }
                    }
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.setProgress(counter);
                    if (this.progressMonitor.isCanceled()) {
                        break;
                    }
                }
                ++counter;
            }
        }
        finally {
            zf.close();
        }
    }

    public void installSkin(File skinFile) {
        Config config = Config.getConfig();
        this.installSkin(skinFile, config.chainedSkinsDir.getDirectory());
    }

    public void installSkin(final File skinFile, final File skinsDir) {
        try {
            skinsDir.mkdirs();
            final Set skins = this.listSkins(skinFile);
            Object[] a2 = skins.toArray();
            JCheckBox[] selections = new JCheckBox[a2.length];
            ControlPanel skinPanel = new ControlPanel();
            ((RiverLayout)skinPanel.getLayout()).setHgap(0);
            skinPanel.add(new JLabel(Msg.getString("sm.skinInstallerInfo")));
            for (int i2 = 0; i2 < a2.length; ++i2) {
                String skinName;
                File skinDir = new File(skinsDir, skinName = a2[i2].toString());
                selections[i2] = new JCheckBox(skinName, !skinDir.exists());
                skinPanel.add("br", selections[i2]);
                if (!skinDir.exists()) continue;
                JLabel label = new JLabel("(" + Msg.getString("sm.alreadyInstalledWarning") + ")");
                skinPanel.add(label);
            }
            int answer = JOptionPane.showConfirmDialog(null, skinPanel, Msg.getString("sm.skinManagerTitle"), 2, 1);
            if (answer != 0) {
                return;
            }
            for (int i3 = 0; i3 < selections.length; ++i3) {
                if (selections[i3].isSelected()) continue;
                this.addIgnoreDir(selections[i3].getText());
            }
            UIManager.put("ProgressMonitor.progressText", Msg.getString("sm.skinManagerTitle"));
            final ProgressMonitor pm = new ProgressMonitor(null, Msg.getString("sm.installingSkinInfo") + "...", null, 1, 1);
            this.setProgressMonitor(pm);
            Thread installThread = new Thread("Skin install thread"){

                public void run() {
                    try {
                        SkinManager.this.doInstallSkin(skinFile, skinsDir);
                        if (!pm.isCanceled() && SkinManager.this.ignoreDirs.size() - 1 < skins.size()) {
                            JOptionPane.showMessageDialog(null, Msg.getString("sm.skinInstalledInfo"), Msg.getString("sm.skinManagerTitle"), 1);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.getString("sm.skinManagerTitle"), 0);
                    }
                }
            };
            installThread.start();
        }
        catch (NoValidSkinException ex) {
            JOptionPane.showMessageDialog(null, Msg.getString("sm.notAValidSkinFileError"), Msg.getString("sm.skinManagerTitle"), 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.getString("sm.skinManagerTitle"), 0);
        }
    }

    private String pathOf(ZipEntry e2) {
        int i2;
        String s2 = e2.getName();
        if (s2.endsWith("/")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        if ((i2 = s2.lastIndexOf(47)) == -1) {
            return "";
        }
        return s2.substring(0, i2);
    }

    private String nameOf(ZipEntry e2) {
        int i2;
        String s2 = e2.getName();
        if (s2.endsWith("/")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        if ((i2 = s2.lastIndexOf(47)) == -1) {
            return s2;
        }
        return s2.substring(i2 + 1);
    }

    public Set listSkins(File skinFile) throws NoValidSkinException, ZipException, IOException {
        ZipFile zf = new ZipFile(skinFile);
        TreeSet<String> names = new TreeSet<String>();
        Enumeration<? extends ZipEntry> files = zf.entries();
        while (files.hasMoreElements()) {
            ZipEntry e2 = files.nextElement();
            String rootName = this.rootOf(e2);
            if (this.ignoreDirs.contains(rootName)) continue;
            names.add(rootName);
        }
        if (names.size() == 0) {
            throw new NoValidSkinException();
        }
        return names;
    }

    private String rootOf(ZipEntry e2) throws NoValidSkinException {
        int i2;
        String s2 = e2.getName();
        if (s2.endsWith("/")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        if ((i2 = s2.indexOf(47)) == -1) {
            if (e2.isDirectory()) {
                return s2;
            }
            throw new NoValidSkinException();
        }
        return s2.substring(0, i2);
    }
}

