/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.UploadListener;
import se.datadosen.util.Stopwatch;

public class JUploadProgressDialog
extends JDialog
implements UploadListener {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel mainPanel = new JPanel();
    JPanel ButtonPanel = new JPanel();
    JButton abortButton = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JLabel directory = new JLabel();
    JProgressBar progressBar = new JProgressBar();
    JLabel file = new JLabel();
    JLabel timeLeft = new JLabel();
    Stopwatch timer = new Stopwatch();
    boolean abort = false;
    String lastMsg = "";

    public JUploadProgressDialog(JPublishWizard owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.abortButton.setText(Msg.getString("abort"));
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JUploadProgressDialog.this.abortButton_actionPerformed(e2);
            }
        });
        this.ButtonPanel.setLayout(this.flowLayout1);
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.getString("upload.processingInfo"));
        this.file.setText(Msg.getString("upload.fileLabel"));
        this.timeLeft.setText(Msg.getString("upload.estimatedTimeLeftInfo"));
        this.progressBar.setString(Msg.getString("upload.countLabel"));
        this.panel1.setPreferredSize(new Dimension(300, 151));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                JUploadProgressDialog.this.this_windowClosing(e2);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.mainPanel, "Center");
        this.mainPanel.add("br", this.directory);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br hfill", this.progressBar);
        this.mainPanel.add("br", this.timeLeft);
        this.panel1.add((Component)this.ButtonPanel, "South");
        this.ButtonPanel.add((Component)this.abortButton, null);
    }

    private static String twoDigits(int x2) {
        if (x2 < 10) {
            return "0" + x2;
        }
        return "" + x2;
    }

    public static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return "" + hours + ":" + JUploadProgressDialog.twoDigits(minutes) + ":" + JUploadProgressDialog.twoDigits(seconds);
    }

    public void imageProcessingStarted(AlbumBeanEvent e2) {
        if (!this.isVisible() && !this.abort) {
            new Thread(){

                public void run() {
                    JUploadProgressDialog.this.setVisible(true);
                }
            }.start();
        }
        if (this.abort) {
            e2.abortProcessing();
        }
        this.directory.setText(Msg.getString("upload.processingInfo") + " " + e2.directory);
        this.progressBar.setValue(e2.processedFiles);
        this.progressBar.setMaximum(e2.totalFiles);
        this.file.setText(e2.msg);
        this.lastMsg = e2.msg;
        this.progressBar.setString(MessageFormat.format(Msg.getString("upload.processingInfo2"), new Integer(e2.processedFiles), new Integer(e2.totalFiles)));
    }

    public void imageProcessingFinished(AlbumBeanEvent e2) {
        if (this.abort) {
            e2.abortProcessing();
        }
        long elapsed = this.timer.getMillis();
        long totalMillis = (long)e2.totalFiles * elapsed / (long)e2.processedFiles;
        int secsLeft = (int)(totalMillis - elapsed) / 1000;
        this.timeLeft.setText(Msg.getString("upload.estimatedTimeLeftInfo") + " " + JUploadProgressDialog.timerFormat(secsLeft));
    }

    public void errorOccured(Throwable t2, File f2) {
    }

    public void bytesTransferred(long count) {
        this.file.setText(this.lastMsg + " " + count + " " + Msg.getString("upload.bytesInfo"));
    }

    public void byteRead(int bytes) {
    }

    void abortButton_actionPerformed(ActionEvent e2) {
        this.abort = true;
        this.setVisible(false);
        this.dispose();
    }

    public void setVisible(boolean show) {
        if (show) {
            Dimension parentSize = this.getOwner().getSize();
            Dimension mySize = this.getSize();
            Point loc = this.getOwner().getLocation();
            this.setLocation(loc.x + (parentSize.width - mySize.width) / 2, loc.y + (parentSize.height - mySize.height) / 2);
            this.directory.setText(Msg.getString("upload.comparingFilesInfo"));
            this.progressBar.setStringPainted(true);
            this.file.setText(" ");
            this.progressBar.setString(" ");
            this.timeLeft.setText(" ");
            this.progressBar.setValue(0);
            this.timer.reset();
            this.timer.start();
            this.abort = false;
        }
        super.setVisible(show);
    }

    void this_windowClosing(WindowEvent e2) {
        this.abort = true;
    }
}

