/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JMapTable;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.buttonbar.JButtonBarPane;
import se.datadosen.component.buttonbar.PercentLayout;
import se.datadosen.dnd.FileDropEvent;
import se.datadosen.dnd.FileDropListener;
import se.datadosen.dnd.JFileDropPanel;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NumericVerifier;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.util.Item;
import se.datadosen.util.PropertyBinder;

public class JSettingsWindow
extends JSmartDialog {
    private JAlbumFrame mainFrame;
    private JButtonBarPane buttonBarPane = new JButtonBarPane();
    private ControlPanel generalPanel = new ControlPanel();
    private ControlPanel imagesPanel = new ControlPanel();
    private ControlPanel navigationPanel = new ControlPanel();
    private JTabbedPane advancedPanel = new JTabbedPane();
    private ControlPanel advGeneralPanel = new ControlPanel();
    private ControlPanel advMetadataPanel = new ControlPanel();
    private ControlPanel advNamingPanel = new ControlPanel();
    private ControlPanel advUserVariablesPanel = new ControlPanel();
    private ImageIcon thumbnailsSlideIcon = new ImageIcon(this.getClass().getResource("images/linking/thsd.png"));
    private ImageIcon thumbnailsSlideOriginalIcon = new ImageIcon(this.getClass().getResource("images/linking/thsdor.png"));
    private ImageIcon thumbnailsOriginalIcon = new ImageIcon(this.getClass().getResource("images/linking/thor.png"));
    private ImageIcon thumbnailsOriginalsNoSlidesIcon = new ImageIcon(this.getClass().getResource("images/linking/thorns.png"));
    private ImageIcon thumbnailsScaledNoSlidesIcon = new ImageIcon(this.getClass().getResource("images/linking/thsdns.png"));
    private ImageIcon bboxIcon = new ImageIcon(this.getClass().getResource("images/bbox.png"));
    private Component currentPanel;
    JPanel skinSettingsPanel = new JPanel();
    ControlPanel skinUI = null;
    JLabel directoryLabel = new JLabel();
    public JTextField directory = new JSmartTextField(30);
    JButton chooseDirectoryButton = new JButton();
    JLabel outputDirectoryLabel = new JLabel();
    JTextField outputDirectory = new JSmartTextField(30);
    JButton chooseOutputDirectoryButton = new JButton();
    JFileDropPanel outputDirectoryPanel = new JFileDropPanel();
    JCheckBox sameDirectory = new JCheckBox();
    JCheckBox copyOriginals = new JCheckBox();
    JCheckBox subdirs = new JCheckBox();
    JCheckBox slides = new JCheckBox();
    ControlPanel imageLinkingPanel = new ControlPanel();
    JLabel linkingGuide = new JLabel(this.thumbnailsSlideOriginalIcon);
    ButtonGroup imageLinking = new ButtonGroup();
    JRadioButton linkOriginals = new JRadioButton();
    JRadioButton linkOriginalsViaScaled = new JRadioButton();
    JRadioButton linkScaled = new JRadioButton();
    ControlPanel imageBoundsPanel = new ControlPanel();
    JLabel thumbSizeLabel = new JLabel();
    JComboBox thumbSize = new JComboBox<String>(new String[]{"240x240", "180x180", "160x160", "124x124", "90x90"});
    JLabel imageSizeLabel = new JLabel();
    JComboBox imageSize = new JComboBox<String>(new String[]{"1024x1024", "800x800", "720x720", "640x640", "512x512", "400x400"});
    ControlPanel thumbnailLayoutPanel = new ControlPanel();
    JLabel colsLabel = new JLabel();
    JTextField cols = new JSmartTextField(4);
    JLabel rowsLabel = new JLabel();
    JTextField rows = new JSmartTextField(4);
    ControlPanel imageOrderingPanel = new ControlPanel();
    JComboBox imageOrdering = new JComboBox();
    JCheckBox reverseOrder = new JCheckBox();
    JCheckBox directoriesFirst = new JCheckBox();
    DeferredChooser directoryChooser = new DeferredChooser(class$se$datadosen$component$JDirectoryChooser == null ? (class$se$datadosen$component$JDirectoryChooser = JSettingsWindow.class$("se.datadosen.component.JDirectoryChooser")) : class$se$datadosen$component$JDirectoryChooser);
    DeferredChooser outputDirectoryChooser = new DeferredChooser(class$se$datadosen$component$JDirectoryChooser == null ? (class$se$datadosen$component$JDirectoryChooser = JSettingsWindow.class$("se.datadosen.component.JDirectoryChooser")) : class$se$datadosen$component$JDirectoryChooser);
    JFileDropPanel jFileDropPanel1 = new JFileDropPanel();
    JLabel qualityPercentLabel = new JLabel();
    JSlider qualityPercent = new JSlider(0, 0, 100, 75);
    JLabel sharpenPercentLabel = new JLabel();
    JSlider sharpenPercent = new JSlider(0, 0, 100, 50);
    JLabel scalingMethodLabel = new JLabel();
    JComboBox scalingMethod = new JComboBox();
    JCheckBox progressiveMode = new JCheckBox();
    JCheckBox keepMetaData = new JCheckBox();
    ControlPanel commentSourcesPanel = new ControlPanel();
    JCheckBox textFileComment = new JCheckBox();
    JCheckBox jpegComment = new JCheckBox();
    JCheckBox iptcCaption = new JCheckBox();
    JCheckBox exifUserComment = new JCheckBox();
    JCheckBox exifImageDescription = new JCheckBox();
    JTextField dateFormat = new JSmartTextField(16);
    JLabel dateFormatLabel = new JLabel();
    JCheckBox urlEncode = new JCheckBox();
    JTextField indexPageName = new JTextField(20);
    JLabel indexPageNameLabel = new JLabel();
    JCheckBox metaData = new JCheckBox();
    JCheckBox updatedDirsOnly = new JCheckBox();
    JCheckBox excludeByDefault = new JCheckBox();
    JCheckBox classicReaders = new JCheckBox();
    JCheckBox useThumbForFolderIcon = new JCheckBox();
    JLabel dateFormatTemplateLabel = new JLabel();
    JTextField pageExtension = new JTextField(20);
    JLabel pageExtensionLabel = new JLabel();
    JTextField thumbnailDirectory = new JTextField(20);
    JLabel thumbnailDirectoryLabel = new JLabel();
    JTextField closeupDirectory = new JTextField(20);
    JLabel closeupDirectoryLabel = new JLabel();
    JTextField slideDirectory = new JTextField(20);
    JLabel slideDirectoryLabel = new JLabel();
    JTextField thumbnailPrefix = new JTextField(20);
    JLabel thumbnailPrefixLabel = new JLabel();
    JTextField closeupPrefix = new JTextField(20);
    JLabel closeupPrefixLabel = new JLabel();
    JCheckBox includeDirectories = new JCheckBox();
    JLabel encodingLabel = new JLabel();
    JComboBox textEncoding = new JComboBox<String>(Msg.getCharsetNames());
    JCheckBox writeUTF8 = new JCheckBox();
    JScrollPane userVariablesScrollPane = new JScrollPane();
    JMapTable userVariablesTable = new JMapTable();
    JLabel ignorePatternLabel = new JLabel();
    JTextField ignorePattern = new JSmartTextField(16);
    static /* synthetic */ Class class$se$datadosen$component$JDirectoryChooser;

    JSettingsWindow(JAlbumFrame frame) {
        super(frame);
        this.mainFrame = frame;
        this.init();
    }

    private void init() {
        this.directoryLabel.setLabelFor(this.directory);
        this.chooseDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                int returnVal;
                File d2;
                String dir2 = JSettingsWindow.this.directory.getText();
                if (dir2.length() > 0 && (d2 = new File(dir2)).isDirectory()) {
                    JSettingsWindow.this.directoryChooser.setCurrentDirectory(d2);
                }
                if ((returnVal = JSettingsWindow.this.directoryChooser.showOpenDialog(JSettingsWindow.this)) == 0) {
                    JSettingsWindow.this.directory.setText(JSettingsWindow.this.directoryChooser.getSelectedFile().getAbsolutePath());
                    JSettingsWindow.this.directorySelected();
                    JSettingsWindow.this.mainFrame.scanImageDirectory();
                }
            }
        });
        this.subdirs.setSelected(true);
        this.colsLabel.setLabelFor(this.cols);
        this.thumbSizeLabel.setLabelFor(this.thumbSize);
        this.imageSizeLabel.setLabelFor(this.imageSize);
        this.cols.setInputVerifier(new NumericVerifier());
        this.directory.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e2) {
                JSettingsWindow.this.directorySelected();
            }
        });
        this.directoryChooser.setTitle(Msg.getString("ui.chooseDirectoryToolTip"));
        this.outputDirectoryChooser.setTitle(Msg.getString("ui.chooseDirectoryToolTip"));
        this.directoryChooser.setFileSelectionMode(1);
        this.outputDirectoryChooser.setFileSelectionMode(1);
        this.chooseDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.chooseDirectoryButton.setIcon(this.mainFrame.icons.openIcon);
        this.outputDirectoryPanel.addComponent(this.outputDirectory);
        this.outputDirectoryPanel.addComponent(this.outputDirectoryPanel);
        this.jFileDropPanel1.addComponent(this.directory);
        this.jFileDropPanel1.addFileDropListener(new FileDropListener(){

            public void filesDropped(FileDropEvent e2) {
                File droppedFile = e2.getFirstFile();
                if (droppedFile.isDirectory()) {
                    JSettingsWindow.this.directory.setText(e2.getFirstFile().getAbsolutePath());
                }
            }
        });
        this.imageSize.setEditable(true);
        this.thumbSize.setEditable(true);
        this.rowsLabel.setLabelFor(this.rows);
        this.outputDirectoryPanel.addFileDropListener(new FileDropListener(){

            public void filesDropped(FileDropEvent e2) {
                if (e2.getFirstFile().isDirectory()) {
                    JSettingsWindow.this.outputDirectory.setText(e2.getFirstFile().getAbsolutePath());
                    JSettingsWindow.this.directorySelected();
                } else {
                    JSettingsWindow.this.mainFrame.messageBox(Msg.getString("ui.filesDroppedError2"));
                }
            }
        });
        this.outputDirectoryPanel.setLayout(new RiverLayout());
        this.outputDirectoryLabel.setLabelFor(this.outputDirectory);
        this.chooseOutputDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.chooseOutputDirectoryButton.setIcon(this.mainFrame.icons.openIcon);
        this.chooseOutputDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                int returnVal;
                if (JSettingsWindow.this.outputDirectory.getText().length() > 0) {
                    File dir2 = new File(JSettingsWindow.this.outputDirectory.getText());
                    if (!dir2.isAbsolute()) {
                        dir2 = new File(JSettingsWindow.this.directory.getText(), JSettingsWindow.this.outputDirectory.getText());
                    }
                    JSettingsWindow.this.outputDirectoryChooser.setCurrentDirectory(dir2);
                }
                if ((returnVal = JSettingsWindow.this.outputDirectoryChooser.showOpenDialog(JSettingsWindow.this)) == 0) {
                    JSettingsWindow.this.outputDirectory.setText(JSettingsWindow.this.outputDirectoryChooser.getSelectedFile().getAbsolutePath());
                    JSettingsWindow.this.directorySelected();
                }
            }
        });
        this.sameDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSettingsWindow.this.mainFrame.fixUIdisabling();
            }
        });
        this.linkOriginals.setActionCommand("LinkOriginals");
        this.linkOriginals.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSettingsWindow.this.copyOriginals.setSelected(true);
                JSettingsWindow.this.mainFrame.fixUIdisabling();
            }
        });
        this.linkOriginalsViaScaled.setActionCommand("LinkOriginalsViaScaled");
        this.linkOriginalsViaScaled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSettingsWindow.this.copyOriginals.setSelected(true);
                JSettingsWindow.this.mainFrame.fixUIdisabling();
            }
        });
        this.linkScaled.setSelected(true);
        this.linkScaled.setActionCommand("LinkScaled");
        this.linkScaled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSettingsWindow.this.mainFrame.fixUIdisabling();
            }
        });
        ActionListener linkingGuideListener = new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSettingsWindow.this.updateLinkingGuide();
            }
        };
        this.linkScaled.addActionListener(linkingGuideListener);
        this.linkOriginalsViaScaled.addActionListener(linkingGuideListener);
        this.linkOriginals.addActionListener(linkingGuideListener);
        this.slides.addActionListener(linkingGuideListener);
        this.outputDirectory.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e2) {
                JSettingsWindow.this.directorySelected();
            }
        });
        this.keepMetaData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                if (JSettingsWindow.this.keepMetaData.isSelected()) {
                    JOptionPane.showMessageDialog(JSettingsWindow.this, Msg.getString("ui.keepMetaDataWarning"), Msg.getString("ui.keepMetaDataInfo"), 2);
                }
            }
        });
        if (JAlbum.isMac()) {
            this.generalPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        this.generalPanel.add("p", this.directoryLabel);
        this.generalPanel.add("tab hfill", this.directory);
        this.generalPanel.add(this.chooseDirectoryButton);
        this.generalPanel.add("br", this.outputDirectoryLabel);
        this.generalPanel.add("tab hfill", this.outputDirectory);
        this.generalPanel.add(this.chooseOutputDirectoryButton);
        this.generalPanel.add("p hfill", this.sameDirectory);
        ControlPanel cp2 = new ControlPanel();
        cp2.setLayout(new PercentLayout(0, 9));
        this.imageOrderingPanel.add("hfill", this.imageOrdering);
        this.imageOrderingPanel.add("p hfill", this.reverseOrder);
        this.imageOrderingPanel.add("br hfill", this.directoriesFirst);
        cp2.add(this.imageOrderingPanel);
        this.thumbnailLayoutPanel.add("br", this.colsLabel);
        this.thumbnailLayoutPanel.add("tab", this.cols);
        this.thumbnailLayoutPanel.add("br", this.rowsLabel);
        this.thumbnailLayoutPanel.add("tab", this.rows);
        cp2.add(this.thumbnailLayoutPanel);
        this.generalPanel.add("p hfill", cp2);
        if (JAlbum.isMac()) {
            this.navigationPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        this.imageLinking.add(this.linkScaled);
        this.imageLinking.add(this.linkOriginals);
        this.imageLinking.add(this.linkOriginalsViaScaled);
        this.imageLinkingPanel.add("br", this.linkingGuide);
        this.imageLinkingPanel.add("p hfill", this.linkScaled);
        this.imageLinkingPanel.add("br hfill", this.linkOriginals);
        this.imageLinkingPanel.add("br hfill", this.linkOriginalsViaScaled);
        this.imageLinkingPanel.add("p hfill", this.copyOriginals);
        this.imageLinkingPanel.add("br hfill", this.slides);
        this.navigationPanel.add("br", this.imageLinkingPanel);
        this.navigationPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e2) {
                JSettingsWindow.this.updateLinkingGuide();
            }
        });
        if (JAlbum.isMac()) {
            this.imagesPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        ControlPanel imageGenerationGroup = new ControlPanel();
        imageGenerationGroup.add("br", this.scalingMethodLabel);
        imageGenerationGroup.add("tab", this.scalingMethod);
        imageGenerationGroup.add("p hfill", this.sharpenPercentLabel);
        imageGenerationGroup.add("tab", this.sharpenPercent);
        imageGenerationGroup.add("br hfill", this.qualityPercentLabel);
        imageGenerationGroup.add("tab", this.qualityPercent);
        imageGenerationGroup.add("", this.progressiveMode);
        this.imagesPanel.add("br", imageGenerationGroup);
        JPanel left = new JPanel();
        left.setLayout(new RiverLayout());
        left.add("", this.thumbSizeLabel);
        left.add("tab", this.thumbSize);
        left.add("br", this.imageSizeLabel);
        left.add("tab", this.imageSize);
        this.imageBoundsPanel.add(left);
        this.imageBoundsPanel.add("", new JLabel(this.bboxIcon));
        this.imagesPanel.add("p", this.imageBoundsPanel);
        this.qualityPercent.setMajorTickSpacing(25);
        this.qualityPercent.setMinorTickSpacing(5);
        this.qualityPercent.setSnapToTicks(true);
        this.qualityPercent.setPaintTicks(true);
        this.qualityPercent.setPaintLabels(true);
        this.qualityPercentLabel.setLabelFor(this.qualityPercent);
        this.sharpenPercent.setMajorTickSpacing(25);
        this.sharpenPercent.setMinorTickSpacing(5);
        this.sharpenPercent.setSnapToTicks(true);
        this.sharpenPercent.setPaintTicks(true);
        this.sharpenPercent.setPaintLabels(true);
        this.sharpenPercentLabel.setLabelFor(this.sharpenPercent);
        this.textEncoding.setEditable(true);
        this.dateFormatLabel.setLabelFor(this.dateFormat);
        this.indexPageNameLabel.setLabelFor(this.indexPageName);
        this.dateFormatTemplateLabel.setFont(new Font("Dialog", 0, 10));
        this.pageExtensionLabel.setLabelFor(this.pageExtension);
        this.thumbnailDirectoryLabel.setLabelFor(this.thumbnailDirectory);
        this.thumbnailDirectoryLabel.setEnabled(false);
        this.thumbnailDirectory.setEnabled(false);
        this.closeupDirectoryLabel.setLabelFor(this.closeupDirectory);
        this.closeupDirectoryLabel.setEnabled(false);
        this.closeupDirectory.setEnabled(false);
        this.slideDirectoryLabel.setLabelFor(this.slideDirectory);
        this.slideDirectoryLabel.setEnabled(false);
        this.slideDirectory.setEnabled(false);
        this.thumbnailPrefixLabel.setLabelFor(this.thumbnailPrefix);
        this.thumbnailPrefixLabel.setEnabled(false);
        this.thumbnailPrefix.setEnabled(false);
        this.closeupPrefixLabel.setLabelFor(this.closeupPrefix);
        this.closeupPrefixLabel.setEnabled(false);
        this.closeupPrefix.setEnabled(false);
        this.advancedPanel.setBorder(BorderFactory.createEmptyBorder(12, 9, 6, 9));
        this.advGeneralPanel.add("p", this.encodingLabel);
        this.advGeneralPanel.add("tab", this.textEncoding);
        this.advGeneralPanel.add("hfill", this.writeUTF8);
        this.advGeneralPanel.add("br", this.dateFormatLabel);
        this.advGeneralPanel.add("tab", this.dateFormat);
        this.advGeneralPanel.add("hfill", this.dateFormatTemplateLabel);
        this.advGeneralPanel.add("br", this.ignorePatternLabel);
        this.advGeneralPanel.add("tab", this.ignorePattern);
        JPanel checkboxes = new JPanel(new PercentLayout(0, 12));
        ControlPanel left2 = new ControlPanel();
        left2.setLayout(new PercentLayout(1, 3));
        ((Container)left2).add(this.subdirs);
        ((Container)left2).add(this.updatedDirsOnly);
        ((Container)left2).add(this.includeDirectories);
        ((Container)left2).add(this.excludeByDefault);
        checkboxes.add(left2);
        ControlPanel right = new ControlPanel();
        right.setLayout(new PercentLayout(1, 3));
        ((Container)right).add(this.useThumbForFolderIcon);
        ((Container)right).add(this.classicReaders);
        checkboxes.add(right);
        this.advGeneralPanel.add("br", new JLabel());
        this.advGeneralPanel.add("p hfill", checkboxes);
        this.advancedPanel.addTab(Msg.getString("ui.mainPanel"), this.advGeneralPanel);
        this.advMetadataPanel.add("br", this.commentSourcesPanel);
        this.advMetadataPanel.add("p hfill", this.metaData);
        this.advMetadataPanel.add("br hfill", this.keepMetaData);
        this.advancedPanel.addTab(Msg.getString("ui.metadataPanel"), this.advMetadataPanel);
        this.advNamingPanel.add("p hfill", this.indexPageNameLabel);
        this.advNamingPanel.add("tab", this.indexPageName);
        this.advNamingPanel.add("br hfill", this.pageExtensionLabel);
        this.advNamingPanel.add("tab", this.pageExtension);
        this.advNamingPanel.add("br hfill", this.thumbnailDirectoryLabel);
        this.advNamingPanel.add("tab", this.thumbnailDirectory);
        this.advNamingPanel.add("br hfill", this.closeupDirectoryLabel);
        this.advNamingPanel.add("tab", this.closeupDirectory);
        this.advNamingPanel.add("br hfill", this.slideDirectoryLabel);
        this.advNamingPanel.add("tab", this.slideDirectory);
        this.advNamingPanel.add("br hfill", this.thumbnailPrefixLabel);
        this.advNamingPanel.add("tab", this.thumbnailPrefix);
        this.advNamingPanel.add("br hfill", this.closeupPrefixLabel);
        this.advNamingPanel.add("tab", this.closeupPrefix);
        this.advNamingPanel.add("p hfill", this.urlEncode);
        this.advancedPanel.addTab(Msg.getString("ui.namingPanel"), this.advNamingPanel);
        this.commentSourcesPanel.add("hfill", this.textFileComment);
        this.commentSourcesPanel.add("br hfill", this.jpegComment);
        this.commentSourcesPanel.add("br hfill", this.iptcCaption);
        this.commentSourcesPanel.add("br hfill", this.exifUserComment);
        this.commentSourcesPanel.add("br hfill", this.exifImageDescription);
        this.userVariablesScrollPane.getViewport().add(this.userVariablesTable);
        this.userVariablesScrollPane.setPreferredSize(new Dimension(50, 50));
        if (JAlbum.isMac()) {
            this.userVariablesScrollPane.setVerticalScrollBarPolicy(22);
        }
        this.advUserVariablesPanel.setLayout(new BorderLayout());
        this.advUserVariablesPanel.add((Component)this.userVariablesScrollPane, "Center");
        this.advUserVariablesPanel.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        this.advancedPanel.addTab(Msg.getString("ui.varsPanel"), this.advUserVariablesPanel);
        this.skinSettingsPanel.setLayout(new BorderLayout());
        this.buttonBarPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                Component previousPanel = JSettingsWindow.this.currentPanel;
                JSettingsWindow.this.currentPanel = JSettingsWindow.this.buttonBarPane.getSelectedComponent();
                if (previousPanel == JSettingsWindow.this.skinSettingsPanel) {
                    JSettingsWindow.this.mainFrame.fireSkinUIHidden(new JAlbumEvent(this));
                } else if (JSettingsWindow.this.currentPanel == JSettingsWindow.this.skinSettingsPanel) {
                    JSettingsWindow.this.mainFrame.fireSkinUIDisplayed(new JAlbumEvent(this));
                }
            }
        });
        Container c2 = this.getContentPane();
        c2.add((Component)this.buttonBarPane, "Center");
        AbstractAction closeAction = new AbstractAction(Msg.getString("close")){

            public void actionPerformed(ActionEvent e2) {
                JSettingsWindow.this.setVisible(false);
                if (!JSettingsWindow.this.directory.getText().equals(((JSettingsWindow)JSettingsWindow.this).mainFrame.engine.getDirectory())) {
                    JSettingsWindow.this.mainFrame.initView();
                }
                JSettingsWindow.this.mainFrame.ui2Engine();
            }
        };
        this.registerActions(closeAction);
    }

    boolean isSkinUISelected() {
        return this.buttonBarPane.getSelectedComponent() == this.skinSettingsPanel;
    }

    void setSkinUI(ControlPanel ui) {
        if (this.skinUI != null) {
            this.skinSettingsPanel.remove(this.skinUI);
        }
        this.skinUI = ui;
        if (ui != null) {
            this.skinSettingsPanel.add(ui);
            PropertyBinder.syncUI(this.mainFrame.engine.getUserVariables(), ui);
            PropertyBinder.syncUI(this.mainFrame.engine.getSkinVariables(), ui);
        }
        this.buttonBarPane.remove(this.skinSettingsPanel);
        if (ui != null) {
            this.buttonBarPane.addTab(this.mainFrame.mainSettingsPanel.getSelectedSkin(), this.mainFrame.icons.skinTabIcon, this.skinSettingsPanel);
            this.buttonBarPane.validate();
        }
    }

    private void updateLinkingGuide() {
        ImageIcon icon = null;
        if (this.slides.isSelected()) {
            if (this.linkScaled.isSelected()) {
                icon = this.thumbnailsSlideIcon;
            } else if (this.linkOriginalsViaScaled.isSelected()) {
                icon = this.thumbnailsSlideOriginalIcon;
            } else if (this.linkOriginals.isSelected()) {
                icon = this.thumbnailsOriginalIcon;
            }
        } else if (this.linkScaled.isSelected()) {
            icon = this.thumbnailsScaledNoSlidesIcon;
        } else if (this.linkOriginalsViaScaled.isSelected()) {
            icon = this.thumbnailsScaledNoSlidesIcon;
        } else if (this.linkOriginals.isSelected()) {
            icon = this.thumbnailsOriginalsNoSlidesIcon;
        }
        this.linkingGuide.setIcon(icon);
    }

    void populateWithDefaultTabs() {
        this.buttonBarPane.addTab(Msg.getString("ui.mainPanel"), this.mainFrame.icons.mainTabIcon, this.generalPanel);
        this.buttonBarPane.addTab(Msg.getString("ui.imagesPanel"), this.mainFrame.icons.imagesTabIcon, this.imagesPanel);
        this.buttonBarPane.addTab(Msg.getString("ui.navigationPanel"), this.mainFrame.icons.navigationTabIcon, this.navigationPanel);
        this.buttonBarPane.addTab(Msg.getString("ui.advancedPanel"), this.mainFrame.icons.advancedTabIcon, this.advancedPanel);
    }

    void setTexts() {
        this.renameTab(this.generalPanel, Msg.getString("ui.mainPanel"));
        this.renameTab(this.imagesPanel, Msg.getString("ui.imagesPanel"));
        this.renameTab(this.navigationPanel, Msg.getString("ui.navigationPanel"));
        this.renameTab(this.advancedPanel, Msg.getString("ui.advancedPanel"));
        this.renameAdvancedTab(this.advGeneralPanel, Msg.getString("ui.mainPanel"));
        this.renameAdvancedTab(this.advMetadataPanel, Msg.getString("ui.metadataPanel"));
        this.renameAdvancedTab(this.advNamingPanel, Msg.getString("ui.namingPanel"));
        this.renameAdvancedTab(this.advUserVariablesPanel, Msg.getString("ui.varsPanel"));
        this.directoryLabel.setText(Msg.getString("ui.imageDirectoryLabel"));
        this.imageBoundsPanel.setTitle(Msg.getString("ui.imageBoundsBorder"));
        this.imageOrderingPanel.setTitle(Msg.getString("ui.imageOrderingBorder"));
        this.imageLinkingPanel.setTitle(Msg.getString("ui.imageLinkingBorder"));
        this.thumbnailLayoutPanel.setTitle(Msg.getString("ui.thumbnailLayoutBorder"));
        this.subdirs.setText(Msg.getString("ui.processSubdirectoriesCheckbox"));
        this.subdirs.setToolTipText(Msg.getString("ui.processSubdirectoriesToolTip"));
        this.imageSizeLabel.setText(Msg.getString("ui.imagesLabel"));
        this.colsLabel.setText(Msg.getString("ui.columnsLabel"));
        this.thumbSizeLabel.setText(Msg.getString("ui.thumbnailsLabel"));
        this.chooseDirectoryButton.setToolTipText(Msg.getString("ui.chooseDirectoryToolTip"));
        this.directory.setToolTipText(Msg.getString("ui.imageDirectoryToolTip"));
        this.imageSize.setToolTipText(Msg.getString("ui.imageSizeToolTip"));
        this.thumbSize.setToolTipText(Msg.getString("ui.thumbSizeToolTip"));
        this.slides.setText(Msg.getString("ui.makeSlides"));
        this.slides.setToolTipText(Msg.getString("ui.makeSlidesToolTip"));
        this.rowsLabel.setText(Msg.getString("ui.rows"));
        this.outputDirectoryLabel.setText(Msg.getString("ui.outputDirectory"));
        this.chooseOutputDirectoryButton.setToolTipText(Msg.getString("ui.outputDirectoryToolTip"));
        this.copyOriginals.setText(Msg.getString("ui.copyOriginals"));
        this.copyOriginals.setToolTipText(Msg.getString("ui.copyOriginalsToolTip"));
        this.sameDirectory.setText(Msg.getString("ui.sameDirectory"));
        this.linkOriginals.setText(Msg.getString("ui.linkToOriginals"));
        this.linkOriginalsViaScaled.setText(Msg.getString("ui.linkToOriginalsViaScaledImages"));
        this.linkScaled.setText(Msg.getString("ui.linkToScaledImagesOnly"));
        this.scalingMethod.removeAllItems();
        this.scalingMethod.addItem(new Item("ScaleFast", Msg.getString("ui.scaleFast")));
        this.scalingMethod.addItem(new Item("ScaleMedium", Msg.getString("ui.scaleMedium")));
        this.scalingMethod.addItem(new Item("ScaleSmooth", Msg.getString("ui.scaleSmooth")));
        this.imageOrdering.removeAllItems();
        this.imageOrdering.addItem(new Item("OrderByDate", Msg.getString("ui.dateOrdering")));
        this.imageOrdering.addItem(new Item("OrderByName", Msg.getString("ui.nameOrdering")));
        this.imageOrdering.addItem(new Item("OrderBySimpleName", Msg.getString("ui.simpleNameOrdering")));
        this.rows.setToolTipText(Msg.getString("ui.rowsToolTip") + Msg.getString("ui.rowsToolTip2"));
        this.reverseOrder.setText(Msg.getString("ui.reverseOrder"));
        this.directoriesFirst.setText(Msg.getString("ui.directoriesFirst"));
        this.directoriesFirst.setToolTipText(Msg.getString("ui.directoriesFirstToolTip"));
        this.outputDirectory.setToolTipText(Msg.getString("ui.outputDirectoryToolTip"));
        this.dateFormatLabel.setText(Msg.getString("ui.dateFormat"));
        this.urlEncode.setText(Msg.getString("ui.urlEncode"));
        this.urlEncode.setToolTipText(Msg.getString("ui.urlEncodeToolTip"));
        this.indexPageNameLabel.setText(Msg.getString("ui.indexPageName"));
        this.metaData.setText(Msg.getString("ui.metaData"));
        this.metaData.setToolTipText(Msg.getString("ui.metaDataToolTip"));
        this.updatedDirsOnly.setText(Msg.getString("ui.updatedDirsOnly"));
        this.updatedDirsOnly.setToolTipText(Msg.getString("ui.updatedDirsOnlyToolTip"));
        this.excludeByDefault.setText(Msg.getString("ui.excludeByDefault"));
        this.excludeByDefault.setToolTipText(Msg.getString("ui.excludeByDefaultToolTip"));
        this.classicReaders.setText(Msg.getString("ui.classicReaders"));
        this.classicReaders.setToolTipText(Msg.getString("ui.classicReadersToolTip"));
        this.useThumbForFolderIcon.setText(Msg.getString("ui.useThumbForFolderIcon"));
        this.useThumbForFolderIcon.setToolTipText(Msg.getString("ui.useThumbForFolderIconToolTip"));
        this.dateFormatTemplateLabel.setText(Msg.getString("ui.dateFormatTemplate"));
        this.dateFormat.setToolTipText(Msg.getString("ui.dateFormatTemplateToolTip"));
        this.ignorePatternLabel.setText(Msg.getString("ui.ignorePattern"));
        this.commentSourcesPanel.setTitle(Msg.getString("ui.commentSourcesBorder"));
        this.commentSourcesPanel.setToolTipText(Msg.getString("ui.commentSourcesToolTip"));
        this.textFileComment.setText(Msg.getString("ui.textFileComment"));
        this.jpegComment.setText(Msg.getString("ui.jpegComment"));
        this.iptcCaption.setText(Msg.getString("ui.iptcCaption"));
        this.exifUserComment.setText(Msg.getString("ui.exifUserComment"));
        this.exifImageDescription.setText(Msg.getString("ui.exifImageDescription"));
        this.ignorePattern.setToolTipText(Msg.getString("ui.ignorePatternToolTip"));
        this.qualityPercentLabel.setText(Msg.getString("ui.jpegQuality"));
        this.sharpenPercentLabel.setText(Msg.getString("ui.sharpenAmount"));
        this.scalingMethodLabel.setText(Msg.getString("ui.scalingMethod"));
        this.progressiveMode.setText(Msg.getString("ui.progressiveMode"));
        this.progressiveMode.setToolTipText(Msg.getString("ui.progressiveModeToolTip"));
        this.keepMetaData.setText(Msg.getString("ui.keepMetaDataInfo"));
        this.keepMetaData.setToolTipText(Msg.getString("ui.metaDataToolTip"));
        this.qualityPercent.setToolTipText(Msg.getString("ui.qualityPercentToolTip"));
        this.pageExtensionLabel.setText(Msg.getString("ui.pageExtension"));
        this.thumbnailDirectoryLabel.setText(Msg.getString("ui.thumbnailDirectory"));
        this.closeupDirectoryLabel.setText(Msg.getString("ui.closeupDirectory"));
        this.slideDirectoryLabel.setText(Msg.getString("ui.slideDirectory"));
        this.thumbnailPrefixLabel.setText(Msg.getString("ui.thumbnailPrefix"));
        this.closeupPrefixLabel.setText(Msg.getString("ui.closeupPrefix"));
        this.includeDirectories.setText(Msg.getString("ui.includeDirectories"));
        this.userVariablesTable.setToolTipText(Msg.getString("ui.userVariablesToolTip"));
        this.encodingLabel.setText(Msg.getString("ui.encoding"));
        this.writeUTF8.setText(Msg.getString("ui.writeUTF8"));
        this.writeUTF8.setToolTipText(Msg.getString("ui.writeUTF8ToolTip"));
        this.textEncoding.setToolTipText(Msg.getString("ui.textEncodingToolTip"));
        this.userVariablesTable.setHeaderNames(Msg.getString("ui.userVariablesNameColumn"), Msg.getString("ui.userVariablesValueColumn"));
    }

    private void renameTab(JComponent comp, String newName) {
        int index = this.buttonBarPane.indexOfTab(comp);
        if (index != -1) {
            this.buttonBarPane.setTitleAt(index, newName);
        }
    }

    private void renameAdvancedTab(Component comp, String newName) {
        for (int i2 = 0; i2 < this.advancedPanel.getTabCount(); ++i2) {
            Component c2 = this.advancedPanel.getComponentAt(i2);
            if (c2 != comp) continue;
            this.advancedPanel.setTitleAt(i2, newName);
            break;
        }
    }

    String getImageSize() {
        return this.imageSize.getSelectedItem().toString();
    }

    void setImageSize(String size) {
        this.imageSize.setSelectedItem(size);
    }

    String getThumbsSize() {
        return this.thumbSize.getSelectedItem().toString();
    }

    void setThumbsSize(String size) {
        this.thumbSize.setSelectedItem(size);
    }

    boolean getSameDirectory() {
        return this.sameDirectory.isSelected();
    }

    boolean getLinkScaled() {
        return this.linkScaled.isSelected();
    }

    boolean getLinkOriginals() {
        return this.linkOriginals.isSelected();
    }

    boolean getCopyOriginals() {
        return this.copyOriginals.isSelected();
    }

    String getDirectory() {
        return this.directory.getText();
    }

    String getOutputDirectory() {
        return this.outputDirectory.getText();
    }

    void directorySelected() {
        this.mainFrame.directorySelected();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

