/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartSeparator;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DirectoryFilter;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.JComponentHolder;

public class JMainSettingsPanel
extends JPanel
implements JComponentHolder {
    private JAlbumFrame frame;
    private JLabel skinLabel = new JLabel();
    private JLabel styleLabel = new JLabel();
    JComboBox skin = new JComboBox();
    JComboBox style = new JComboBox();
    private JLinkLabel moreSkinsLink = new JLinkLabel();
    private JSmartSeparator makeSeparator = JAlbumBorders.createSeparator();
    private JRadioButton makeChanges = new JRadioButton();
    private JRadioButton makeAll = new JRadioButton();
    public ButtonGroup appendImages = new ButtonGroup(){
        {
            this.add(JMainSettingsPanel.this.makeChanges);
            this.add(JMainSettingsPanel.this.makeAll);
            JMainSettingsPanel.this.makeAll.setSelected(true);
            JMainSettingsPanel.this.makeChanges.setActionCommand("true");
            JMainSettingsPanel.this.makeAll.setActionCommand("false");
        }
    };
    private JButton albumSettingsButton;
    private JButton makeAlbumButton;
    private JButton viewAlbumToolButton;
    private JButton publishToolButton;
    private MouseListener skinsScanner = new MouseAdapter(){

        public void mouseEntered(MouseEvent e2) {
            JMainSettingsPanel.this.scanSkins();
        }
    };
    private PopupMenuListener skinPreviewer = new PopupMenuListener(){

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JMainSettingsPanel.this.frame.setPreviewImage();
            ((JMainSettingsPanel)JMainSettingsPanel.this).frame.skinPreview.setVisible(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            ((JMainSettingsPanel)JMainSettingsPanel.this).frame.skinPreview.setVisible(false);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    };
    ActionListener skinSelectedActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            JMainSettingsPanel.this.frame.fireSkinChanged(new JAlbumEvent(this));
            JMainSettingsPanel.this.frame.setSkinUI(null);
            String selected = JMainSettingsPanel.this.getSelectedStyle();
            JMainSettingsPanel.this.style.removeAllItems();
            File skinDir = ((JMainSettingsPanel)JMainSettingsPanel.this).frame.cfg.chainedSkinsDir.getFile(JMainSettingsPanel.this.getSelectedSkin());
            JMainSettingsPanel.this.frame;
            JAlbumFrame.fillCombo(JMainSettingsPanel.this.style, new File(skinDir, "styles"), (FileFilter)new StyleFileFilter());
            if (JMainSettingsPanel.this.style.getItemCount() > 0) {
                JMainSettingsPanel.this.style.setSelectedIndex(0);
            }
            JMainSettingsPanel.this.style.setSelectedItem(selected);
            if (((JMainSettingsPanel)JMainSettingsPanel.this).frame.loadHints) {
                JMainSettingsPanel.this.frame.loadHints();
            }
            JMainSettingsPanel.this.frame.setPreviewImage();
            ((JMainSettingsPanel)JMainSettingsPanel.this).frame.engine.setSkin(JMainSettingsPanel.this.getSelectedSkin());
            ((JMainSettingsPanel)JMainSettingsPanel.this).frame.engine.initInterpreter();
            final File onLoadScript = new File(((JMainSettingsPanel)JMainSettingsPanel.this).frame.cfg.chainedSkinsDir.getFile(((JMainSettingsPanel)JMainSettingsPanel.this).frame.engine.getSkin()), "onload.bsh");
            if (onLoadScript.exists()) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = JAlbum.initializedOkMonitor;
                        synchronized (object) {
                            JMainSettingsPanel.this.frame.executeScript(onLoadScript);
                        }
                    }
                }.start();
            }
        }
    };

    public JMainSettingsPanel(JAlbumFrame frame) {
        this.frame = frame;
        this.init();
    }

    private boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        for (int i2 = 0; i2 < flavors.length; ++i2) {
            DataFlavor dropFlavor = flavors[i2];
            if (!dropFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.scanSkins();
        this.skin.getComponent(0).addMouseListener(this.skinsScanner);
        this.skin.addPopupMenuListener(this.skinPreviewer);
        this.style.addPopupMenuListener(this.skinPreviewer);
        DropTarget skinDropTarget = new DropTarget(){

            public void dragEnter(DropTargetDragEvent e2) {
                if (e2.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e2.acceptDrag(1);
                } else {
                    e2.rejectDrag();
                }
            }

            public void dragOver(DropTargetDragEvent e2) {
                if (e2.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e2.acceptDrag(1);
                } else {
                    e2.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent e2) {
            }

            public void drop(DropTargetDropEvent e2) {
                if (!e2.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e2.rejectDrop();
                    return;
                }
                e2.acceptDrop(1);
                try {
                    List files = (List)e2.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    e2.dropComplete(true);
                    final File f2 = (File)files.get(0);
                    String name = f2.getName().toLowerCase();
                    if (name.endsWith(".zip") || name.endsWith(".jaskin")) {
                        new Thread(){

                            public void run() {
                                SkinManager sm = new SkinManager();
                                sm.installSkin(f2);
                            }
                        }.start();
                    }
                }
                catch (Exception ex) {
                    e2.dropComplete(false);
                    Debug.showErrorDialog(JMainSettingsPanel.this, ex);
                }
            }
        };
        this.skin.setDropTarget(skinDropTarget);
        final ListCellRenderer defaultRenderer = this.skin.getRenderer();
        this.skin.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected && !cellHasFocus) {
                    JMainSettingsPanel.this.frame.setPreviewImage((String)value, JMainSettingsPanel.this.getDefaultStyleForSkin(value.toString()));
                }
                return defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.style.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected && !cellHasFocus) {
                    JMainSettingsPanel.this.frame.setPreviewImage(JMainSettingsPanel.this.getSelectedSkin(), (String)value);
                }
                return defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.style.setSelectedItem("Plain.css");
        this.style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JMainSettingsPanel.this.frame.setPreviewImage();
                JMainSettingsPanel.this.frame.fireStyleChanged(new JAlbumEvent(JMainSettingsPanel.this.frame));
            }
        });
        this.setupPanel();
    }

    private void setupPanel() {
        this.albumSettingsButton = new JButton(this.frame.actions.showAlbumSettingsWindow);
        this.makeAlbumButton = new JButton(this.frame.actions.makeAction);
        this.viewAlbumToolButton = new JButton(this.frame.actions.viewAlbumAction);
        this.publishToolButton = new JButton(this.frame.actions.showPublishWindowAction);
        ImageIcon albumSettingsIcon = new ImageIcon(this.getClass().getResource("button_images/gear_preferences.png"));
        ImageIcon viewAlbumIcon = new ImageIcon(this.getClass().getResource("button_images/earth_view.png"));
        ImageIcon publishIcon = new ImageIcon(this.getClass().getResource("button_images/publish.png"));
        this.albumSettingsButton.setIcon(albumSettingsIcon);
        this.makeAlbumButton.setIcon(this.frame.icons.engineIcon);
        this.viewAlbumToolButton.setIcon(viewAlbumIcon);
        this.publishToolButton.setIcon(publishIcon);
        JPanel content = JMainSettingsPanel.createRiverPanel();
        if (JAlbum.isMac()) {
            content.setBorder(BorderFactory.createEmptyBorder(6, 9, 2, 0));
        } else {
            content.setBorder(BorderFactory.createEmptyBorder(9, 6, 0, 0));
        }
        content.add("br", JMainSettingsPanel.emptyArea(3));
        JPanel skinAndStyleGroup = JMainSettingsPanel.createRiverPanel();
        skinAndStyleGroup.add("br", this.skinLabel);
        skinAndStyleGroup.add(JMainSettingsPanel.emptyArea(3));
        skinAndStyleGroup.add("tab hfill", this.skin);
        if (!JAlbum.isMac() || !JAlbum.isUsingSystemLAF()) {
            skinAndStyleGroup.add("br", JMainSettingsPanel.emptyArea(3));
        }
        skinAndStyleGroup.add("br", this.styleLabel);
        skinAndStyleGroup.add(JMainSettingsPanel.emptyArea(3));
        skinAndStyleGroup.add("tab hfill", this.style);
        this.skin.setPreferredSize(this.skin.getPreferredSize());
        this.style.setPreferredSize(this.skin.getPreferredSize());
        content.add("br hfill", skinAndStyleGroup);
        if (!JAlbum.isMac() || !JAlbum.isUsingSystemLAF()) {
            content.add("br", JMainSettingsPanel.emptyArea(3));
        }
        content.add("br right", this.moreSkinsLink);
        content.add("br", JMainSettingsPanel.emptyArea(6));
        content.add("br hfill", this.albumSettingsButton);
        content.add("br", JMainSettingsPanel.emptyArea(12));
        content.add("br hfill", this.makeSeparator);
        content.add("br", JMainSettingsPanel.emptyArea(2));
        content.add("br center", this.makeAll);
        content.add(this.makeChanges);
        content.add("br left hfill", this.makeAlbumButton);
        content.add("br", JMainSettingsPanel.emptyArea(5));
        content.add("br hfill", this.viewAlbumToolButton);
        content.add("br", JMainSettingsPanel.emptyArea(5));
        content.add("br hfill", this.publishToolButton);
        content.add("br", JMainSettingsPanel.emptyArea(3));
        this.setLayout(new BorderLayout());
        this.add((Component)content, "Center");
    }

    private static JPanel createRiverPanel() {
        RiverLayout layout = new RiverLayout(0, 0);
        layout.setExtraInsets(new Insets(0, 0, 0, 0));
        JPanel panel = new JPanel(layout);
        panel.setBorder(null);
        return panel;
    }

    private static Component emptyArea(int size) {
        return Box.createRigidArea(new Dimension(size, size));
    }

    void setTexts() {
        this.skin.setToolTipText(Msg.getString("ui.skinToolTip"));
        this.style.setToolTipText(Msg.getString("ui.styleToolTip"));
        this.skinLabel.setLabelFor(this.skin);
        this.skinLabel.setText(Msg.getString("ui.skin"));
        this.styleLabel.setLabelFor(this.style);
        this.styleLabel.setText(Msg.getString("ui.style"));
        this.moreSkinsLink.setText(Msg.getString("ui.downloadSkins"));
        this.moreSkinsLink.setToolTipText(Msg.getString("ui.downloadSkinsToolTip"));
        this.moreSkinsLink.setURL("http://jalbum.net/skins");
        this.albumSettingsButton.setText(Msg.getString("ui.settings"));
        this.makeSeparator.setText(Msg.getString("ui.makeAlbum"));
        this.makeChanges.setText(Msg.getString("ui.changes"));
        this.makeChanges.setToolTipText(Msg.getString("ui.makeAlbumToolTip"));
        this.makeAll.setText(Msg.getString("ui.all"));
        this.makeAll.setToolTipText(Msg.getString("ui.rebuildAllToolTip"));
        this.makeAlbumButton.setText(Msg.getString("ui.makeAlbum"));
        this.viewAlbumToolButton.setText(Msg.getString("ui.preview"));
        this.viewAlbumToolButton.setToolTipText(Msg.getString("ui.viewAlbumToolTip"));
        this.publishToolButton.setText(Msg.getString("ui.publishPanel"));
        this.publishToolButton.setToolTipText(Msg.getString("ui.publishToolTip"));
    }

    private void scanSkins() {
        this.skin.removeActionListener(this.skinSelectedActionListener);
        Object selected = this.skin.getSelectedItem();
        this.skin.removeAllItems();
        JAlbumFrame.fillCombo(this.skin, this.frame.cfg.chainedSkinsDir, (FileFilter)new DirectoryFilter());
        this.skin.setSelectedItem(selected);
        this.skin.addActionListener(this.skinSelectedActionListener);
        Object newSelected = this.skin.getSelectedItem();
        if (newSelected != null && !newSelected.equals(selected)) {
            this.skin.setSelectedItem(this.skin.getSelectedItem());
        }
    }

    private String getDefaultStyleForSkin(String skinName) {
        try {
            Config cfg = Config.getConfig();
            File skinDir = cfg.chainedSkinsDir.getFile(skinName);
            File stylesDir = new File(skinDir, "styles");
            Properties skinProps = IO.readPropertyFile(new File(skinDir, "hints.jap"));
            String style = skinProps.getProperty("style");
            if (style == null || !new File(stylesDir, style).exists()) {
                File[] styles = stylesDir.listFiles(new StyleFileFilter());
                if (styles != null && styles.length > 0) {
                    return styles[0].getName();
                }
                return "";
            }
            return style;
        }
        catch (IOException ex) {
            return "";
        }
    }

    String getSelectedSkin() {
        return (String)this.skin.getSelectedItem();
    }

    String getSelectedStyle() {
        return (String)this.style.getSelectedItem();
    }

    boolean isMakeChanges() {
        return this.makeChanges.isSelected();
    }
}

