/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ToolFileFilter;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;

class JExternalToolsMenu
extends JMenu
implements ActionListener {
    private Vector names;
    private JAlbumFrame ui;
    File toolsDir;

    public JExternalToolsMenu(JAlbumFrame ui) {
        this.ui = ui;
        this.init();
    }

    private void init() {
        this.names = new Vector();
        this.toolsDir = new File(Config.getConfig().progDir, "tools");
        File[] tools = this.toolsDir.listFiles(new ToolFileFilter());
        if (tools == null) {
            System.err.println("Cannot install tools. Full path to tools directory is: " + this.toolsDir.getAbsolutePath());
            return;
        }
        for (int i2 = 0; i2 < tools.length; ++i2) {
            String name = tools[i2].getName().substring(0, tools[i2].getName().indexOf(46));
            this.names.add(name);
        }
        this.rebuildMenu();
    }

    protected void rebuildMenu() {
        this.removeAll();
        for (int i2 = 0; i2 < this.names.size(); ++i2) {
            JMenuItem item = new JMenuItem((String)this.names.get(i2));
            item.addActionListener(this);
            this.add(item);
        }
    }

    public void actionPerformed(final ActionEvent e2) {
        try {
            this.ui.ui2Engine();
        }
        catch (BeanBinderException ex) {
            Debug.showStackTraceDialog(this, ex);
        }
        new Thread("ScriptingThread"){

            public void run() {
                try {
                    ((JExternalToolsMenu)JExternalToolsMenu.this).ui.engine.init();
                    File cmdFile = new File(JExternalToolsMenu.this.toolsDir, e2.getActionCommand() + ".bsh");
                    if (cmdFile.exists()) {
                        ((JExternalToolsMenu)JExternalToolsMenu.this).ui.engine.processBeanShellFile(cmdFile);
                    }
                }
                catch (ElementException ex) {
                    Debug.showCopyableError(JExternalToolsMenu.this.ui, ex, Msg.getString("ui.scriptingError"));
                }
                catch (OperationAbortedException ex) {
                    ((JExternalToolsMenu)JExternalToolsMenu.this).ui.statusBar.setText(Msg.getString("ui.operationAborted"));
                }
                catch (Exception ex) {
                    Debug.showStackTraceDialog(JExternalToolsMenu.this.ui, ex);
                }
            }
        }.start();
    }
}

