/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.swing.UIManager;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.SmartResourceBundle;

public class Config
implements Serializable {
    private static Config theConfig;
    public File progDir = new File("").getAbsoluteFile();
    public File skinsDir;
    public ChainedDirectory chainedSkinsDir;
    public File pluginsDir;
    public String language = "default";
    private File appdataDir;
    private String lookAndFeel;
    private String webHostListUrl = "http://jalbum.net/web-hosts.xml";
    private boolean cleanOutputFiles = false;
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbum;

    private Config() {
        this.newProgDir();
        if (!this.skinsDir.exists() || !this.pluginsDir.exists()) {
            String instDirName = System.getProperty("jalbum.installation.dir");
            if (instDirName != null) {
                this.progDir = new File(instDirName);
            } else {
                File classPath = new File(System.getProperty("java.class.path"));
                if (classPath.exists()) {
                    this.progDir = classPath.getParentFile().getAbsoluteFile();
                } else {
                    URL url = (class$se$datadosen$jalbum$JAlbum == null ? (class$se$datadosen$jalbum$JAlbum = Config.class$("se.datadosen.jalbum.JAlbum")) : class$se$datadosen$jalbum$JAlbum).getResource("../../../");
                    this.progDir = url != null ? new File(url.getFile()).getParentFile() : new File("");
                }
            }
            this.newProgDir();
        }
        this.setLookAndFeel(System.getProperty("swing.defaultlaf") == null ? UIManager.getSystemLookAndFeelClassName() : System.getProperty("swing.defaultlaf"));
        this.chainedSkinsDir = new ChainedDirectory(this.skinsDir);
        String appdata = System.getProperty("appdata");
        if (appdata != null) {
            this.appdataDir = new File(appdata);
        } else {
            String os = System.getProperty("os.name");
            if (os != null && os.indexOf("Windows") != -1) {
                File appdataDir = new File(System.getProperty("user.home"), "Application Data");
                if (appdataDir.exists()) {
                    this.appdataDir = appdataDir;
                }
            } else if (JAlbum.isMac()) {
                this.appdataDir = new File(System.getProperty("user.home"), "Library");
            }
        }
        if (this.appdataDir != null) {
            File altSkinsDir = new File(this.appdataDir, "JAlbum/skins");
            this.chainedSkinsDir = new ChainedDirectory(altSkinsDir, this.chainedSkinsDir);
        }
    }

    public static Config getConfig() {
        if (theConfig == null) {
            theConfig = new Config();
        }
        return theConfig;
    }

    public void setProgramDirectory(File progDir) {
        this.progDir = progDir;
        this.newProgDir();
    }

    public void setProgramDirectory(String progDir) {
        this.setProgramDirectory(new File(progDir));
    }

    public void setSkinsDirectory(File skinsDir) {
        this.skinsDir = skinsDir;
    }

    public void setSkinsDirectory(String skinsDir) {
        this.setSkinsDirectory(new File(skinsDir));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getInterpretedLanguage() {
        return this.language.equals("default") ? System.getProperty("user.language") : this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        if (!language.equals("default")) {
            Locale.setDefault(new Locale(language, System.getProperty("user.country")));
        } else {
            Locale.setDefault(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
        }
        Msg.reloadBundle();
    }

    public boolean isCleanOutputFiles() {
        return this.cleanOutputFiles;
    }

    public void setCleanOutputFiles(boolean clean) {
        this.cleanOutputFiles = clean;
    }

    private void newProgDir() {
        SmartResourceBundle.setDefaultDir(this.progDir);
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public String getWebHostListUrl() {
        return this.webHostListUrl;
    }

    public void setWebHostListUrl(String webHostListUrl) {
        this.webHostListUrl = webHostListUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

