/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;

public class ChainedDirectory {
    private File dir;
    private ChainedDirectory backgroundDir;

    public ChainedDirectory(File dir2) {
        this.dir = dir2;
    }

    public ChainedDirectory(File dir2, ChainedDirectory backgroundDir) {
        this.dir = dir2;
        this.backgroundDir = backgroundDir;
    }

    public File getDirectory() {
        return this.dir;
    }

    public ChainedDirectory getBackgroundDirectory() {
        return this.backgroundDir;
    }

    public File getFile(String name) {
        File f2 = new File(this.dir, name);
        if (!f2.exists() && this.backgroundDir != null) {
            return this.backgroundDir.getFile(name);
        }
        return f2;
    }

    public File[] listFiles() {
        return this.listFiles(null);
    }

    public File[] listFiles(FileFilter filter) {
        int i2;
        File[] files = this.dir.listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        if (this.backgroundDir == null) {
            return files;
        }
        File[] bgfiles = this.backgroundDir.listFiles(filter);
        HashMap<Object, File> allfiles = new HashMap<Object, File>();
        for (i2 = 0; i2 < files.length; ++i2) {
            allfiles.put(files[i2].getName(), files[i2]);
        }
        for (i2 = 0; i2 < bgfiles.length; ++i2) {
            if (allfiles.containsKey(bgfiles[i2].getName())) continue;
            allfiles.put(bgfiles[i2], bgfiles[i2]);
        }
        return allfiles.values().toArray(new File[0]);
    }
}

