/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JPropertyEditor
extends JDialog {
    AlbumObject ao;
    JAlbumObject jao;
    final Component relativeTo;
    boolean isLastFolder = false;
    final ImageCache imageCache;
    ControlPanel mainPanel = new ControlPanel();
    ControlPanel metaPanel = new ControlPanel();
    JBackgroundPanel imagePanel = new JBackgroundPanel();
    JLabel titleLabel = new JLabel(Msg.getString("edit.titleLabel"));
    JLabel commentLabel = new JLabel(Msg.getString("edit.commentLabel"));
    JButton okButton = new JButton(Msg.getString("ok"));
    JButton cancelButton = new JButton(Msg.getString("cancel"));
    JButton previousButton;
    JButton nextButton;
    JTextArea commentArea = new JSmartTextArea(4, 32);
    JTextField title = new JTextField();
    Action previousImageAction;
    Action nextImageAction;

    public JPropertyEditor(JAlbumObject jao, Component relativeTo) {
        super((JFrame)jao.getTopLevelAncestor());
        this.imageCache = jao.explorer.context.imageCache;
        this.ao = jao.ao;
        this.jao = jao;
        this.relativeTo = relativeTo;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void storeChanges() {
        try {
            if (!this.commentArea.getText().equals(this.ao.getComment())) {
                this.ao.setComment(this.commentArea.getText());
                this.jao.explorer.repaint();
            }
            if (this.ao.isFolder()) {
                AlbumObjectMetadata meta = this.ao.getMetadata();
                if (!this.title.getText().equals(meta.getTitle())) {
                    meta.setTitle(this.title.getText());
                    this.ao.setMetadata(meta);
                }
            }
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    void moveTo(JAlbumObject dest) {
        if (dest == null) {
            return;
        }
        this.storeChanges();
        this.jao.propertyEditor = null;
        this.jao = dest;
        this.jao.propertyEditor = this;
        this.ao = this.jao.ao;
        try {
            this.updateUI();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        this.getRootPane().setDefaultButton(this.okButton);
        this.setDefaultCloseOperation(2);
        this.commentArea.setLineWrap(true);
        this.commentArea.setWrapStyleWord(true);
        this.commentLabel.setLabelFor(this.commentArea);
        this.commentLabel.setDisplayedMnemonic('C');
        KeyStroke pgUp = KeyStroke.getKeyStroke(33, 0);
        KeyStroke pgDown = KeyStroke.getKeyStroke(34, 0);
        this.previousImageAction = new AbstractAction(Msg.getString("wiz.back")){

            public void actionPerformed(ActionEvent evt) {
                JAlbumObject dest = JPropertyEditor.this.jao.explorer.getPreviousComponent(JPropertyEditor.this.jao);
                JPropertyEditor.this.moveTo(dest);
                if (dest != null) {
                    JAlbumObject previous = dest.explorer.getPreviousComponent(dest);
                    JPropertyEditor.this.imageCache.preload(previous != null ? previous.ao : null);
                }
            }
        };
        this.previousImageAction.putValue("AcceleratorKey", pgUp);
        this.nextImageAction = new AbstractAction(Msg.getString("wiz.next")){

            public void actionPerformed(ActionEvent evt) {
                JAlbumObject dest = JPropertyEditor.this.jao.explorer.getNextComponent(JPropertyEditor.this.jao);
                JPropertyEditor.this.moveTo(dest);
                if (dest != null) {
                    JAlbumObject next = JPropertyEditor.this.jao.explorer.getNextComponent(dest);
                    JPropertyEditor.this.imageCache.preload(next != null ? next.ao : null);
                }
            }
        };
        this.nextImageAction.putValue("AcceleratorKey", pgDown);
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JPropertyEditor.this.storeChanges();
                JPropertyEditor.this.dispose();
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JPropertyEditor.this.dispose();
            }
        };
        JLayeredPane pane = this.getLayeredPane();
        String name = "cancel-dialog";
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        pane.registerKeyboardAction(cancelAction, name, ks, 2);
        this.previousButton = new JButton(this.previousImageAction);
        this.nextButton = new JButton(this.nextImageAction);
        this.cancelButton.addActionListener(cancelAction);
        this.okButton.addActionListener(okAction);
        AbstractAction prevComponent = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                ((Component)e2.getSource()).transferFocusBackward();
            }
        };
        AbstractAction nextComponent = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                ((Component)e2.getSource()).transferFocus();
            }
        };
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        this.commentArea.registerKeyboardAction(prevComponent, "prevComponent", shiftTab, 0);
        this.commentArea.registerKeyboardAction(nextComponent, "nextComponent", tab, 0);
        JComponent c2 = (JComponent)this.getContentPane();
        c2.registerKeyboardAction(this.previousImageAction, "pgUpAction", pgUp, 2);
        c2.registerKeyboardAction(this.nextImageAction, "pgDownAction", pgDown, 2);
        this.commentArea.registerKeyboardAction(this.previousImageAction, "pgUpAction", pgUp, 0);
        this.commentArea.registerKeyboardAction(this.nextImageAction, "pgDownAction", pgDown, 0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                try {
                    JPropertyEditor.this.updateIcon();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        c2.setLayout(new RiverLayout(6, 6));
        c2.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        c2.add("hfill vfill", this.mainPanel);
        c2.add("br right", this.previousButton);
        c2.add(this.nextButton);
        if (JAlbum.isMac()) {
            c2.add(this.cancelButton);
            c2.add(this.okButton);
            c2.add(Box.createRigidArea(new Dimension(6, 1)));
        } else {
            c2.add(this.okButton);
            c2.add(this.cancelButton);
        }
        this.imagePanel.setPreferredSize(new Dimension(400, 400));
        this.imagePanel.setImageBorder(this.createImageBorder());
        this.layoutMainPanel();
        this.updateUI();
        JAlbumObject next = this.jao.explorer.getNextComponent(this.jao);
        this.imageCache.preload(next != null ? next.ao : null);
        this.setLocationRelativeTo(this.relativeTo);
        this.commentArea.requestFocus();
    }

    private Border createImageBorder() {
        Border[] borders = new Border[]{BorderFactory.createLineBorder(new Color(0x333333)), BorderFactory.createLineBorder(new Color(0xFFFEFA), 12), BorderFactory.createLineBorder(new Color(0xC0C0C0))};
        return JAlbumBorders.createCompoundBorder(borders);
    }

    private void layoutMainPanel() {
        JPanel imageContainer = new JPanel(new BorderLayout());
        imageContainer.add(this.imagePanel);
        this.mainPanel.add("hfill vfill", imageContainer);
        if (this.ao.isFolder()) {
            this.isLastFolder = true;
            this.mainPanel.add("p", this.titleLabel);
            this.mainPanel.add("br hfill", this.title);
            this.mainPanel.add("br", this.commentLabel);
        } else {
            this.isLastFolder = false;
            this.mainPanel.add("p", this.commentLabel);
        }
        this.mainPanel.add("br hfill", new JScrollPane(this.commentArea));
        this.pack();
    }

    private void updateUI() throws IOException {
        this.setTitle(Msg.getString("edit.propertyEditorTitle") + " " + this.ao.getName());
        this.imagePanel.setBackgroundImage(null);
        this.titleLabel.setVisible(this.ao.isFolder());
        this.title.setVisible(this.ao.isFolder());
        this.updateIcon();
        if (this.ao.isFolder()) {
            this.title.setText(this.ao.getMetadata().getTitle());
        }
        this.commentArea.setText(this.ao.getComment());
        if (this.ao.isFolder() != this.isLastFolder) {
            this.mainPanel.removeAll();
            this.layoutMainPanel();
        }
    }

    private void updateIcon() throws IOException {
        if (this.ao.isDisplayableImage()) {
            Image closeup = this.imageCache.getImage(this.ao);
            closeup = this.scaleToFit(closeup, this.imagePanel.getDisplayableImageSize(), false);
            this.imagePanel.setBackgroundImage(closeup);
        } else {
            Image closeup = this.ao.getRepresentingIcon(this.imagePanel.getDisplayableImageSize(), false).getImage();
            this.imagePanel.setBackgroundImage(closeup);
        }
        this.imagePanel.repaint();
    }

    private Image scaleToFit(Image image, Dimension boundingBox, boolean highQualityScaling) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        if (newWidth < width && newHeight < height) {
            return ImageCache.scale(image, newWidth, newHeight);
        }
        return image;
    }
}

