/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.SmartFlowLayout;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.util.FileFilters;

public class JExplorerPanel
extends JPanel
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private static final Color rubberBandColor = new Color(SystemColor.textHighlight.getRed(), SystemColor.textHighlight.getGreen(), SystemColor.textHighlight.getBlue(), 70);
    private static final Color dropTargetColor = new Color(200, 200, 200);
    private static final Image dropTargetImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JExplorerPanel.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/droptarget.png")).getImage();
    static final int SMALL_OBJECT_SIZE = 96;
    static final int LARGE_OBJECT_SIZE = 160;
    static final int LABEL_HEIGHT = 20;
    SmartFlowLayout explorerThumbsLayout = new SmartFlowLayout();
    Rectangle rubberband;
    private Point caretLocation;
    ExplorerSelectionModel selectionModel = new ExplorerSelectionModel(this);
    final JAlbumExplorer context;
    JAlbumObject closestComp;
    boolean insertBefore;
    private transient Vector structureListeners;
    Dimension iconBounds;
    Dimension objectSize;
    static /* synthetic */ Class class$se$datadosen$explorer$JAlbumObject;

    public JExplorerPanel(JAlbumExplorer context) {
        this.context = context;
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
        this.setIconBounds(new Dimension(96, 96));
        this.explorerThumbsLayout.setAlignment(0);
        this.explorerThumbsLayout.setHgap(32);
        this.explorerThumbsLayout.setVgap(26);
        this.setLayout(this.explorerThumbsLayout);
        this.setDropTarget(new DropTarget(this, this));
    }

    public void setIconBounds(Dimension bounds) {
        this.iconBounds = bounds;
        this.objectSize = new Dimension(this.iconBounds.width, this.iconBounds.height + 20);
    }

    public Dimension getPreferredSize() {
        Dimension p2 = super.getPreferredSize();
        int preferredWidth = this.getParent().getWidth();
        return new Dimension(preferredWidth, p2.height);
    }

    private boolean isProjectLoaded() {
        return this.context.rootFolder != null && this.context.rootFolder.getName().length() > 0;
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        boolean projectLoaded = this.isProjectLoaded();
        if (!projectLoaded) {
            this.paintDropTarget(g2);
        }
        if (this.rubberband != null) {
            this.paintRubberband(g2);
        }
        if (this.caretLocation != null) {
            this.paintCaret(g2);
        }
        this.context.newFolderAction.setEnabled(projectLoaded);
    }

    private void paintDropTarget(Graphics g2) {
        int cw2 = this.getWidth();
        int ch2 = this.getHeight();
        int iw = dropTargetImage.getWidth(null);
        int ih = dropTargetImage.getHeight(null);
        int ix = (cw2 - iw) / 2;
        int iy = (ch2 - ih) / 2 - 18;
        g2.drawImage(dropTargetImage, ix, iy, this);
        g2.setColor(dropTargetColor);
        String dropString = Msg.getString("ui.dropPrompt");
        Font oldFont = g2.getFont();
        g2.setFont(new Font("SansSerif", 1, 15));
        Rectangle2D sb = g2.getFontMetrics().getStringBounds(dropString, g2);
        int sw = (int)sb.getWidth();
        int sh = (int)sb.getHeight();
        int sx = (cw2 - sw) / 2;
        int sy = iy + ih + sh + 8;
        g2.drawString(dropString, sx, sy);
        g2.setFont(oldFont);
    }

    private void paintRubberband(Graphics g2) {
        g2.setColor(rubberBandColor);
        g2.fillRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
        g2.setColor(SystemColor.textHighlight);
        g2.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
    }

    private void paintCaret(Graphics g2) {
        g2.setColor(Color.black);
        Point cl2 = this.caretLocation;
        int h2 = this.objectSize.height + 4;
        g2.fillRect(cl2.x, cl2.y, 2, h2);
        g2.drawLine(cl2.x - 2, cl2.y, cl2.x + 3, cl2.y);
        g2.drawLine(cl2.x - 1, cl2.y + 1, cl2.x + 2, cl2.y + 1);
        g2.drawLine(cl2.x - 2, cl2.y + h2, cl2.x + 3, cl2.y + h2);
        g2.drawLine(cl2.x - 1, cl2.y + h2 - 1, cl2.x + 2, cl2.y + h2 - 1);
    }

    JAlbumObject getPreviousComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i2 = 1; i2 < comps.length; ++i2) {
            if (comps[i2] != rel) continue;
            return (JAlbumObject)comps[i2 - 1];
        }
        return null;
    }

    JAlbumObject getNextComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i2 = 0; i2 < comps.length - 1; ++i2) {
            if (comps[i2] != rel) continue;
            return (JAlbumObject)comps[i2 + 1];
        }
        return null;
    }

    Component getNearestComponent(Point p2) {
        Component nearestComp = null;
        Rectangle smallest = null;
        Component[] comps = this.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            Rectangle bounds = comps[i2].getBounds();
            if (bounds.contains(p2)) {
                return comps[i2];
            }
            bounds.add(p2);
            if (smallest != null && bounds.width * bounds.height >= smallest.width * smallest.height) continue;
            smallest = bounds;
            nearestComp = comps[i2];
        }
        return nearestComp;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if ((dtde.getSourceActions() & 0x40000000) != 0) {
            dtde.acceptDrag(0x40000000);
        } else {
            dtde.acceptDrag(dtde.getSourceActions());
        }
        Rectangle r2 = new Rectangle(dtde.getLocation(), new Dimension(60, 60));
        r2.translate(-30, -30);
        this.scrollRectToVisible(r2);
        Point dragLocation = dtde.getLocation();
        int xpos = this.getInsets().left;
        int ypos = this.getInsets().top;
        JAlbumObject jao = this.closestComp = (JAlbumObject)this.getNearestComponent(dragLocation);
        if (jao != null) {
            ypos = jao.getY() - 2;
            int center = jao.getX() + jao.getWidth() / 2;
            this.insertBefore = dragLocation.x < center;
            xpos = this.insertBefore ? jao.getX() - this.explorerThumbsLayout.hgap / 2 : jao.getX() + jao.getWidth() + this.explorerThumbsLayout.hgap / 2;
        }
        this.caretLocation = new Point(xpos, ypos);
        if (jao != null && jao.isSelected()) {
            this.caretLocation = null;
            this.closestComp = null;
        }
        this.repaint();
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
        this.caretLocation = null;
        this.repaint();
    }

    public void drop(DropTargetDropEvent dtde) {
        this.caretLocation = null;
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            if (this.getComponentCount() > 0 && this.closestComp == null) {
                dtde.rejectDrop();
                return;
            }
            try {
                dtde.acceptDrop(dtde.getDropAction());
                if (dtde.isDataFlavorSupported(JAlbumObject.jAlbumObjectFlavor)) {
                    this.handleJAlbumObjectDrop(dtde);
                } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) ? this.handleFileDrop(dtde) : dtde.isDataFlavorSupported(DataFlavor.stringFlavor) && this.handleFileDrop(dtde, true)) {
                    return;
                }
                dtde.dropComplete(true);
                this.context.currentFolder.setOrdering("custom");
                this.context.customOrderingAction.setSelected(true);
                this.context.handleDisablingOfOrderingMenus();
                this.fireStructureChanged(new StructureEvent(this));
            }
            catch (Exception exc) {
                exc.printStackTrace();
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
        this.validate();
        this.repaint();
    }

    private void handleJAlbumObjectDrop(DropTargetDropEvent dtde) {
        ArrayList<JAlbumObject> objectsToMove = new ArrayList<JAlbumObject>();
        Component[] comps = this.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (!jao.isSelected()) continue;
            this.remove(jao);
            objectsToMove.add(jao);
        }
        if (objectsToMove.size() > 0) {
            int insertIndex = this.findInsertIndex();
            Iterator it = objectsToMove.iterator();
            while (it.hasNext()) {
                this.add((Component)((JAlbumObject)it.next()), insertIndex++);
            }
        }
    }

    private boolean handleFileDrop(DropTargetDropEvent dtde) {
        try {
            List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            dtde.dropComplete(true);
            return this.handleFileAdd(files);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private boolean handleFileDrop(DropTargetDropEvent dtde, boolean isStringFlavor) {
        try {
            String urls = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
            LinkedList<File> files = new LinkedList<File>();
            StringTokenizer tokens = new StringTokenizer(urls);
            while (tokens.hasMoreTokens()) {
                String urlString = tokens.nextToken();
                URL url = new URL(urlString);
                files.add(new File(URLDecoder.decode(url.getFile(), "UTF-8")));
            }
            dtde.dropComplete(true);
            return this.handleFileAdd(files);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private List filterSupportedFiles(List files) {
        LinkedList<File> supported = new LinkedList<File>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File f2 = (File)it.next();
            if (!FileFilters.isFileSupported(f2) && !FileFilters.hasIcon(f2)) continue;
            supported.add(f2);
        }
        return supported;
    }

    public boolean handleFileAdd(List files) {
        if (this.handleSpecialFileTypes(files)) {
            return true;
        }
        if (this.needsDelayedProcessing(files)) {
            return true;
        }
        files = this.filterSupportedFiles(files);
        if (this.context.currentFolder == null) {
            this.context.currentFolder = this.context.rootFolder;
        }
        AlbumObjectFactory factory = new AlbumObjectFactory(JAlbum.mainFrame.getEngine());
        int insertIndex = this.findInsertIndex();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            File target = (File)iter.next();
            LinkFile link = new LinkFile(this.context.currentFolder.getFile(), target.getName(), target);
            AlbumObject ao = factory.createInstance(link, this.context.currentFolder);
            JAlbumObject jao = new JAlbumObject(ao, this);
            this.context.prepareJAO(jao);
            this.add((Component)jao, insertIndex++);
        }
        this.validate();
        this.context.currentFolder.invalidate();
        this.fireStructureChanged(new StructureEvent(this));
        return false;
    }

    private boolean handleSpecialFileTypes(List files) {
        if (files.size() > 0) {
            File file = (File)files.get(0);
            String fileName = file.getName();
            if (fileName.endsWith(".jap")) {
                this.createOrLoadProject(files);
                return true;
            }
            if (fileName.endsWith(".jaskin")) {
                new SkinManager().installSkin(file);
                return true;
            }
        }
        return false;
    }

    private int findInsertIndex() {
        int insertIndex = -1;
        Component[] comps = this.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            if (comps[i2] != this.closestComp) continue;
            insertIndex = i2;
            if (this.insertBefore) break;
            ++insertIndex;
            break;
        }
        if (insertIndex < 0) {
            insertIndex = comps.length;
        }
        return insertIndex;
    }

    private boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        for (int i2 = 0; i2 < flavors.length; ++i2) {
            DataFlavor dropFlavor = flavors[i2];
            if (!dropFlavor.equals(DataFlavor.javaFileListFlavor) && !dropFlavor.equals(JAlbumObject.jAlbumObjectFlavor) && !dropFlavor.equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        event.startDrag(null, (JAlbumObject)event.getComponent(), this);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void remove(Component comp) {
        super.remove(comp);
        JAlbumObject jao = (JAlbumObject)comp;
        if (jao.isSelected()) {
            this.selectionModel.objectSelected(jao, false);
        }
    }

    public void removeAll() {
        super.removeAll();
        this.selectionModel.deselectAll();
    }

    public synchronized void removeStructureListener(StructureListener l2) {
        if (this.structureListeners != null && this.structureListeners.contains(l2)) {
            Vector v2 = (Vector)this.structureListeners.clone();
            v2.removeElement(l2);
            this.structureListeners = v2;
        }
    }

    public synchronized void addStructureListener(StructureListener l2) {
        Vector v2;
        Vector vector = v2 = this.structureListeners == null ? new Vector(2) : (Vector)this.structureListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.structureListeners = v2;
        }
    }

    protected void fireStructureChanged(StructureEvent e2) {
        if (this.structureListeners != null) {
            Vector listeners = this.structureListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((StructureListener)listeners.elementAt(i2)).structureChanged(e2);
            }
        }
    }

    private boolean needsDelayedProcessing(final List files) {
        if (this.isProjectLoaded()) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JExplorerPanel.this.createOrLoadProject(files);
            }
        });
        return true;
    }

    private void createOrLoadProject(List files) {
        if (files.size() == 1) {
            File file = (File)files.get(0);
            if (file.isDirectory()) {
                File projectFile = new File(file, "jalbum-settings.jap");
                if (projectFile.exists()) {
                    this.context.parent.loadProject(projectFile);
                } else {
                    this.context.parent.initProject(file);
                }
            } else if (file.getName().endsWith(".jap")) {
                this.context.parent.loadProject(file);
            } else {
                this.showNewProjectDialog(this.filterSupportedFiles(files));
            }
        } else {
            this.showNewProjectDialog(this.filterSupportedFiles(files));
        }
    }

    private void showNewProjectDialog(List files) {
        JNewProjectDialog newProjectDialog = new JNewProjectDialog(this.context.parent);
        String albumNameSuggestion = this.findAlbumNameSuggestion(files);
        newProjectDialog.setAlbumName(albumNameSuggestion);
        newProjectDialog.setFiles(files);
        this.context.parent.show(newProjectDialog);
    }

    private String findAlbumNameSuggestion(List files) {
        String parentNameForAllFiles = null;
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            String parentNameOfCurrentFile = file.getParentFile().getName();
            if (parentNameForAllFiles == null) {
                parentNameForAllFiles = parentNameOfCurrentFile;
                continue;
            }
            if (parentNameForAllFiles.equals(parentNameOfCurrentFile)) continue;
            return Msg.getString("newproject.defaultName");
        }
        return parentNameForAllFiles;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

