/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.JPropertyEditor;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;

public class JAlbumObject
extends JComponent
implements Transferable,
PropertyChangeListener {
    public static DataFlavor jAlbumObjectFlavor = new DataFlavor(class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject, "JAlbum object");
    private static Image infoImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/message.png")).getImage();
    private static Image miniFolderImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/minifolder_closed.png")).getImage();
    private static Image filmImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/film.png")).getImage();
    private static Image crossImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/delete2.png")).getImage();
    private static ImageIcon defaultImageIcon;
    private static final int MINI_IMAGE_WIDTH = 16;
    public static final Font labelFont;
    private Image linkImage;
    public final AlbumObject ao;
    final JExplorerPanel explorer;
    private boolean selected;
    private boolean editing;
    private boolean rubberbanded;
    private boolean isMediaFile;
    private JPanel imagePanel = new JPanel();
    private JLabel image;
    private JLabel label;
    private JTextField nameField;
    JPanel labelPanel;
    private boolean renderingDone = false;
    private boolean firstPaint = true;
    JPropertyEditor propertyEditor;
    static /* synthetic */ Class class$se$datadosen$explorer$JAlbumObject;

    public JAlbumObject(final AlbumObject ao, JExplorerPanel context) {
        this.ao = ao;
        this.explorer = context;
        ao.addPropertyChangeListener("comment", this);
        this.linkImage = JAlbum.isMac() ? new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/link_mac.png")).getImage() : new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = JAlbumObject.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/link.png")).getImage();
        this.setLayout(new BorderLayout());
        try {
            if (ao.isDisplayableImage()) {
                this.image = new JLabel(defaultImageIcon);
            } else {
                this.image = new JLabel(ao.getRepresentingIcon(context.iconBounds, false));
                this.renderingDone = true;
            }
        }
        catch (IOException ex) {
            this.image = new JLabel("No image");
            this.renderingDone = true;
        }
        this.image.setPreferredSize(context.iconBounds);
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setOpaque(false);
        this.imagePanel.add((Component)this.image, "North");
        this.add((Component)this.imagePanel, "North");
        this.label = new JLabel(ao.getName());
        this.label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                e2.setSource(JAlbumObject.this);
                e2.translatePoint(JAlbumObject.this.labelPanel.getX(), JAlbumObject.this.labelPanel.getY());
                JAlbumObject.this.explorer.context.mouseOnComponentAdapter.mousePressed(e2);
            }

            public void mouseReleased(MouseEvent e2) {
                e2.setSource(JAlbumObject.this);
                e2.translatePoint(JAlbumObject.this.labelPanel.getX(), JAlbumObject.this.labelPanel.getY());
                JAlbumObject.this.explorer.context.mouseOnComponentAdapter.mouseReleased(e2);
            }
        });
        this.label.setFont(labelFont);
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        int labelW = context.iconBounds.width;
        int labelH = this.label.getPreferredSize().height;
        this.label.setPreferredSize(new Dimension(labelW, labelH));
        this.nameField = new JTextField();
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JAlbumObject.this.setEditing(false);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    JAlbumObject.this.nameField.setText(ao.getName());
                    JAlbumObject.this.setEditing(false);
                }
            }
        });
        if (!JAlbum.isMac()) {
            this.nameField.setFont(this.label.getFont());
        }
        this.nameField.setText(this.label.getText());
        int nameFieldW = context.iconBounds.width;
        int nameFieldH = this.nameField.getPreferredSize().height;
        this.nameField.setPreferredSize(new Dimension(nameFieldW, nameFieldH));
        this.labelPanel = new JPanel();
        FlowLayout fl = new FlowLayout(1, 0, 3);
        this.labelPanel.setLayout(fl);
        this.labelPanel.setOpaque(false);
        this.labelPanel.add(this.label);
        int maxWidth = Math.max(this.label.getPreferredSize().width, this.nameField.getPreferredSize().width);
        int maxHeight = Math.max(this.label.getPreferredSize().height, this.nameField.getPreferredSize().height);
        this.labelPanel.setPreferredSize(new Dimension(maxWidth, maxHeight + 3));
        this.add((Component)this.labelPanel, "Center");
        this.setSelected(this.selected);
        File rep = ao.getRepresentingIconFile();
        if (rep != null && rep.getName().endsWith(".THM")) {
            this.isMediaFile = true;
        }
    }

    void renderIcon() {
        try {
            this.image.setIcon(this.ao.getRepresentingIcon(this.explorer.iconBounds, false));
            this.renderingDone = true;
        }
        catch (IOException ex) {
            this.image.setText("Broken");
            this.renderingDone = true;
        }
    }

    public void paint(Graphics g2) {
        File rep;
        int xpos = 2;
        if (this.firstPaint) {
            this.updateToolTip();
            this.firstPaint = false;
        }
        Graphics2D g2d = (Graphics2D)g2;
        super.paint(g2);
        if (this.ao.getComment().length() > 0) {
            g2d.drawImage(infoImage, 1, 2, null);
            xpos += 16;
        }
        if (this.explorer.context.currentFolder != null && (rep = this.explorer.context.currentFolder.getRepresentingIconFile()) != null && rep.equals(this.ao.getFile())) {
            g2d.drawImage(miniFolderImage, xpos, 2, null);
            xpos += 16;
        }
        if (this.isMediaFile) {
            g2d.drawImage(filmImage, xpos, 2, null);
            xpos += 16;
        }
        if (this.ao.isLink()) {
            int ypos = this.image.getHeight() - this.linkImage.getHeight(null);
            g2d.drawImage(this.linkImage, 2, ypos, null);
        }
        if (!this.ao.isIncluded()) {
            g2d.drawImage(crossImage, (this.image.getWidth() - crossImage.getWidth(null)) / 2, (this.image.getHeight() - crossImage.getHeight(null)) / 2, null);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    boolean isEditing() {
        return this.editing;
    }

    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        if (editing) {
            this.labelPanel.removeAll();
            this.labelPanel.add(this.nameField);
            this.nameField.setText(this.ao.getName());
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.ao.getName().length());
            this.labelPanel.validate();
            this.nameField.requestFocus();
        } else {
            String newName = this.nameField.getText();
            if (!newName.equals(this.ao.getName())) {
                this.setLabel(newName);
            }
            this.label.setText(this.ao.getName());
            this.labelPanel.removeAll();
            this.labelPanel.add(this.label);
            this.updateToolTip();
            this.labelPanel.validate();
            this.repaint();
        }
    }

    private void updateToolTip() {
        this.label.setToolTipText(this.ao.getName());
        String comment = this.ao.getComment();
        if (comment != null && comment.length() > 0) {
            this.setToolTipText("<html><body>" + this.ao.getComment() + "</body></html>");
        } else if (this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
    }

    public void setLabel(String name) {
        String oldName = this.ao.getName();
        if (!this.ao.setName(name)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.firePropertyChange("label", oldName, name);
        }
    }

    public void setRubberbanded(boolean rubberbanded) {
        if (this.rubberbanded != rubberbanded) {
            this.setSelected(!this.selected);
        }
        this.rubberbanded = rubberbanded;
    }

    public void resetRubberbanded() {
        this.rubberbanded = false;
    }

    public boolean isIncluded() {
        return this.ao.isIncluded();
    }

    public void setIncluded(boolean included) {
        this.ao.setIncluded(included);
        this.repaint();
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        if (selected) {
            this.imagePanel.setBorder(JAlbumBorders.createSelectedImageBorder());
            this.label.setForeground(SystemColor.textHighlightText);
            this.label.setBackground(SystemColor.textHighlight);
        } else {
            this.setEditing(false);
            this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
            this.label.setForeground(SystemColor.textText);
            this.label.setBackground(SystemColor.text);
        }
        if (selected != oldSelected) {
            this.explorer.selectionModel.objectSelected(this, selected);
        }
    }

    public Object getTransferData(DataFlavor flavor) {
        if (flavor.equals(jAlbumObjectFlavor)) {
            return this;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{jAlbumObjectFlavor};
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return true;
    }

    public void openPropertyEditor() {
        this.openPropertyEditor(this);
    }

    public void openPropertyEditor(Component relativeTo) {
        if (this.propertyEditor == null) {
            this.explorer.setCursor(new Cursor(3));
            this.propertyEditor = new JPropertyEditor(this, relativeTo);
            this.propertyEditor.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e2) {
                    JAlbumObject.this.propertyEditor = null;
                }
            });
            this.explorer.setCursor(new Cursor(0));
        }
        this.propertyEditor.setVisible(true);
        System.out.println("Thumbnail path: " + this.ao.getThumbnailPath());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("comment".equals(evt.getPropertyName())) {
            this.updateToolTip();
        }
    }

    public String toString() {
        return this.getClass().getName() + " [name=" + this.ao.getName() + "]";
    }

    public boolean isRenderingDone() {
        return this.renderingDone;
    }

    static {
        try {
            defaultImageIcon = new ImageIcon(new File(Config.getConfig().progDir, "res/img.gif").toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
        labelFont = new Font("SansSerif", 0, 11);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

