/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.jalbum.slideshow.SlideShow;
import net.jalbum.slideshow.SlideShowFactory;
import org.jdesktop.swingx.MultiSplitLayout;
import org.jdesktop.swingx.MultiSplitPane;
import se.datadosen.component.CutCornersBorder;
import se.datadosen.component.NonCollapsableJTree;
import se.datadosen.component.ToggleAction;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.event.SelectionListener;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.util.Debug;

public class JAlbumExplorer
extends JPanel {
    public static final int IMAGE_CACHE_SIZE = 10;
    JAlbumFrame parent;
    AlbumObject rootFolder;
    AlbumObject currentFolder;
    ImageCache imageCache;
    MouseAdapter mouseOnComponentAdapter;
    private MouseAdapter mouseOnTreeAdapter;
    private Point startingPoint;
    public Action parentFolderAction;
    public Action refreshAction;
    public Action largeThumbnailsAction;
    public Action hideExcludedAction;
    public Action slideShowAction;
    private Action renameAction;
    public Action openAction;
    public Action commentAction;
    public Action propertiesAction;
    private Action useAsFolderThumbnailAction;
    public Action deleteAction;
    public Action newFolderAction;
    private Action includeSelectedAction;
    private Action excludeSelectedAction;
    public Action rotateLeftAction;
    public Action rotateRightAction;
    public Action pasteAction;
    public Action selectAllAction;
    public Action invertSelectionAction;
    public ToggleAction orderByNameAction;
    public ToggleAction orderByDateAction;
    public ToggleAction orderByCameraDateAction;
    public ToggleAction customOrderingAction;
    public ToggleAction useJAlbumOrderingAction;
    public ToggleAction reverseOrderingAction;
    public ToggleAction foldersFirstAction;
    public ToggleAction orderFoldersByNameAction;
    public ToggleAction orderFoldersByDateAction;
    public ToggleAction reverseFolderOrderingAction;
    public Action shuffleAction;
    private Action includeNodeAction;
    private Action excludeNodeAction;
    private Action deleteNodeAction;
    private Action renameNodeAction;
    private JMenu orderingSubMenu;
    private JMenu folderOrderingSubMenu;
    private MultiSplitPane splitPane = new MultiSplitPane();
    private JScrollPane treeScrollPane = new JScrollPane();
    private JScrollPane explorerScrollPane = new JScrollPane();
    private JTree tree = new NonCollapsableJTree((TreeModel)null);
    public JExplorerPanel explorer = new JExplorerPanel(this);
    JPopupMenu explorerPopup = new JPopupMenu();
    JPopupMenu componentPopup = new JPopupMenu();
    JPopupMenu treeNodePopup = new JPopupMenu();
    public JCheckBoxMenuItem hideExcludedMenuItem;
    public JCheckBoxMenuItem largeThumbnailsMenuItem;
    JCheckBoxMenuItem useAsFolderThumbnailMenuItem;
    static /* synthetic */ Class class$se$datadosen$jalbum$RemoteFSTreeCellRenderer;

    public JAlbumExplorer(JAlbumFrame parent) {
        this.parent = parent;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.enableEvents(64L);
    }

    private void init() throws Exception {
        Class<?> cl2 = this.getClass();
        ImageIcon openIcon = new ImageIcon(cl2.getResource("openFile.png"));
        ImageIcon closeIcon = new ImageIcon(cl2.getResource("closeFile.png"));
        ImageIcon helpIcon = new ImageIcon(cl2.getResource("help.png"));
        JAlbumExplorer contentPane = this;
        contentPane.setLayout(new BorderLayout());
        this.explorer.setBackground(SystemColor.text);
        this.explorerScrollPane.setPreferredSize(new Dimension(420, 80));
        this.explorerScrollPane.getVerticalScrollBar().setUnitIncrement(70);
        if (JAlbum.isMac()) {
            this.explorerScrollPane.setVerticalScrollBarPolicy(22);
        }
        this.explorerScrollPane.setHorizontalScrollBarPolicy(31);
        this.explorer.addStructureListener(new StructureListener(){

            public void structureChanged(StructureEvent e2) {
                JAlbumExplorer.this.syncModel();
                JAlbumExplorer.this.refreshCurrentNode();
            }
        });
        this.explorer.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                int code = e2.getKeyCode();
                if (code == 38 || code == 40 || code == 37 || code == 39) {
                    this.processArrowKeys(e2);
                    e2.consume();
                }
            }

            void processArrowKeys(KeyEvent ke) {
                JAlbumObject focused = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                if (focused != null) {
                    int dir2 = 0;
                    switch (ke.getKeyCode()) {
                        case 38: {
                            dir2 = 1;
                            break;
                        }
                        case 40: {
                            dir2 = 2;
                            break;
                        }
                        case 37: {
                            dir2 = 3;
                            break;
                        }
                        case 39: {
                            dir2 = 4;
                        }
                    }
                    JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getNeighbourObject(focused, dir2);
                    MouseEvent me = new MouseEvent(jao, 0, ke.getWhen(), ke.getModifiers(), 0, 0, 1, false);
                    JAlbumExplorer.this.explorer.scrollRectToVisible(new Rectangle(jao.getLocation(), jao.getSize()));
                    JAlbumExplorer.this.mouseOnComponentAdapter.mousePressed(me);
                }
            }
        });
        contentPane.add((Component)this.splitPane, "Center");
        JPanel left = new JPanel(new BorderLayout());
        this.treeScrollPane.getViewport().add(this.tree);
        left.add((Component)this.treeScrollPane, "Center");
        left.add((Component)this.parent.mainSettingsPanel, "South");
        JPanel right = new JPanel(new BorderLayout());
        this.explorerScrollPane.getViewport().add((Component)this.explorer, null);
        this.explorer.setAutoscrolls(true);
        right.add((Component)this.explorerScrollPane, "Center");
        List<Object> children = Arrays.asList(new MultiSplitLayout.Leaf("left"), new MultiSplitLayout.Divider(), new MultiSplitLayout.Leaf("right"));
        MultiSplitLayout.Split modelRoot = new MultiSplitLayout.Split();
        modelRoot.setChildren(children);
        this.splitPane.getMultiSplitLayout().setModel(modelRoot);
        this.splitPane.add((Component)left, "left");
        this.splitPane.add((Component)right, "right");
        this.splitPane.setDividerSize(JAlbum.isMac() ? 8 : 5);
        if (JAlbum.isMac()) {
            this.treeScrollPane.setBorder(new CutCornersBorder(false, true));
            this.explorerScrollPane.setBorder(new CutCornersBorder(true, false));
            left.setBorder(null);
            this.splitPane.setDividerPainter(new MultiSplitPane.DividerPainter(){

                public void paint(Graphics gg, MultiSplitLayout.Divider divider) {
                    Graphics2D g2 = (Graphics2D)gg;
                    Rectangle r2 = divider.getBounds();
                    g2.setColor(Color.red);
                    int x0 = r2.x + r2.width / 2;
                    int y0 = JAlbumExplorer.this.treeScrollPane.getHeight() / 2;
                    g2.setColor(new Color(0, 0, 0, 80));
                    g2.setStroke(new BasicStroke(1.3f));
                    g2.drawOval(x0 - 2, y0, 3, 3);
                }
            });
        } else {
            left.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        }
        this.tree.setBorder(BorderFactory.createEmptyBorder(1, JAlbum.isMac() ? 6 : 2, 1, 1));
        right.setBorder(null);
        contentPane.setBorder(null);
        this.splitPane.setBorder(null);
        KeyStroke backspace = KeyStroke.getKeyStroke(8, 0);
        KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
        KeyStroke f5 = KeyStroke.getKeyStroke(116, 0);
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        KeyStroke ctrlA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke altEnter = KeyStroke.getKeyStroke(10, 8);
        KeyStroke altGrEnter = KeyStroke.getKeyStroke(10, 2);
        KeyStroke plus = KeyStroke.getKeyStroke('+');
        KeyStroke minus = KeyStroke.getKeyStroke('-');
        this.pasteAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                JAlbumExplorer.this.parent.addWindowFocusListener(new WindowAdapter(){

                    public void windowGainedFocus(WindowEvent e2) {
                        JAlbumExplorer.this.handlePasteActionEnabling();
                    }
                });
            }

            public void actionPerformed(ActionEvent e2) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable t2 = clipboard.getContents(JAlbumExplorer.this.explorer);
                try {
                    if (t2.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t2.getTransferData(DataFlavor.javaFileListFlavor);
                        JAlbumExplorer.this.explorer.handleFileAdd(files);
                    }
                }
                catch (IOException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this, ex);
                    ex.printStackTrace();
                }
                catch (UnsupportedFlavorException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this, ex);
                    ex.printStackTrace();
                }
            }
        };
        this.parentFolderAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                if (JAlbumExplorer.this.currentFolder != null && JAlbumExplorer.this.currentFolder.getParent() != null) {
                    JAlbumExplorer.this.selectNode(JAlbumExplorer.this.currentFolder.getParent());
                }
            }
        };
        if (!JAlbum.isMac()) {
            this.parentFolderAction.putValue("AcceleratorKey", backspace);
        }
        this.renameAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null) {
                    selected.setEditing(true);
                }
            }
        };
        this.renameAction.putValue("AcceleratorKey", f2);
        this.refreshAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.rootFolder.invalidate();
                JAlbumExplorer.this.setRootFolder(JAlbumExplorer.this.rootFolder);
                JAlbumExplorer.this.selectNode(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.refreshAction.putValue("AcceleratorKey", f5);
        this.openAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    JAlbumExplorer.this.open(jao);
                }
            }
        };
        this.openAction.putValue("AcceleratorKey", enter);
        this.commentAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.propertiesAction.actionPerformed(e2);
            }
        };
        this.propertiesAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                if (list.size() == 0) {
                    JAlbumObject jao = new JAlbumObject(JAlbumExplorer.this.currentFolder, JAlbumExplorer.this.explorer);
                    jao.openPropertyEditor(JAlbumExplorer.this.explorer);
                }
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    jao.openPropertyEditor();
                }
            }
        };
        this.propertiesAction.putValue("AcceleratorKey", altEnter);
        this.hideExcludedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.largeThumbnailsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                if (JAlbumExplorer.this.largeThumbnailsMenuItem.isSelected()) {
                    JAlbumExplorer.this.explorer.setIconBounds(new Dimension(160, 160));
                } else {
                    JAlbumExplorer.this.explorer.setIconBounds(new Dimension(96, 96));
                }
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.useAsFolderThumbnailAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                if (JAlbumExplorer.this.useAsFolderThumbnailMenuItem.isSelected()) {
                    JAlbumExplorer.this.currentFolder.setRepresentingIconFile(jao.ao.getFile());
                } else {
                    JAlbumExplorer.this.currentFolder.setRepresentingIconFile(null);
                }
                JAlbumExplorer.this.explorer.repaint();
            }
        };
        this.deleteAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                int answer;
                JAlbumObject jao;
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                if (list.size() == 0) {
                    return;
                }
                int physicalFilesOrFoldersSelected = 0;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    jao = (JAlbumObject)it.next();
                    if (jao.ao.isLink()) continue;
                    ++physicalFilesOrFoldersSelected;
                }
                if (physicalFilesOrFoldersSelected > 0 && (answer = JOptionPane.showConfirmDialog(JAlbumExplorer.this, MessageFormat.format(Msg.getString("edit.deletePermanentlyInfo"), new Integer(physicalFilesOrFoldersSelected)), Msg.getString("edit.deleteFilesTitle"), 0, 2)) != 0) {
                    return;
                }
                try {
                    it = list.iterator();
                    while (it.hasNext()) {
                        jao = (JAlbumObject)it.next();
                        jao.ao.delete();
                        JAlbumExplorer.this.explorer.remove(jao);
                    }
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                catch (PermissionException ex) {
                    JOptionPane.showMessageDialog(JAlbumExplorer.this, ex.getMessage(), Msg.getString("edit.deleteFilesTitle"), 0);
                }
                JAlbumExplorer.this.explorer.validate();
                JAlbumExplorer.this.explorer.repaint();
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.deleteAction.putValue("AcceleratorKey", JAlbum.isMac() ? backspace : delete);
        this.newFolderAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    AlbumObject ao = JAlbumExplorer.this.currentFolder.createFolder(Msg.getString("edit.newFolder"));
                    JAlbumObject jao = JAlbumExplorer.this.addJAO(ao);
                    JAlbumExplorer.this.explorer.validate();
                    JAlbumExplorer.this.explorer.repaint();
                    JAlbumExplorer.this.refreshCurrentNode();
                    JAlbumExplorer.this.explorer.scrollRectToVisible(new Rectangle(jao.getLocation(), jao.getSize()));
                    jao.setEditing(true);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
            }
        };
        this.includeSelectedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    jao.setIncluded(true);
                    jao.setVisible(true);
                }
                JAlbumExplorer.this.syncModel();
                JAlbumExplorer.this.tree.repaint();
            }
        };
        this.includeSelectedAction.putValue("AcceleratorKey", plus);
        this.excludeSelectedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                LinkedList list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                boolean hideExcluded = JAlbumExplorer.this.hideExcludedMenuItem.isSelected();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    JAlbumObject jao = (JAlbumObject)it.next();
                    jao.setIncluded(false);
                    if (!hideExcluded) continue;
                    jao.setVisible(false);
                }
                JAlbumExplorer.this.syncModel();
                JAlbumExplorer.this.tree.repaint();
            }
        };
        this.excludeSelectedAction.putValue("AcceleratorKey", minus);
        this.rotateLeftAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.adjustOrientation(false);
            }
        };
        this.rotateRightAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.adjustOrientation(true);
            }
        };
        this.selectAllAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.explorer.selectionModel.selectAll();
            }
        };
        this.selectAllAction.putValue("AcceleratorKey", ctrlA);
        this.invertSelectionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.explorer.selectionModel.invertSelection();
            }
        };
        this.slideShowAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.startSlideshow();
            }
        };
        this.orderByNameAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.setOrdering("name");
            }
        };
        this.orderByDateAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.setOrdering("date");
            }
        };
        this.orderByCameraDateAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.setOrdering("cameraDate");
            }
        };
        this.customOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.setOrdering("custom");
            }
        };
        this.useJAlbumOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.setOrdering("jalbum");
            }
        };
        this.reverseOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    JAlbumExplorer.this.currentFolder.setReverseOrdering(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.foldersFirstAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    JAlbumExplorer.this.currentFolder.setFoldersFirst(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.orderFoldersByNameAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.setFolderOrdering("name");
            }
        };
        this.orderFoldersByDateAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.setFolderOrdering("date");
            }
        };
        this.reverseFolderOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e2) {
                try {
                    JAlbumExplorer.this.currentFolder.setReverseFolderOrdering(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.shuffleAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                Collections.shuffle(Arrays.asList(comps));
                JAlbumExplorer.this.explorer.removeAll();
                for (int i2 = 0; i2 < comps.length; ++i2) {
                    JAlbumExplorer.this.explorer.add(comps[i2]);
                }
                JAlbumExplorer.this.explorer.validate();
                JAlbumExplorer.this.explorer.repaint();
                JAlbumExplorer.this.syncModel();
                try {
                    JAlbumExplorer.this.currentFolder.setOrdering("custom");
                    JAlbumExplorer.this.customOrderingAction.setSelected(true);
                    JAlbumExplorer.this.handleDisablingOfOrderingMenus();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.includeNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.currentFolder.setIncluded(true);
                JAlbumExplorer.this.tree.repaint();
                try {
                    JAlbumExplorer.this.currentFolder.getParent().setChildren(JAlbumExplorer.this.currentFolder.getParent().getChildren());
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        this.excludeNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.currentFolder.setIncluded(false);
                JAlbumExplorer.this.tree.repaint();
                try {
                    JAlbumExplorer.this.currentFolder.getParent().setChildren(JAlbumExplorer.this.currentFolder.getParent().getChildren());
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        this.deleteNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
            }
        };
        this.renameNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                JAlbumExplorer.this.tree.startEditingAtPath(JAlbumExplorer.this.tree.getLeadSelectionPath());
            }
        };
        this.explorer.registerKeyboardAction(this.selectAllAction, "selectAllAction", ctrlA, 2);
        this.explorer.registerKeyboardAction(this.parentFolderAction, "parentFolder", backspace, 0);
        this.tree.registerKeyboardAction(this.parentFolderAction, "parentFolder", backspace, 0);
        this.explorer.registerKeyboardAction(this.renameAction, "editNameAction", f2, 2);
        this.explorer.registerKeyboardAction(this.openAction, "openAction", enter, 2);
        this.explorer.registerKeyboardAction(this.propertiesAction, "propertiesAction", altEnter, 2);
        this.explorer.registerKeyboardAction(this.propertiesAction, "propertiesAction", altGrEnter, 2);
        this.explorer.registerKeyboardAction(this.deleteAction, "deleteAction", JAlbum.isMac() ? backspace : delete, 0);
        this.explorer.registerKeyboardAction(this.includeSelectedAction, "includeSelectedAction", plus, 2);
        this.explorer.registerKeyboardAction(this.excludeSelectedAction, "excludeSelectedAction", minus, 2);
        contentPane.registerKeyboardAction(this.refreshAction, "update", f5, 2);
        this.componentPopup.add(this.openAction);
        this.componentPopup.add(this.invertSelectionAction);
        this.componentPopup.add(this.slideShowAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.rotateLeftAction);
        this.componentPopup.add(this.rotateRightAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.excludeSelectedAction);
        this.componentPopup.add(this.includeSelectedAction);
        this.componentPopup.addSeparator();
        this.useAsFolderThumbnailMenuItem = new JCheckBoxMenuItem(this.useAsFolderThumbnailAction);
        this.componentPopup.add(this.useAsFolderThumbnailMenuItem);
        this.componentPopup.add(this.deleteAction);
        this.componentPopup.add(this.renameAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.propertiesAction);
        this.explorerPopup.add(this.pasteAction);
        this.explorerPopup.add(this.selectAllAction);
        this.explorerPopup.add(this.slideShowAction);
        this.orderingSubMenu = new JMenu();
        this.folderOrderingSubMenu = new JMenu();
        this.populateOrderingSubMenu(this.orderingSubMenu);
        this.populateFolderOrderingSubMenu(this.folderOrderingSubMenu);
        this.explorerPopup.addSeparator();
        this.largeThumbnailsMenuItem = new JCheckBoxMenuItem(this.largeThumbnailsAction);
        this.explorerPopup.add(this.largeThumbnailsMenuItem);
        this.hideExcludedMenuItem = new JCheckBoxMenuItem(this.hideExcludedAction);
        this.explorerPopup.add(this.hideExcludedMenuItem);
        this.explorerPopup.add(this.orderingSubMenu);
        this.explorerPopup.add(this.folderOrderingSubMenu);
        this.explorerPopup.add(this.newFolderAction);
        this.explorerPopup.add(this.refreshAction);
        this.explorerPopup.addSeparator();
        this.explorerPopup.add(this.propertiesAction);
        this.treeNodePopup.add(this.excludeNodeAction);
        this.treeNodePopup.add(this.includeNodeAction);
        this.treeNodePopup.add(this.renameNodeAction);
        this.treeNodePopup.addSeparator();
        this.treeNodePopup.add(this.propertiesAction);
        this.setTexts();
        MouseAdapter mouseOnExplorerAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                JAlbumExplorer.this.explorer.requestFocus();
                JAlbumExplorer.this.startingPoint = e2.getPoint();
                JAlbumExplorer.this.explorer.rubberband = new Rectangle(JAlbumExplorer.this.startingPoint);
                if (!JAlbumExplorer.isPortableControlDown(e2) && !e2.isShiftDown()) {
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                }
                JAlbumExplorer.this.handlePasteActionEnabling();
                JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.explorerPopup);
            }

            public void mouseReleased(MouseEvent e2) {
                JAlbumExplorer.this.explorer.rubberband = null;
                JAlbumExplorer.this.explorer.repaint();
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                for (int i2 = 0; i2 < comps.length; ++i2) {
                    JAlbumObject jao = (JAlbumObject)comps[i2];
                    jao.resetRubberbanded();
                }
                JAlbumExplorer.this.handlePasteActionEnabling();
                JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.explorerPopup);
            }
        };
        this.explorer.addMouseListener(mouseOnExplorerAdapter);
        MouseMotionAdapter mouseMotionOnExplorerAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e2) {
                JAlbumExplorer.points2rect(JAlbumExplorer.this.startingPoint, e2.getPoint(), JAlbumExplorer.this.explorer.rubberband);
                JAlbumExplorer.this.explorer.scrollRectToVisible(new Rectangle(e2.getPoint()));
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                Rectangle cr2 = new Rectangle();
                for (int i2 = 0; i2 < comps.length; ++i2) {
                    JAlbumObject jao = (JAlbumObject)comps[i2];
                    cr2.x = jao.getX();
                    cr2.y = jao.getY();
                    cr2.width = jao.getWidth();
                    cr2.height = jao.getHeight();
                    Rectangle intersection = JAlbumExplorer.this.explorer.rubberband.intersection(cr2);
                    jao.setRubberbanded(intersection.width > cr2.width / 4 && intersection.height > cr2.height / 4);
                }
                JAlbumExplorer.this.explorer.repaint();
            }
        };
        this.explorer.addMouseMotionListener(mouseMotionOnExplorerAdapter);
        this.mouseOnComponentAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                JAlbumExplorer.this.explorer.requestFocus();
                JAlbumObject jao = (JAlbumObject)e2.getComponent();
                JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected = jao.isSelected();
                JAlbumExplorer.this.explorer.selectionModel.setFocusedObject(jao);
                if (JAlbumExplorer.isPortableControlDown(e2) && !e2.isPopupTrigger()) {
                    jao.setSelected(!jao.isSelected());
                } else if (e2.isShiftDown()) {
                    int clickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    JAlbumExplorer.this.explorer.selectionModel.selectRange(JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex, clickedIndex);
                } else {
                    if (!jao.isSelected()) {
                        JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    }
                    jao.setSelected(true);
                }
                if (!e2.isShiftDown()) {
                    JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                }
                JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.componentPopup);
            }

            public void mouseReleased(MouseEvent e2) {
                JAlbumObject jao = (JAlbumObject)e2.getComponent();
                if (!(JAlbumExplorer.this.maybeShowPopup(e2, JAlbumExplorer.this.componentPopup) || JAlbumExplorer.isPortableControlDown(e2) || e2.isShiftDown())) {
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    jao.setSelected(true);
                    Point p2 = e2.getPoint();
                    if (jao.labelPanel.getBounds().contains(p2) && JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected && e2.getClickCount() == 1) {
                        jao.setEditing(true);
                    }
                }
            }

            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    JAlbumExplorer.this.open((JAlbumObject)e2.getComponent());
                }
            }
        };
        this.mouseOnTreeAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                TreePath path = JAlbumExplorer.this.tree.getPathForLocation(e2.getX(), e2.getY());
                if (e2.getButton() != 1) {
                    JAlbumExplorer.this.tree.getSelectionModel().setSelectionPath(path);
                }
                if (e2.isPopupTrigger() && JAlbumExplorer.this.tree.getPathForLocation(e2.getX(), e2.getY()) != null) {
                    JAlbumExplorer.this.treeNodePopup.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }

            public void mouseReleased(MouseEvent e2) {
                TreePath tp = JAlbumExplorer.this.tree.getClosestPathForLocation(e2.getX(), e2.getY());
                boolean rootSelected = tp.getPathCount() == 1;
                JAlbumExplorer.this.includeNodeAction.setEnabled(!rootSelected);
                JAlbumExplorer.this.excludeNodeAction.setEnabled(!rootSelected);
                JAlbumExplorer.this.deleteNodeAction.setEnabled(!rootSelected);
                if (e2.isPopupTrigger() && JAlbumExplorer.this.tree.getPathForLocation(e2.getX(), e2.getY()) != null) {
                    JAlbumExplorer.this.treeNodePopup.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }
        };
        DefaultTreeCellRenderer folderRenderer = new DefaultTreeCellRenderer(){
            private ImageIcon albumIcon = new ImageIcon((class$se$datadosen$jalbum$RemoteFSTreeCellRenderer == null ? (class$se$datadosen$jalbum$RemoteFSTreeCellRenderer = JAlbumExplorer.class$("se.datadosen.jalbum.RemoteFSTreeCellRenderer")) : class$se$datadosen$jalbum$RemoteFSTreeCellRenderer).getResource("images/publish/book_blue.png"));

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component renderer = super.getTreeCellRendererComponent(tree, value, selected, expanded, false, row, hasFocus);
                if (value instanceof FolderTreeNode) {
                    FolderTreeNode node = (FolderTreeNode)value;
                    AlbumObject ao = node.getAlbumObject();
                    if (ao.getName().length() == 0) {
                        return new JLabel();
                    }
                    if (node.isRoot()) {
                        this.setIcon(this.albumIcon);
                    }
                    do {
                        if (ao.isIncluded()) continue;
                        renderer.setForeground(SystemColor.textInactiveText);
                    } while ((ao = ao.getParent()) != null);
                }
                return renderer;
            }
        };
        this.tree.setCellRenderer(folderRenderer);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e2) {
                FolderTreeNode node = (FolderTreeNode)e2.getPath().getLastPathComponent();
                AlbumObject ao = node.getAlbumObject();
                if (ao != JAlbumExplorer.this.currentFolder) {
                    JAlbumExplorer.this.viewFolder(ao);
                }
            }
        });
        this.tree.addMouseListener(this.mouseOnTreeAdapter);
        RenderThread rt = new RenderThread();
        rt.start();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.imageCache = new ImageCache(10, new Dimension(screenSize.width / 2, screenSize.width / 2));
        this.explorer.selectionModel.addSelectionListener(new SelectionListener(){

            public void selectionChange(ExplorerSelectionModel model) {
                boolean selected = model.getSelectionCount() > 0;
                JAlbumExplorer.this.rotateLeftAction.setEnabled(selected);
                JAlbumExplorer.this.rotateRightAction.setEnabled(selected);
                JAlbumExplorer.this.commentAction.setEnabled(selected);
                JAlbumExplorer.this.deleteAction.setEnabled(selected);
            }
        });
    }

    void updateOrderingMenus() {
        if (this.currentFolder != null) {
            String ordering = this.currentFolder.getOrdering();
            if (ordering.equals("name")) {
                this.orderByNameAction.setSelected(true);
            } else if (ordering.equals("date")) {
                this.orderByDateAction.setSelected(true);
            } else if (ordering.equals("cameraDate")) {
                this.orderByCameraDateAction.setSelected(true);
            } else if (ordering.equals("custom")) {
                this.customOrderingAction.setSelected(true);
            } else if (ordering.equals("jalbum")) {
                this.useJAlbumOrderingAction.setSelected(true);
            }
            this.reverseOrderingAction.setSelected(this.currentFolder.isReverseOrdering());
            this.foldersFirstAction.setSelected(this.currentFolder.isFoldersFirst());
            String folderOrdering = this.currentFolder.getFolderOrdering();
            if (folderOrdering.equals("name")) {
                this.orderFoldersByNameAction.setSelected(true);
            } else if (folderOrdering.equals("date")) {
                this.orderFoldersByDateAction.setSelected(true);
            }
            this.reverseFolderOrderingAction.setSelected(this.currentFolder.isReverseFolderOrdering());
        }
    }

    void handleDisablingOfOrderingMenus() {
        boolean b2 = !this.customOrderingAction.isSelected() && !this.useJAlbumOrderingAction.isSelected();
        this.reverseOrderingAction.setEnabled(b2);
        this.foldersFirstAction.setEnabled(b2);
        boolean foldersFirst = this.foldersFirstAction.isSelected();
        this.orderFoldersByNameAction.setEnabled(b2 && foldersFirst);
        this.orderFoldersByDateAction.setEnabled(b2 && foldersFirst);
        this.reverseFolderOrderingAction.setEnabled(b2 && foldersFirst);
    }

    private void setOrdering(String ordering) {
        try {
            this.currentFolder.setOrdering(ordering);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
        this.currentFolder.invalidate();
        this.viewFolder(this.currentFolder);
        this.refreshCurrentNode();
    }

    private void setFolderOrdering(String folderOrdering) {
        try {
            this.currentFolder.setFolderOrdering(folderOrdering);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
        this.currentFolder.invalidate();
        this.viewFolder(this.currentFolder);
        this.refreshCurrentNode();
    }

    public void populateOrderingSubMenu(JMenu menu) {
        ButtonGroup bg2 = new ButtonGroup();
        JRadioButtonMenuItem item = this.orderByNameAction.createJRadioButtonMenuItem();
        bg2.add(item);
        menu.add(item);
        item = this.orderByDateAction.createJRadioButtonMenuItem();
        bg2.add(item);
        menu.add(item);
        item = this.orderByCameraDateAction.createJRadioButtonMenuItem();
        bg2.add(item);
        menu.add(item);
        item = this.customOrderingAction.createJRadioButtonMenuItem();
        bg2.add(item);
        menu.add(item);
        item = this.useJAlbumOrderingAction.createJRadioButtonMenuItem();
        bg2.add(item);
        menu.add(item);
        menu.add(this.reverseOrderingAction.createJCheckBoxMenuItem());
        menu.add(this.shuffleAction);
    }

    public void populateFolderOrderingSubMenu(JMenu menu) {
        menu.add(this.foldersFirstAction.createJCheckBoxMenuItem());
        ButtonGroup bg2 = new ButtonGroup();
        JRadioButtonMenuItem item = this.orderFoldersByNameAction.createJRadioButtonMenuItem();
        bg2.add(item);
        menu.add(item);
        item = this.orderFoldersByDateAction.createJRadioButtonMenuItem();
        bg2.add(item);
        menu.add(item);
        menu.add(this.reverseFolderOrderingAction.createJCheckBoxMenuItem());
        this.handleDisablingOfOrderingMenus();
    }

    static boolean isPortableControlDown(MouseEvent e2) {
        boolean ret = (e2.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
        return ret;
    }

    public void setTexts() {
        this.pasteAction.putValue("Name", Msg.getString("edit.paste"));
        this.useAsFolderThumbnailAction.putValue("Name", Msg.getString("edit.folderThumbnail"));
        this.useAsFolderThumbnailAction.putValue("ShortDescription", Msg.getString("edit.folderThumbnailToolTip"));
        this.renameAction.putValue("Name", Msg.getString("edit.renameFile"));
        this.newFolderAction.putValue("Name", Msg.getString("edit.newFolder"));
        this.refreshAction.putValue("Name", Msg.getString("edit.update"));
        this.openAction.putValue("Name", Msg.getString("edit.open"));
        this.propertiesAction.putValue("Name", Msg.getString("edit.properties"));
        this.commentAction.putValue("Name", Msg.getString("edit.commentLabel"));
        this.hideExcludedAction.putValue("Name", Msg.getString("edit.hideExcluded"));
        this.largeThumbnailsAction.putValue("Name", Msg.getString("edit.largeThumbnails"));
        this.deleteAction.putValue("Name", Msg.getString("edit.delete"));
        this.includeSelectedAction.putValue("Name", Msg.getString("edit.include"));
        this.excludeSelectedAction.putValue("Name", Msg.getString("edit.exclude"));
        this.rotateLeftAction.putValue("Name", Msg.getString("edit.rotateLeftToolTip"));
        this.rotateRightAction.putValue("Name", Msg.getString("edit.rotateRightToolTip"));
        this.selectAllAction.putValue("Name", Msg.getString("edit.selectAll"));
        this.invertSelectionAction.putValue("Name", Msg.getString("edit.invertSelection"));
        this.slideShowAction.putValue("Name", Msg.getString("edit.runSlideshow"));
        this.orderByNameAction.putValue("Name", Msg.getString("ui.nameOrdering"));
        this.orderByDateAction.putValue("Name", Msg.getString("ui.dateOrdering"));
        this.orderByCameraDateAction.putValue("Name", Msg.getString("edit.cameraDateOrdering"));
        this.customOrderingAction.putValue("Name", Msg.getString("edit.customOrdering"));
        this.useJAlbumOrderingAction.putValue("Name", Msg.getString("edit.jalbumOrdering"));
        this.reverseOrderingAction.putValue("Name", Msg.getString("edit.reverseOrdering"));
        this.foldersFirstAction.putValue("Name", Msg.getString("edit.foldersFirst"));
        this.orderFoldersByNameAction.putValue("Name", Msg.getString("ui.nameOrdering"));
        this.orderFoldersByDateAction.putValue("Name", Msg.getString("ui.dateOrdering"));
        this.reverseFolderOrderingAction.putValue("Name", Msg.getString("edit.reverseOrdering"));
        this.shuffleAction.putValue("Name", Msg.getString("edit.shuffleOrdering"));
        this.includeNodeAction.putValue("Name", Msg.getString("edit.include"));
        this.excludeNodeAction.putValue("Name", Msg.getString("edit.exclude"));
        this.deleteNodeAction.putValue("Name", Msg.getString("edit.delete"));
        this.renameNodeAction.putValue("Name", Msg.getString("edit.renameFile"));
        this.orderingSubMenu.setText(Msg.getString("edit.orderBy"));
        this.folderOrderingSubMenu.setText(Msg.getString("edit.orderFoldersBy"));
    }

    private void adjustOrientation(boolean right) {
        LinkedList list = this.explorer.selectionModel.getSelectedObjects();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            JAlbumObject jao = (JAlbumObject)it.next();
            try {
                if (right) {
                    jao.ao.rotateRight();
                } else {
                    jao.ao.rotateLeft();
                }
                jao.renderIcon();
                jao.validate();
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
        this.imageCache.clear();
    }

    void open(JAlbumObject jao) {
        if (jao.ao.isFolder()) {
            this.selectNode(jao.ao);
        } else if (jao.ao.isDisplayableImage()) {
            jao.openPropertyEditor();
        } else {
            try {
                BrowserLauncher.openLocal(jao.ao.getFile());
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    void refreshCurrentNode() {
        FolderTreeNode node = (FolderTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            this.selectNode(this.currentFolder);
            node = (FolderTreeNode)this.tree.getLastSelectedPathComponent();
        }
        this.refreshFrom(node);
        TreePath selTP = new TreePath(node.getPath());
        this.tree.setSelectionPath(selTP);
    }

    void refreshFrom(FolderTreeNode node) {
        node.invalidate();
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(node);
    }

    public void syncModel() {
        LinkedList<AlbumObject> children = new LinkedList<AlbumObject>();
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            children.add(jao.ao);
        }
        try {
            if (this.currentFolder != null) {
                this.currentFolder.setChildren(children);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void selectNode(AlbumObject current) {
        FolderTreeNode rootNode = (FolderTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> allChildren = rootNode.breadthFirstEnumeration();
        while (allChildren.hasMoreElements()) {
            FolderTreeNode child = (FolderTreeNode)allChildren.nextElement();
            AlbumObject ao = child.getAlbumObject();
            if (!ao.equals(current)) continue;
            TreeSelectionModel sm = this.tree.getSelectionModel();
            TreePath path = new TreePath(child.getPath());
            sm.setSelectionPath(path);
            this.tree.expandPath(path);
            break;
        }
    }

    public void startSlideshow() {
        Iterator it;
        LinkedList<AlbumObject> slides = new LinkedList<AlbumObject>();
        LinkedList list = this.explorer.selectionModel.getSelectedObjects();
        AlbumObject start = null;
        if (list.size() <= 1) {
            if (list.size() == 1) {
                start = ((JAlbumObject)list.getFirst()).ao;
            }
            it = this.currentFolder.getChildren().iterator();
            while (it.hasNext()) {
                AlbumObject ao = (AlbumObject)it.next();
                if (!ao.isIncluded() || ao.isFolder()) continue;
                slides.addLast(ao);
            }
        } else {
            it = list.iterator();
            while (it.hasNext()) {
                AlbumObject ao = ((JAlbumObject)it.next()).ao;
                if (!ao.isIncluded() || ao.isFolder()) continue;
                slides.addLast(ao);
            }
        }
        SlideShow slideShow = SlideShowFactory.createSlideShow(slides, start);
        slideShow.start();
    }

    public AlbumObject getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(AlbumObject root) {
        this.rootFolder = root;
        this.explorer.removeAll();
        FolderTreeNode rootNode = new FolderTreeNode(root);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setEditable(true);
        treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e2) {
                FolderTreeNode node = (FolderTreeNode)JAlbumExplorer.this.tree.getLastSelectedPathComponent();
                String newName = node.getUserObject().toString();
                if (node.isRoot()) {
                    try {
                        JAlbumExplorer.this.parent.renameImageDirectory(newName);
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JAlbumExplorer.this.parent, ex);
                    }
                } else {
                    AlbumObject ao = node.getAlbumObject();
                    ao.setName(newName);
                    JAlbumExplorer.this.refreshCurrentNode();
                    JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                }
            }

            public void treeNodesInserted(TreeModelEvent e2) {
            }

            public void treeNodesRemoved(TreeModelEvent e2) {
            }

            public void treeStructureChanged(TreeModelEvent e2) {
            }
        });
        if (this.currentFolder == null) {
            TreeModel tm = this.tree.getModel();
            this.tree.setSelectionPath(new TreePath(tm.getRoot()));
        }
    }

    public void viewFolder(AlbumObject folder) {
        if (folder == null) {
            return;
        }
        this.explorer.removeAll();
        List content = folder.getChildren();
        if (content == null) {
            return;
        }
        boolean hideExcluded = this.hideExcludedMenuItem.isSelected();
        Iterator it = content.iterator();
        while (it.hasNext()) {
            AlbumObject ao = (AlbumObject)it.next();
            this.addJAO(hideExcluded, ao);
        }
        this.validate();
        this.repaint();
        this.currentFolder = folder;
        this.updateOrderingMenus();
        this.handleDisablingOfOrderingMenus();
    }

    private JAlbumObject addJAO(AlbumObject ao) {
        boolean hideExcluded = this.hideExcludedMenuItem.isSelected();
        return this.addJAO(hideExcluded, ao);
    }

    private JAlbumObject addJAO(boolean hideExcluded, AlbumObject ao) {
        JAlbumObject jao = new JAlbumObject(ao, this.explorer);
        if (hideExcluded && !jao.ao.isIncluded()) {
            jao.setVisible(false);
        }
        this.prepareJAO(jao);
        this.explorer.add(jao);
        return jao;
    }

    void prepareJAO(JAlbumObject jao) {
        DragSource ds2 = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = ds2.createDefaultDragGestureRecognizer(jao, 3, this.explorer);
        jao.addMouseListener(this.mouseOnComponentAdapter);
        jao.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("label")) {
                    JAlbumExplorer.this.refreshCurrentNode();
                }
            }
        });
    }

    private static void points2rect(Point p1, Point p2, Rectangle r2) {
        r2.x = Math.min(p1.x, p2.x);
        r2.y = Math.min(p1.y, p2.y);
        r2.width = p2.x - p1.x;
        if (r2.width < 0) {
            r2.width = -r2.width;
        }
        r2.height = p2.y - p1.y;
        if (r2.height < 0) {
            r2.height = -r2.height;
        }
    }

    private void handlePasteActionEnabling() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t2 = clipboard.getContents(this.explorer);
        this.pasteAction.setEnabled(t2.isDataFlavorSupported(DataFlavor.javaFileListFlavor));
    }

    private boolean maybeShowPopup(MouseEvent e2, JPopupMenu popup) {
        if (popup == this.componentPopup) {
            JAlbumObject jao = (JAlbumObject)e2.getComponent();
            this.rotateLeftAction.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
            this.rotateRightAction.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
            this.useAsFolderThumbnailMenuItem.setSelected(false);
            File rep = this.currentFolder.getRepresentingIconFile();
            if (rep != null && rep.equals(jao.ao.getFile())) {
                this.useAsFolderThumbnailMenuItem.setSelected(true);
            }
        }
        if (e2.isPopupTrigger()) {
            popup.show(e2.getComponent(), e2.getX(), e2.getY());
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RenderThread
    extends Thread {
        private int nErrors = 0;

        public RenderThread() {
            super("JAlbumExplorer.RenderThread");
            this.setDaemon(true);
        }

        public void run() {
            block6: while (true) {
                try {
                    block7: while (true) {
                        Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                        Rectangle view = JAlbumExplorer.this.explorerScrollPane.getViewport().getViewRect();
                        for (int i2 = 0; i2 < comps.length; ++i2) {
                            JAlbumObject jao = (JAlbumObject)comps[i2];
                            if (jao.isRenderingDone() || !view.intersects(jao.getBounds())) continue;
                            jao.renderIcon();
                            continue block7;
                        }
                        comps = null;
                        try {
                            RenderThread.sleep(200L);
                            continue block6;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t2) {
                    if (++this.nErrors == 1) {
                        Debug.showErrorDialog(JAlbumExplorer.this, t2);
                    }
                    System.err.println("Render thread reported error: " + t2);
                    try {
                        RenderThread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }

    class FolderTreeNode
    extends DefaultMutableTreeNode {
        boolean initialized;
        private AlbumObject ao;

        public FolderTreeNode(AlbumObject ao) {
            super(ao.getName());
            this.ao = ao;
        }

        public boolean isLeaf() {
            return false;
        }

        public AlbumObject getAlbumObject() {
            return this.ao;
        }

        public int getChildCount() {
            if (!this.initialized) {
                this.initialized = true;
                this.initialize();
            }
            return super.getChildCount();
        }

        public void invalidate() {
            this.removeAllChildren();
            this.initialized = false;
        }

        void initialize() {
            List children = this.ao.getChildren();
            if (children == null) {
                return;
            }
            Iterator it = children.iterator();
            while (it.hasNext()) {
                AlbumObject ao = (AlbumObject)it.next();
                if (!ao.isFolder()) continue;
                this.add(new FolderTreeNode(ao));
            }
            this.initialized = true;
        }
    }
}

