/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedList;
import java.util.Vector;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.event.SelectionListener;

public class ExplorerSelectionModel {
    static final int NORTH = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int EAST = 4;
    private JExplorerPanel explorer;
    int lastClickedIndex = 0;
    boolean wasAlreadySelected = false;
    private JAlbumObject focusedObject;
    private int selectionCount = 0;
    private transient Vector selectionListeners;

    public ExplorerSelectionModel(JExplorerPanel explorer) {
        this.explorer = explorer;
    }

    int indexOf(Component comp) {
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            if (comps[i2] != comp) continue;
            return i2;
        }
        return -1;
    }

    void deselectAll() {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            ((JAlbumObject)comps[i2]).setSelected(false);
        }
        this.selectionListeners = tmpListeners;
        this.selectionCount = 0;
        this.fireSelectionChange();
    }

    int getSelectionCount() {
        return this.selectionCount;
    }

    void selectAll() {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            ((JAlbumObject)comps[i2]).setSelected(true);
        }
        this.selectionListeners = tmpListeners;
        this.selectionCount = comps.length;
        this.fireSelectionChange();
    }

    void invertSelection() {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            boolean sel = !jao.isSelected();
            jao.setSelected(sel);
        }
        this.selectionListeners = tmpListeners;
        this.fireSelectionChange();
    }

    void selectRange(int startIndex, int endIndex) {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        if (startIndex > endIndex) {
            int tmp = startIndex;
            startIndex = endIndex;
            endIndex = tmp;
        }
        for (int i2 = startIndex; i2 <= endIndex; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            jao.setSelected(true);
        }
        this.selectionCount = endIndex - startIndex + 1;
        this.selectionListeners = tmpListeners;
        this.fireSelectionChange();
    }

    void objectSelected(JAlbumObject jao, boolean selected) {
        this.selectionCount = selected ? ++this.selectionCount : --this.selectionCount;
        this.fireSelectionChange();
    }

    LinkedList getSelectedObjects() {
        LinkedList<JAlbumObject> list = new LinkedList<JAlbumObject>();
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (!jao.isSelected()) continue;
            list.add(jao);
        }
        return list;
    }

    JAlbumObject getSingleSelected() {
        JAlbumObject selected = null;
        Component[] comps = this.explorer.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            JAlbumObject jao = (JAlbumObject)comps[i2];
            if (!jao.isSelected()) continue;
            if (selected != null) {
                return null;
            }
            selected = jao;
        }
        return selected;
    }

    JAlbumObject getFocusedObject() {
        return this.focusedObject;
    }

    void setFocusedObject(JAlbumObject jao) {
        this.focusedObject = jao;
    }

    JAlbumObject getNeighbourObject(JAlbumObject jao, int direction) {
        Point p2 = jao.getLocation();
        Dimension dim = this.explorer.objectSize;
        p2.x += dim.width / 2;
        p2.y += dim.height / 2;
        switch (direction) {
            case 1: {
                p2.y -= dim.height + this.explorer.explorerThumbsLayout.getVgap();
                break;
            }
            case 2: {
                p2.y += dim.height + this.explorer.explorerThumbsLayout.getVgap();
                break;
            }
            case 3: {
                p2.x -= dim.width + this.explorer.explorerThumbsLayout.getHgap();
                break;
            }
            case 4: {
                p2.x += dim.width + this.explorer.explorerThumbsLayout.getHgap();
            }
        }
        return (JAlbumObject)this.explorer.getNearestComponent(p2);
    }

    public synchronized void removeSelectionListener(SelectionListener l2) {
        if (this.selectionListeners != null && this.selectionListeners.contains(l2)) {
            Vector v2 = (Vector)this.selectionListeners.clone();
            v2.removeElement(l2);
            this.selectionListeners = v2;
        }
    }

    public synchronized void addSelectionListener(SelectionListener l2) {
        Vector v2;
        Vector vector = v2 = this.selectionListeners == null ? new Vector(2) : (Vector)this.selectionListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.selectionListeners = v2;
        }
    }

    protected void fireSelectionChange() {
        if (this.selectionListeners != null) {
            Vector listeners = this.selectionListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((SelectionListener)listeners.elementAt(i2)).selectionChange(this);
            }
        }
    }
}

