/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.dnd;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import se.datadosen.dnd.FileDropEvent;
import se.datadosen.dnd.FileDropListener;

public class JFileDropPanel
extends JPanel
implements DropTargetListener {
    private Component component;
    private transient Vector fileDropListeners;

    public JFileDropPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JFileDropPanel(LayoutManager layout) {
        super(layout);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void addComponent(Component newComponent) {
        Component oldComponent = this.component;
        this.component = newComponent;
        this.component.setDropTarget(new DropTarget(this.component, this));
        this.firePropertyChange("component", oldComponent, newComponent);
    }

    public Component getComponent() {
        return this.component;
    }

    public void dragEnter(DropTargetDragEvent e2) {
        e2.acceptDrag(1);
    }

    public void dragOver(DropTargetDragEvent e2) {
        e2.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent e2) {
    }

    public void drop(DropTargetDropEvent e2) {
        if ((e2.getSourceActions() & 1) == 0) {
            e2.rejectDrop();
            return;
        }
        e2.acceptDrop(1);
        try {
            List files = (List)e2.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            e2.dropComplete(true);
            this.fireFilesDropped(new FileDropEvent(this, files));
            return;
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (UnsupportedFlavorException ex) {
            System.err.println(ex);
        }
        e2.dropComplete(false);
    }

    public void dragScroll(DropTargetDragEvent e2) {
    }

    public void dropActionChanged(DropTargetDragEvent e2) {
    }

    public synchronized void removeFileDropListener(FileDropListener l2) {
        if (this.fileDropListeners != null && this.fileDropListeners.contains(l2)) {
            Vector v2 = (Vector)this.fileDropListeners.clone();
            v2.removeElement(l2);
            this.fileDropListeners = v2;
        }
    }

    public synchronized void addFileDropListener(FileDropListener l2) {
        Vector v2;
        if (this.component == null) {
            this.addComponent(this);
        }
        Vector vector = v2 = this.fileDropListeners == null ? new Vector(2) : (Vector)this.fileDropListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.fileDropListeners = v2;
        }
    }

    protected void fireFilesDropped(FileDropEvent e2) {
        if (this.fileDropListeners != null) {
            Vector listeners = this.fileDropListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((FileDropListener)listeners.elementAt(i2)).filesDropped(e2);
            }
        }
    }
}

