/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.buttonbar;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.datadosen.component.buttonbar.JAlbumButtonBarUI;
import se.datadosen.component.buttonbar.JButtonBar;

public class JButtonBarPane
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private JButtonBar buttonBar;
    private ButtonGroup buttonGroup;
    private JPanel tabHolder;
    CardLayout holderLayout;
    private ArrayList listeners = new ArrayList();
    private Component selectedComponent = null;

    public JButtonBarPane() {
        this(0);
    }

    public JButtonBarPane(int orientation) {
        this.buttonGroup = new ButtonGroup();
        this.holderLayout = new CardLayout();
        this.tabHolder = new JPanel(this.holderLayout);
        this.buttonBar = new JButtonBar(orientation);
        this.buttonBar.setUI(new JAlbumButtonBarUI());
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonBar, orientation == 0 ? "North" : "West");
        this.add((Component)this.tabHolder, "Center");
        this.registerArrowAccelerators();
    }

    private void registerArrowAccelerators() {
        this.buttonBar.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "nextTab");
        this.buttonBar.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "previousTab");
        this.buttonBar.getActionMap().put("nextTab", new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                int nextIndex = JButtonBarPane.this.indexOfTab(JButtonBarPane.this.getSelectedComponent()) + 1;
                if (nextIndex < JButtonBarPane.this.buttonBar.getComponentCount()) {
                    Component nextComponent = JButtonBarPane.this.buttonBar.getComponent(nextIndex);
                    JButtonBarPane.this.show(nextComponent);
                }
            }
        });
        this.buttonBar.getActionMap().put("previousTab", new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                int previousIndex = JButtonBarPane.this.indexOfTab(JButtonBarPane.this.getSelectedComponent()) - 1;
                if (previousIndex >= 0) {
                    Component previousComponent = JButtonBarPane.this.buttonBar.getComponent(previousIndex);
                    JButtonBarPane.this.show(previousComponent);
                }
            }
        });
    }

    public void addTab(String title, Icon icon, Component tab) {
        this.createTab(title, icon, tab);
    }

    private void createTab(String title, Icon icon, final Component component) {
        AbstractAction buttonPressed = new AbstractAction(title, icon){

            public void actionPerformed(ActionEvent e2) {
                JButtonBarPane.this.show(component);
            }
        };
        JToggleButton button = new JToggleButton(buttonPressed);
        button.setFocusable(false);
        String key = "tab nr " + this.buttonBar.getComponentCount();
        component.setName(key);
        button.setName(key);
        this.tabHolder.add(component, key);
        this.buttonGroup.add(button);
        this.buttonBar.add(button);
        if (this.buttonGroup.getSelection() == null) {
            button.setSelected(true);
            this.show(component);
        }
        this.buttonBar.repaint();
    }

    private void show(Component tab) {
        String key = tab.getName();
        this.holderLayout.show(this.tabHolder, key);
        Component[] buttons = this.buttonBar.getComponents();
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            JToggleButton button = (JToggleButton)buttons[i2];
            if (!key.equals(button.getName())) continue;
            button.setSelected(true);
            break;
        }
        this.selectedComponent = tab;
        this.fireChangeEvent();
    }

    public int indexOfTab(Component tab) {
        if (tab == null || tab.getName() == null) {
            return -1;
        }
        String key = tab.getName();
        Component[] buttons = this.buttonBar.getComponents();
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            JToggleButton button = (JToggleButton)buttons[i2];
            if (!key.equals(button.getName())) continue;
            return i2;
        }
        return -1;
    }

    public Component getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setTitleAt(int index, String title) {
        JToggleButton button = (JToggleButton)this.buttonBar.getComponent(index);
        button.setText(title);
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private synchronized void fireChangeEvent() {
        ChangeEvent ce2 = new ChangeEvent(this);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ChangeListener l2 = (ChangeListener)iter.next();
            l2.stateChanged(ce2);
        }
    }

    public void remove(Component c2) {
        if (c2 == null || c2.getName() == null) {
            return;
        }
        this.tabHolder.remove(c2);
        if (c2.equals(this.selectedComponent)) {
            this.holderLayout.first(this.tabHolder);
            this.selectedComponent = this.tabHolder.getComponent(0);
        }
        Component[] buttons = this.buttonBar.getComponents();
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            if (!c2.getName().equals(buttons[i2].getName())) continue;
            this.buttonBar.remove(buttons[i2]);
            break;
        }
        this.buttonBar.repaint();
    }
}

