/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JLabel;

public class JLinkLabel
extends JLabel {
    private Color defaultColor = this.getForeground();
    private MouseListener mouseListener;
    private transient Vector actionListeners;
    private String url;
    private Exception exception;

    public JLinkLabel() {
        this("");
    }

    public JLinkLabel(String text) {
        this.setText(text);
        this.mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e2) {
                JLinkLabel.this.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent e2) {
                JLinkLabel.this.setCursor(new Cursor(0));
            }

            public void mouseClicked(MouseEvent e2) {
                JLinkLabel.this.doClick();
            }
        };
    }

    public void doClick() {
        if (this.actionListeners != null) {
            this.fireActionPerformed(new ActionEvent(this, 0, null));
            return;
        }
        try {
            BrowserLauncher.openURL(this.url);
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    public JLinkLabel(String url, String text) {
        this(text);
        this.setURL(url);
    }

    public JLinkLabel(String url, String text, String tooltip) {
        this(text);
        this.setURL(url);
        this.setToolTipText(tooltip);
    }

    public void paintComponent(Graphics g2) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        g2.drawString(this.getText(), 0, this.getHeight() - fm.getDescent());
        if (this.url == null) {
            return;
        }
        int x0 = 0;
        int x1 = fm.stringWidth(this.getText()) - 1;
        int y2 = 1 + this.getHeight() - fm.getDescent();
        g2.drawLine(x0, y2, x1, y2);
    }

    public void setURL(String newURL) {
        this.url = newURL;
        if (this.url != null) {
            this.setForeground(Color.blue);
            this.removeMouseListener(this.mouseListener);
            this.addMouseListener(this.mouseListener);
        } else {
            this.setForeground(this.defaultColor);
            this.removeMouseListener(this.mouseListener);
        }
    }

    public String getURL() {
        return this.url;
    }

    public Exception getIOException() {
        return this.exception;
    }

    public void clearIOException() {
        this.exception = null;
    }

    public synchronized void removeActionListener(ActionListener l2) {
        if (this.actionListeners != null && this.actionListeners.contains(l2)) {
            Vector v2 = (Vector)this.actionListeners.clone();
            v2.removeElement(l2);
            this.actionListeners = v2;
        }
    }

    public synchronized void addActionListener(ActionListener l2) {
        Vector v2;
        Vector vector = v2 = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.actionListeners = v2;
        }
    }

    protected void fireActionPerformed(ActionEvent e2) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ActionListener)listeners.elementAt(i2)).actionPerformed(e2);
            }
        }
    }
}

