/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.datadosen.util.Colors;

public class JColorSelector
extends JPanel {
    protected String title;
    protected Color color = Color.black;
    Vector listeners;
    private final int Y_OFFSET = 1;

    public JColorSelector() {
        this("");
    }

    public JColorSelector(String title) {
        this.title = title;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHTMLColor() {
        return "#" + Integer.toHexString(this.color.getRGB()).substring(2);
    }

    public String toString() {
        return this.getHTMLColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String htmlColor) {
        this.setColor(Colors.getHTMLColor(htmlColor));
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
        this.fireActionOccured(new ActionEvent(this, 0, this.getHTMLColor()));
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(20, 16));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                if (!JColorSelector.this.isEnabled()) {
                    return;
                }
                Color newColor = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(JColorSelector.this), JColorSelector.this.title, JColorSelector.this.color);
                if (newColor != null) {
                    JColorSelector.this.setColor(newColor);
                }
            }
        });
        this.setColor(this.color);
    }

    public synchronized void removeActionListener(ActionListener l2) {
        if (this.listeners != null && this.listeners.contains(l2)) {
            Vector v2 = (Vector)this.listeners.clone();
            v2.removeElement(l2);
            this.listeners = v2;
        }
    }

    public synchronized void addActionListener(ActionListener l2) {
        Vector v2;
        Vector vector = v2 = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.listeners = v2;
        }
    }

    protected void fireActionOccured(ActionEvent e2) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ActionListener)this.listeners.elementAt(i2)).actionPerformed(e2);
            }
        }
    }

    protected void paintComponent(Graphics g2) {
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        g2.setColor(this.color.brighter());
        g2.fillRoundRect(0, 1, w2 - 1, h2 - 1 - 1, 5, 5);
        g2.setColor(this.color);
        g2.fillRoundRect(1, 2, w2 - 2, h2 - 1 - 2, 0, 0);
        g2.setColor(this.color.darker());
        g2.drawRoundRect(0, 1, w2 - 1, h2 - 1 - 1, 5, 5);
    }
}

