/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JBackgroundPanel
extends JPanel {
    Image bg;
    Border imageBorder;

    public void setBackgroundImage(Image bg2) {
        this.bg = bg2;
        if (bg2 != null) {
            this.setOpaque(false);
        }
    }

    public Dimension getPreferredSize() {
        if (this.bg == null) {
            return super.getPreferredSize();
        }
        Dimension sp = super.getPreferredSize();
        int width = this.bg.getWidth(null);
        int height = this.bg.getHeight(null);
        if (this.imageBorder != null) {
            Insets insets = this.imageBorder.getBorderInsets(this);
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        return new Dimension(Math.max(width, sp.width), Math.max(height, sp.height));
    }

    public Dimension getDisplayableImageSize() {
        Dimension size = (Dimension)this.getSize().clone();
        return size;
    }

    public void setImageBorder(Border border) {
        this.imageBorder = border;
    }

    protected void paintComponent(Graphics g2) {
        if (this.bg != null) {
            int iw = this.bg.getWidth(null);
            int ih = this.bg.getHeight(null);
            int cw2 = this.getWidth();
            int ch2 = this.getHeight();
            if (this.imageBorder != null) {
                double scale;
                Insets insets = this.imageBorder.getBorderInsets(this);
                int tw = 4 + iw + insets.left + insets.right;
                int th = 4 + ih + insets.top + insets.bottom;
                if (tw > cw2) {
                    scale = (double)cw2 / (double)tw;
                    iw = (int)Math.floor(scale * (double)iw);
                    ih = (int)Math.floor(scale * (double)ih);
                }
                if (th > ch2) {
                    scale = (double)ch2 / (double)th;
                    iw = (int)Math.floor(scale * (double)iw);
                    ih = (int)Math.floor(scale * (double)ih);
                }
            }
            int ix = (cw2 - iw) / 2;
            int iy = (ch2 - ih) / 2;
            g2.drawImage(this.bg, ix, iy, iw, ih, null);
            if (this.imageBorder != null) {
                Insets insets = this.imageBorder.getBorderInsets(this);
                int bx2 = ix - insets.left;
                int by2 = iy - insets.top;
                int bw2 = iw + insets.left + insets.right;
                int bh2 = ih + insets.top + insets.bottom;
                this.imageBorder.paintBorder(this, g2, bx2, by2, bw2, bh2);
            }
        }
        super.paintComponent(g2);
    }
}

