/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import se.datadosen.jalbum.JAlbum;

public class CurvedLineBorder
implements Border {
    private int roundness;
    private Color lineColor;

    public CurvedLineBorder() {
        if (JAlbum.isMac()) {
            this.roundness = 11;
            this.lineColor = new Color(0, 0, 0, 25);
        } else {
            this.roundness = 8;
            this.lineColor = new Color(0, 0, 0, 60);
        }
    }

    public CurvedLineBorder(Color lineColor) {
        this();
        this.lineColor = lineColor;
    }

    public void paintBorder(Component c2, Graphics gg, int x2, int y2, int w2, int h2) {
        Graphics2D g2 = (Graphics2D)gg;
        if (JAlbum.isMac()) {
            g2.setColor(new Color(0, 0, 0, 7));
            g2.fillRoundRect(x2, y2, w2 - 1, h2 - 1, this.roundness, this.roundness);
            g2.setColor(new Color(0, 0, 0, 9));
            g2.drawRoundRect(x2, y2 + 1, w2 - 1, h2 - 2, this.roundness - 1, this.roundness - 1);
            g2.drawRoundRect(x2, y2 + 1, w2 - 1, h2 - 2, this.roundness - 1, this.roundness - 1);
            g2.drawRoundRect(x2, y2 + 2, w2 - 1, h2 - 3, this.roundness - 1, this.roundness - 1);
            g2.drawRoundRect(x2 + 1, y2 + 1, w2 - 3, h2 - 3, this.roundness - 1, this.roundness - 1);
            g2.setColor(new Color(0, 0, 0, 25));
            g2.drawLine(x2 + 6, y2, w2 - 8, y2);
            g2.drawLine(x2 + 4, y2, w2 - 4, y2);
        }
        g2.setColor(this.lineColor);
        g2.drawRoundRect(x2, y2, w2 - 1, h2 - 1, this.roundness, this.roundness);
    }

    public Insets getBorderInsets(Component c2) {
        return JAlbum.isMac() ? new Insets(1, 1, 1, 1) : new Insets(1, 1, 1, 1);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

