/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.util.HashMap;
import java.util.Map;
import photoorganizer.formats.Entry;

public class IFD
extends Entry {
    protected Map entries;
    protected IFD[] ifds;
    protected int tag;

    public IFD(int tag) {
        this(tag, 7);
    }

    public IFD(int tag, int type) {
        super(type);
        this.tag = tag;
        this.entries = new HashMap();
    }

    public void addEntry(int tag, Entry entry) {
        this.entries.put(new Integer(tag), entry);
    }

    public void addIFD(IFD ifd) {
        IFD[] temp = this.ifds == null ? new IFD[1] : new IFD[this.ifds.length + 1];
        temp[this.ifds == null ? 0 : this.ifds.length] = ifd;
        if (this.ifds != null) {
            System.arraycopy(this.ifds, 0, temp, 0, this.ifds.length);
        }
        this.ifds = temp;
    }

    public Entry getEntry(Integer tag, int subTag) {
        Entry result = (Entry)this.entries.get(tag);
        if (result != null) {
            return result;
        }
        if (subTag > 0) {
            for (int i2 = 0; i2 < this.ifds.length; ++i2) {
                if (this.ifds[i2].getTag() != subTag) continue;
                return this.ifds[i2].getEntry(tag, -1);
            }
        } else {
            for (int i3 = 0; this.ifds != null && i3 < this.ifds.length && (result = this.ifds[i3].getEntry(tag, -1)) == null; ++i3) {
            }
        }
        return result;
    }

    public IFD getIFD(int tag) {
        for (int i2 = 0; i2 < this.ifds.length; ++i2) {
            if (this.ifds[i2].getTag() != tag) continue;
            return this.ifds[i2];
        }
        return null;
    }

    public int getTag() {
        return this.tag;
    }

    public Entry setEntry(Integer tag, int subTag, Entry value) {
        Entry result = null;
        if (subTag > 0) {
            for (int i2 = 0; i2 < this.ifds.length; ++i2) {
                if (this.ifds[i2].getTag() != subTag) continue;
                return this.ifds[i2].setEntry(tag, -1, value);
            }
        } else if (subTag == 0) {
            result = this.entries.put(tag, value);
        } else {
            for (int i3 = 0; i3 < this.ifds.length; ++i3) {
                result = this.ifds[i3].getEntry(tag, -1);
                if (result == null) continue;
                this.ifds[i3].setEntry(tag, 0, value);
                break;
            }
        }
        return result;
    }

    public Map getEntries() {
        return this.entries;
    }

    public IFD[] getIFDs() {
        return this.ifds;
    }
}

