/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.Rational;

public class FileNameFormat
extends Format {
    public static final String CMD_YES = "Yes";
    public static final String CMD_NO = "No";
    public static final String formatHelp = "<html>\n<h2>Format escape sequences for pictures and music</h2>\n<pre>\n %D - date/time stamp in current locale,\n %d - date stamp,\n %t - time stamp,\n %s - shutter speed/bitrate,\n %a - aperture value/sample rate,\n %f - flash/protected (yes, no),\n %q - quality/mode\n %c - counter, can be specified as %0..0c, if leading zeros have to be present,\n %o - original file name,\n %r - transformation code expanded to: r90, r270, r180, TrPose, TrVerse, HMirr, VMirr\n %S - file size (undocumented),\n %z - focal length (zoom)/year,\n %M - make/artist\n %m - model/title\n %x - metering mode,\n %X - exposure program\n %n - type extension\n Format escape sequences for music\n %A - album,\n %b - band,\n %C - comment,\n %L - language,\n %g - genre,\n %l - length,\n %T - track,\n %e - composer,\n %E - conductor\n </pre>";
    public static int counter;
    public static String timemask;
    public static String datemask;
    public static Object[] transformCodes;
    final int TEXT = 0;
    final int ESC = 1;
    final char PERCENT = (char)37;
    private String mask;
    private int rotation;
    private boolean inccount;

    public FileNameFormat(String mask) {
        this(mask, false);
    }

    public FileNameFormat(String mask, boolean inccount) {
        this.mask = mask;
        this.inccount = inccount;
    }

    public FileNameFormat(String mask, int rotation) {
        this(mask);
        this.rotation = rotation;
    }

    public FileNameFormat(String mask, int rotation, boolean inccount) {
        this(mask, inccount);
        this.rotation = rotation;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        AbstractInfo info = null;
        long imagefilelen = 0L;
        try {
            info = ((AbstractFormat)obj).getInfo();
            imagefilelen = ((AbstractFormat)obj).getFileSize();
        }
        catch (NullPointerException npe) {
        }
        catch (ClassCastException e2) {
            throw new IllegalArgumentException("Expected AbstractFormat, but found " + obj.getClass().getName());
        }
        int state = 0;
        String lead_zeros = "";
        StringBuffer result = new StringBuffer();
        block92: for (int i2 = 0; this.mask != null && i2 < this.mask.length(); ++i2) {
            char c2 = this.mask.charAt(i2);
            switch (state) {
                case 0: {
                    if (c2 != '%') {
                        result.append(c2);
                        continue block92;
                    }
                    state = 1;
                    continue block92;
                }
                case 1: {
                    state = 0;
                    switch (c2) {
                        case 'D': {
                            DateFormat dt2 = datemask == null || datemask.length() == 0 || timemask == null || timemask.length() == 0 ? DateFormat.getDateTimeInstance(3, 3) : new SimpleDateFormat(datemask + timemask);
                            result.append(FileNameFormat.getDateFormatted(dt2, info));
                            continue block92;
                        }
                        case 'd': {
                            DateFormat d2 = datemask == null || datemask.length() == 0 ? DateFormat.getDateInstance(3) : new SimpleDateFormat(datemask);
                            result.append(FileNameFormat.getDateFormatted(d2, info));
                            continue block92;
                        }
                        case 't': {
                            DateFormat t2 = timemask == null || timemask.length() == 0 ? DateFormat.getTimeInstance(3) : new SimpleDateFormat(timemask);
                            result.append(FileNameFormat.getDateFormatted(t2, info));
                            continue block92;
                        }
                        case 's': {
                            try {
                                result.append(Rational.toExposureString(info.getAttribute("Shutter")));
                            }
                            catch (NullPointerException npe) {
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    result.append(info.getAttribute("Bitrate").toString());
                                }
                                catch (Exception e3) {}
                            }
                            continue block92;
                        }
                        case 'a': {
                            try {
                                result.append(info.getAttribute("FNumber").toString());
                            }
                            catch (NullPointerException npe) {
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    result.append(info.getAttribute("Samplerate").toString());
                                }
                                catch (Exception e4) {}
                            }
                            continue block92;
                        }
                        case 'f': {
                            if (info == null) continue block92;
                            try {
                                result.append(info.getBoolAttribute("Flash") ? CMD_YES : CMD_NO);
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    result.append(info.getBoolAttribute("Protection") ? CMD_YES : CMD_NO);
                                }
                                catch (IllegalArgumentException iae2) {}
                            }
                            continue block92;
                        }
                        case 'q': {
                            try {
                                result.append(info.getAttribute("Quality").toString());
                            }
                            catch (NullPointerException npe) {
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    result.append(info.getAttribute("Mode").toString());
                                }
                                catch (Exception e5) {}
                            }
                            continue block92;
                        }
                        case 'c': {
                            if (lead_zeros.length() > 0) {
                                lead_zeros = lead_zeros + '0';
                            }
                            result.append(new DecimalFormat(lead_zeros).format(counter));
                            lead_zeros = "";
                            continue block92;
                        }
                        case 'o': {
                            try {
                                result.append(((AbstractFormat)obj).getName());
                            }
                            catch (NullPointerException npe) {}
                            continue block92;
                        }
                        case 'r': {
                            result.append((String)transformCodes[this.rotation]);
                            continue block92;
                        }
                        case 'S': {
                            result.append(imagefilelen);
                            continue block92;
                        }
                        case 'z': {
                            try {
                                result.append(info.getAttribute("FocalLength").toString());
                            }
                            catch (NullPointerException npe) {
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    result.append(info.getIntAttribute("Year"));
                                }
                                catch (Exception e6) {}
                            }
                            continue block92;
                        }
                        case 'm': {
                            try {
                                result.append(info.getAttribute("Model"));
                            }
                            catch (NullPointerException npe) {
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    result.append(info.getAttribute("Title").toString());
                                }
                                catch (Exception e7) {}
                            }
                            continue block92;
                        }
                        case 'M': {
                            try {
                                result.append(info.getAttribute("Make").toString());
                            }
                            catch (NullPointerException npe) {
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    result.append(info.getAttribute("Artist").toString());
                                }
                                catch (Exception e8) {}
                            }
                            continue block92;
                        }
                        case '0': {
                            lead_zeros = lead_zeros + '0';
                            state = 1;
                            continue block92;
                        }
                        case 'A': {
                            try {
                                result.append(info.getAttribute("Album").toString());
                            }
                            catch (Exception e9) {}
                            continue block92;
                        }
                        case 'b': {
                            try {
                                result.append(info.getAttribute("Band").toString());
                            }
                            catch (Exception e10) {}
                            continue block92;
                        }
                        case 'C': {
                            try {
                                result.append(info.getAttribute("Comments").toString());
                            }
                            catch (Exception e11) {}
                            continue block92;
                        }
                        case 'L': {
                            try {
                                result.append(info.getAttribute("Language").toString());
                            }
                            catch (Exception e12) {}
                            continue block92;
                        }
                        case 'l': {
                            try {
                                result.append(info.getAttribute("timestamp"));
                            }
                            catch (Exception e13) {}
                            continue block92;
                        }
                        case 'T': {
                            try {
                                result.append(info.getIntAttribute("Track"));
                            }
                            catch (Exception e14) {}
                            continue block92;
                        }
                        case 'e': {
                            try {
                                result.append(info.getAttribute("Composer").toString());
                            }
                            catch (Exception e15) {}
                            continue block92;
                        }
                        case 'E': {
                            try {
                                result.append(info.getAttribute("Conductor").toString());
                            }
                            catch (Exception e16) {}
                            continue block92;
                        }
                        case 'x': {
                            try {
                                result.append(info.getAttribute("Metering").toString());
                            }
                            catch (Exception e17) {}
                            continue block92;
                        }
                        case 'X': {
                            try {
                                result.append(info.getAttribute("ExpoProgram").toString());
                            }
                            catch (Exception e18) {}
                            continue block92;
                        }
                        case 'n': {
                            result.append(((AbstractFormat)obj).getType());
                            continue block92;
                        }
                        case '%': {
                            result.append(c2);
                            continue block92;
                        }
                    }
                    result.append('%');
                    result.append(c2);
                }
            }
        }
        if (this.inccount) {
            ++counter;
        }
        if (result.length() == 0) {
            result.append(obj.toString());
        }
        return result;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public static String makeValidPathName(String name) {
        return FileNameFormat.makeValidPathName(name, null);
    }

    public static String makeValidPathName(String name, String ext) {
        if (name.indexOf(46) < 0 && ext != null) {
            name = name + '.' + ext;
        }
        char[] cs2 = name.toCharArray();
        boolean changed = false;
        for (int i2 = 0; i2 < cs2.length; ++i2) {
            char c2 = cs2[i2];
            if ((Character.isLetterOrDigit(c2) || c2 == '.' || c2 == ' ' || c2 == '_' || c2 == '-' || c2 == '@' || c2 == '#') && c2 <= '\u007f') continue;
            cs2[i2] = 95;
            changed = true;
        }
        if (changed) {
            return new String(cs2);
        }
        return name;
    }

    private static String getDateFormatted(DateFormat dt2, AbstractInfo info) {
        String dateFormatted = null;
        try {
            if (info != null) {
                dateFormatted = dt2.format(info.getAttribute("DateTimeOriginal"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (dateFormatted == null) {
            dateFormatted = dt2.format(new Date());
        }
        return dateFormatted;
    }
}

