/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Loader;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static Log log = LogFactory.getLog(XmlConfiguration.class);
    private static Class[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static Class[] __primitiveHolders = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static XmlParser __parser;
    private XmlParser.Node _config;
    private Map _idMap = new HashMap();

    private static synchronized void initParser() throws IOException {
        if (__parser != null) {
            return;
        }
        __parser = new XmlParser();
        URL config13URL = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_3.dtd");
        __parser.redirectEntity("configure.dtd", config13URL);
        __parser.redirectEntity("configure_1_3.dtd", config13URL);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_3.dtd", config13URL);
        __parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", config13URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.3//EN", config13URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", config13URL);
        URL config12URL = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_2.dtd");
        __parser.redirectEntity("configure_1_2.dtd", config12URL);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_2.dtd", config12URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.2//EN", config12URL);
        URL config11URL = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_1.dtd");
        __parser.redirectEntity("configure_1_1.dtd", config11URL);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_1.dtd", config11URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.1//EN", config11URL);
        URL config10URL = XmlConfiguration.class.getClassLoader().getResource("org/mortbay/xml/configure_1_0.dtd");
        __parser.redirectEntity("configure_1_0.dtd", config10URL);
        __parser.redirectEntity("http://jetty.mortbay.org/configure_1_0.dtd", config10URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.0//EN", config10URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(configuration.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        configuration = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure 1.2//EN\" \"http://jetty.mortbay.org/configure_1_2.dtd\">" + configuration;
        InputSource source = new InputSource(new StringReader(configuration));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        InputSource source = new InputSource(configuration);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(source);
        }
    }

    public void configure(Object obj) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class oClass = this.nodeClass(this._config);
        if (oClass != null) {
            if (obj != null && !oClass.isInstance(obj)) {
                throw new IllegalArgumentException("Object is not of type " + oClass);
            }
            if (obj == null) {
                obj = oClass.newInstance();
            }
        }
        this.configure(obj, this._config, 0);
    }

    public Object newInstance() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class oClass = this.nodeClass(this._config);
        Object obj = null;
        if (oClass != null) {
            obj = oClass.newInstance();
        }
        this.configure(obj, this._config, 0);
        return obj;
    }

    private Class nodeClass(XmlParser.Node node) throws ClassNotFoundException {
        String className = node.getAttribute("class");
        if (className == null) {
            return null;
        }
        return Loader.loadClass(XmlConfiguration.class, className);
    }

    private void configure(Object obj, XmlParser.Node cfg, int i2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        block21: {
            XmlParser.Node node = null;
            try {
                while (i2 < cfg.size()) {
                    Object o2 = cfg.get(i2);
                    if (!(o2 instanceof String)) {
                        node = (XmlParser.Node)o2;
                        String tag = node.getTag();
                        if ("Set".equals(tag)) {
                            this.set(obj, node);
                        } else if ("Put".equals(tag)) {
                            this.put(obj, node);
                        } else if ("Call".equals(tag)) {
                            this.call(obj, node);
                        } else if ("Get".equals(tag)) {
                            this.get(obj, node);
                        } else if ("New".equals(tag)) {
                            this.newObj(obj, node);
                        } else if ("Ref".equals(tag)) {
                            this.refObj(obj, node);
                        } else {
                            throw new IllegalStateException("Unknown tag: " + tag);
                        }
                    }
                    ++i2;
                }
            }
            catch (InvocationTargetException e2) {
                log.warn("Exception at " + node.toString(), e2.getTargetException());
                throw e2;
            }
            catch (Error e3) {
                log.debug(node);
                throw e3;
            }
            catch (Exception e4) {
                log.debug(node);
                if (e4 instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e4;
                }
                if (e4 instanceof InvocationTargetException) {
                    throw (InvocationTargetException)e4;
                }
                if (e4 instanceof IllegalAccessException) {
                    throw (IllegalAccessException)e4;
                }
                if (!(e4 instanceof RuntimeException)) break block21;
                throw (RuntimeException)e4;
            }
        }
    }

    private void set(Object obj, XmlParser.Node node) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String attr = node.getAttribute("name");
        String name = "set" + attr.substring(0, 1).toUpperCase() + attr.substring(1);
        Object value = this.value(obj, node);
        Object[] arg = new Object[]{value};
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else {
            oClass = obj.getClass();
        }
        Class[] vClass = new Class[]{Object.class};
        if (value != null) {
            vClass[0] = value.getClass();
        }
        if (log.isDebugEnabled()) {
            log.debug(obj + "." + name + "(" + vClass[0] + " " + value + ")");
        }
        try {
            Method set = oClass.getMethod(name, vClass);
            set.invoke(obj, arg);
            return;
        }
        catch (IllegalArgumentException e2) {
            LogSupport.ignore(log, e2);
        }
        catch (IllegalAccessException e3) {
            LogSupport.ignore(log, e3);
        }
        catch (NoSuchMethodException e4) {
            LogSupport.ignore(log, e4);
        }
        try {
            Field type = vClass[0].getField("TYPE");
            vClass[0] = (Class)type.get(null);
            Method set = oClass.getMethod(name, vClass);
            set.invoke(obj, arg);
            return;
        }
        catch (NoSuchFieldException e5) {
            LogSupport.ignore(log, e5);
        }
        catch (IllegalArgumentException e6) {
            LogSupport.ignore(log, e6);
        }
        catch (IllegalAccessException e7) {
            LogSupport.ignore(log, e7);
        }
        catch (NoSuchMethodException e8) {
            LogSupport.ignore(log, e8);
        }
        try {
            Field field = oClass.getField(attr);
            if (Modifier.isPublic(field.getModifiers())) {
                field.set(obj, value);
                return;
            }
        }
        catch (NoSuchFieldException e9) {
            LogSupport.ignore(log, e9);
        }
        Method[] sets = oClass.getMethods();
        Method set = null;
        for (int s2 = 0; sets != null && s2 < sets.length; ++s2) {
            if (!name.equals(sets[s2].getName()) || sets[s2].getParameterTypes().length != 1) continue;
            try {
                set = sets[s2];
                sets[s2].invoke(obj, arg);
                return;
            }
            catch (IllegalArgumentException e10) {
                LogSupport.ignore(log, e10);
                continue;
            }
            catch (IllegalAccessException e11) {
                LogSupport.ignore(log, e11);
            }
        }
        if (set != null) {
            try {
                Class sClass = set.getParameterTypes()[0];
                if (sClass.isPrimitive()) {
                    for (int t2 = 0; t2 < __primitives.length; ++t2) {
                        if (!sClass.equals(__primitives[t2])) continue;
                        sClass = __primitiveHolders[t2];
                        break;
                    }
                }
                Constructor<?> cons = sClass.getConstructor(vClass);
                arg[0] = cons.newInstance(arg);
                set.invoke(obj, arg);
                return;
            }
            catch (NoSuchMethodException e12) {
                LogSupport.ignore(log, e12);
            }
            catch (IllegalAccessException e13) {
                LogSupport.ignore(log, e13);
            }
            catch (InstantiationException e14) {
                LogSupport.ignore(log, e14);
            }
        }
        throw new NoSuchMethodException(oClass + "." + name + "(" + vClass[0] + ")");
    }

    private void put(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException("Object for put is not a Map: " + obj);
        }
        Map map = (Map)obj;
        String name = node.getAttribute("name");
        Object value = this.value(obj, node);
        map.put(name, value);
        if (log.isDebugEnabled()) {
            log.debug(obj + ".put(" + name + "+" + value + ")");
        }
    }

    private Object get(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else {
            oClass = obj.getClass();
        }
        String name = node.getAttribute("name");
        String id = node.getAttribute("id");
        if (log.isDebugEnabled()) {
            log.debug("get " + name);
        }
        try {
            Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), null);
            obj = method.invoke(obj, (Object[])null);
            this.configure(obj, node, 0);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Field field = oClass.getField(name);
                obj = field.get(obj);
                this.configure(obj, node, 0);
            }
            catch (NoSuchFieldException nsfe) {
                throw nsme;
            }
        }
        if (id != null) {
            this._idMap.put(id, obj);
        }
        return obj;
    }

    private Object call(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        String id = node.getAttribute("id");
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else if (obj != null) {
            oClass = obj.getClass();
        }
        if (oClass == null) {
            throw new IllegalArgumentException(node.toString());
        }
        int size = 0;
        int argi = node.size();
        for (int i2 = 0; i2 < node.size(); ++i2) {
            Object o2 = node.get(i2);
            if (o2 instanceof String) continue;
            if (!((XmlParser.Node)o2).getTag().equals("Arg")) {
                argi = i2;
                break;
            }
            ++size;
        }
        Object[] arg = new Object[size];
        int i3 = 0;
        int j2 = 0;
        while (j2 < size) {
            Object o3 = node.get(i3);
            if (!(o3 instanceof String)) {
                arg[j2++] = this.value(obj, (XmlParser.Node)o3);
            }
            ++i3;
        }
        String method = node.getAttribute("name");
        if (log.isDebugEnabled()) {
            log.debug("call " + method);
        }
        Method[] methods = oClass.getMethods();
        for (int c2 = 0; methods != null && c2 < methods.length; ++c2) {
            if (!methods[c2].getName().equals(method) || methods[c2].getParameterTypes().length != size || Modifier.isStatic(methods[c2].getModifiers()) != (obj == null) || obj == null && methods[c2].getDeclaringClass() != oClass) continue;
            Object n2 = null;
            boolean called = false;
            try {
                n2 = methods[c2].invoke(obj, arg);
                called = true;
            }
            catch (IllegalAccessException e2) {
                LogSupport.ignore(log, e2);
            }
            catch (IllegalArgumentException e3) {
                LogSupport.ignore(log, e3);
            }
            if (!called) continue;
            if (id != null) {
                this._idMap.put(id, n2);
            }
            this.configure(n2, node, argi);
            return n2;
        }
        throw new IllegalStateException("No Method: " + node + " on " + oClass);
    }

    private Object newObj(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class oClass = this.nodeClass(node);
        String id = node.getAttribute("id");
        int size = 0;
        int argi = node.size();
        for (int i2 = 0; i2 < node.size(); ++i2) {
            Object o2 = node.get(i2);
            if (o2 instanceof String) continue;
            if (!((XmlParser.Node)o2).getTag().equals("Arg")) {
                argi = i2;
                break;
            }
            ++size;
        }
        Object[] arg = new Object[size];
        int i3 = 0;
        int j2 = 0;
        while (j2 < size) {
            Object o3 = node.get(i3);
            if (!(o3 instanceof String)) {
                arg[j2++] = this.value(obj, (XmlParser.Node)o3);
            }
            ++i3;
        }
        if (log.isDebugEnabled()) {
            log.debug("new " + oClass);
        }
        Constructor<?>[] constructors = oClass.getConstructors();
        for (int c2 = 0; constructors != null && c2 < constructors.length; ++c2) {
            if (constructors[c2].getParameterTypes().length != size) continue;
            Object n2 = null;
            boolean called = false;
            try {
                n2 = constructors[c2].newInstance(arg);
                called = true;
            }
            catch (IllegalAccessException e2) {
                LogSupport.ignore(log, e2);
            }
            catch (InstantiationException e3) {
                LogSupport.ignore(log, e3);
            }
            catch (IllegalArgumentException e4) {
                LogSupport.ignore(log, e4);
            }
            if (!called) continue;
            if (id != null) {
                this._idMap.put(id, n2);
            }
            this.configure(n2, node, argi);
            return n2;
        }
        throw new IllegalStateException("No Constructor: " + node + " on " + obj);
    }

    private Object refObj(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        String id = node.getAttribute("id");
        obj = this._idMap.get(id);
        if (obj == null) {
            throw new IllegalStateException("No object for id=" + id);
        }
        this.configure(obj, node, 0);
        return obj;
    }

    private Object newArray(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class aClass = Object.class;
        String type = node.getAttribute("type");
        String id = node.getAttribute("id");
        if (type != null && (aClass = TypeUtil.fromName(type)) == null) {
            aClass = "String".equals(type) ? String.class : ("URL".equals(type) ? URL.class : ("InetAddress".equals(type) ? InetAddress.class : ("InetAddrPort".equals(type) ? InetAddrPort.class : Loader.loadClass(XmlConfiguration.class, type))));
        }
        Object array = Array.newInstance(aClass, node.size());
        if (id != null) {
            this._idMap.put(id, obj);
        }
        for (int i2 = 0; i2 < node.size(); ++i2) {
            Object o2 = node.get(i2);
            if (o2 instanceof String) continue;
            XmlParser.Node item = (XmlParser.Node)o2;
            if (!item.getTag().equals("Item")) {
                throw new IllegalStateException("Not an Item");
            }
            id = item.getAttribute("id");
            Object v2 = this.value(obj, item);
            if (v2 != null) {
                Array.set(array, i2, v2);
            }
            if (id == null) continue;
            this._idMap.put(id, v2);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object value(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Object value = null;
        String type = node.getAttribute("type");
        String ref = node.getAttribute("ref");
        if (ref != null) {
            value = this._idMap.get(ref);
        } else {
            int first;
            if (node.size() == 0) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            int last = node.size() - 1;
            if (type == null || !"String".equals(type)) {
                Object item = null;
                for (first = 0; first <= last && (item = node.get(first)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0; ++first) {
                }
                while (first < last && (item = node.get(last)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0) {
                    --last;
                }
                if (first > last) {
                    return null;
                }
            }
            if (first == last) {
                value = this.itemValue(obj, node.get(first));
            } else {
                StringBuffer buf;
                StringBuffer stringBuffer = buf = new StringBuffer();
                synchronized (stringBuffer) {
                    for (int i2 = first; i2 <= last; ++i2) {
                        Object item = node.get(i2);
                        buf.append(this.itemValue(obj, item));
                    }
                    value = buf.toString();
                }
            }
        }
        if (value == null) {
            if ("String".equals(type)) {
                return "";
            }
            return null;
        }
        if (type == null) {
            if (value != null && value instanceof String) {
                return ((String)value).trim();
            }
            return value;
        }
        if ("String".equals(type) || "java.lang.String".equals(type)) {
            return value.toString();
        }
        Class pClass = TypeUtil.fromName(type);
        if (pClass != null) {
            return TypeUtil.valueOf(pClass, value.toString());
        }
        if ("URL".equals(type) || "java.net.URL".equals(type)) {
            if (value instanceof URL) {
                return value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException e2) {
                throw new InvocationTargetException(e2);
            }
        }
        if ("InetAddress".equals(type) || "java.net.InetAddress".equals(type)) {
            if (value instanceof InetAddress) {
                return value;
            }
            try {
                return InetAddress.getByName(value.toString());
            }
            catch (UnknownHostException e3) {
                throw new InvocationTargetException(e3);
            }
        }
        if ("InetAddrPort".equals(type) || "org.mortbay.util.InetAddrPort".equals(type)) {
            if (value instanceof InetAddrPort) {
                return value;
            }
            try {
                return new InetAddrPort(value.toString());
            }
            catch (UnknownHostException e4) {
                throw new InvocationTargetException(e4);
            }
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    private Object itemValue(Object obj, Object item) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (item instanceof String) {
            return item;
        }
        XmlParser.Node node = (XmlParser.Node)item;
        String tag = node.getTag();
        if ("Call".equals(tag)) {
            return this.call(obj, node);
        }
        if ("Get".equals(tag)) {
            return this.get(obj, node);
        }
        if ("New".equals(tag)) {
            return this.newObj(obj, node);
        }
        if ("Ref".equals(tag)) {
            return this.refObj(obj, node);
        }
        if ("Array".equals(tag)) {
            return this.newArray(obj, node);
        }
        if ("SystemProperty".equals(tag)) {
            String name = node.getAttribute("name");
            String defaultValue = node.getAttribute("default");
            return System.getProperty(name, defaultValue);
        }
        log.warn("Unknown value tag: " + node, new Throwable());
        return null;
    }

    public static void main(String[] arg) {
        try {
            for (int i2 = 0; i2 < arg.length; ++i2) {
                new XmlConfiguration(Resource.newResource(arg[i2]).getURL()).newInstance();
            }
        }
        catch (Exception e2) {
            log.warn("EXCEPTION ", e2);
        }
    }
}

