/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = "\t\n\r";
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnTokens = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;

    public QuotedStringTokenizer(String str, String delim, boolean returnTokens, boolean returnQuotes) {
        super("");
        this._string = str;
        if (delim != null) {
            this._delim = delim;
        }
        this._returnTokens = returnTokens;
        this._returnQuotes = returnQuotes;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String str, String delim, boolean returnTokens) {
        this(str, delim, returnTokens, false);
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, false, false);
    }

    public QuotedStringTokenizer(String str) {
        this(str, null, false, false);
    }

    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int state = 0;
        boolean escape = false;
        block6: while (this._i < this._string.length()) {
            char c2 = this._string.charAt(this._i++);
            switch (state) {
                case 0: {
                    if (this._delim.indexOf(c2) >= 0) {
                        if (!this._returnTokens) continue block6;
                        this._token.append(c2);
                        this._hasToken = true;
                        return true;
                    }
                    if (c2 == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c2 == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        state = 3;
                        continue block6;
                    }
                    this._token.append(c2);
                    this._hasToken = true;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c2) >= 0) {
                        if (this._returnTokens) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c2 == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c2 == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        state = 3;
                        continue block6;
                    }
                    this._token.append(c2);
                    continue block6;
                }
                case 2: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        this._token.append(c2);
                        continue block6;
                    }
                    if (c2 == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c2 == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c2);
                    continue block6;
                }
                case 3: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        this._token.append(c2);
                        continue block6;
                    }
                    if (c2 == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c2 == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c2);
                    continue block6;
                }
            }
        }
        return this._hasToken;
    }

    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String t2 = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return t2;
    }

    public String nextToken(String delim) throws NoSuchElementException {
        this._delim = delim;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public int countTokens() {
        return -1;
    }

    public static String quote(String s2, String delim) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() == 0) {
            return "\"\"";
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '\"' && c2 != '\\' && c2 != '\'' && delim.indexOf(c2) < 0) continue;
            StringBuffer b2 = new StringBuffer(s2.length() + 8);
            QuotedStringTokenizer.quote(b2, s2);
            return b2.toString();
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quote(StringBuffer buf, String s2) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append('\"');
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                char c2 = s2.charAt(i2);
                if (c2 == '\"') {
                    buf.append("\\\"");
                    continue;
                }
                if (c2 == '\\') {
                    buf.append("\\\\");
                    continue;
                }
                buf.append(c2);
            }
            buf.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unquote(String s2) {
        StringBuffer b2;
        char last;
        if (s2 == null) {
            return null;
        }
        if (s2.length() < 2) {
            return s2;
        }
        char first = s2.charAt(0);
        if (first != (last = s2.charAt(s2.length() - 1)) || first != '\"' && first != '\'') {
            return s2;
        }
        StringBuffer stringBuffer = b2 = new StringBuffer(s2.length() - 2);
        synchronized (stringBuffer) {
            boolean quote = false;
            for (int i2 = 1; i2 < s2.length() - 1; ++i2) {
                char c2 = s2.charAt(i2);
                if (c2 == '\\' && !quote) {
                    quote = true;
                    continue;
                }
                quote = false;
                b2.append(c2);
            }
            return b2.toString();
        }
    }
}

