/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayPool;

public class LineInput
extends FilterInputStream {
    private static Log log = LogFactory.getLog(LineInput.class);
    private byte[] _buf;
    private ByteBuffer _byteBuffer;
    private InputStreamReader _reader;
    private int _mark = -1;
    private int _pos;
    private int _avail;
    private int _contents;
    private int _byteLimit = -1;
    private boolean _newByteLimit;
    private LineBuffer _lineBuffer;
    private String _encoding;
    private boolean _eof = false;
    private boolean _lastCr = false;
    private boolean _seenCrLf = false;
    private static final int LF = 10;
    private static final int CR = 13;

    public LineInput(InputStream in) {
        this(in, 0);
    }

    public LineInput(InputStream in, int bufferSize) {
        super(in);
        if (bufferSize == 0) {
            bufferSize = 8192;
        }
        this._buf = ByteArrayPool.getByteArray(bufferSize);
        this._byteBuffer = new ByteBuffer(this._buf);
        this._lineBuffer = new LineBuffer(bufferSize);
        try {
            this._reader = new InputStreamReader((InputStream)this._byteBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            this._reader = new InputStreamReader(this._byteBuffer);
        }
    }

    public LineInput(InputStream in, int bufferSize, String encoding) throws UnsupportedEncodingException {
        super(in);
        if (bufferSize == 0) {
            bufferSize = 2048;
        }
        this._buf = ByteArrayPool.getByteArray(bufferSize);
        this._byteBuffer = new ByteBuffer(this._buf);
        this._lineBuffer = new LineBuffer(bufferSize);
        this._reader = new InputStreamReader((InputStream)this._byteBuffer, encoding);
        this._encoding = encoding;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setByteLimit(int bytes) {
        this._byteLimit = bytes;
        if (bytes >= 0) {
            this._newByteLimit = true;
            this._byteLimit -= this._contents - this._pos;
            if (this._byteLimit < 0) {
                this._avail += this._byteLimit;
                this._byteLimit = 0;
            }
        } else {
            this._newByteLimit = false;
            this._avail = this._contents;
            this._eof = false;
        }
    }

    public int getByteLimit() {
        if (this._byteLimit < 0) {
            return this._byteLimit;
        }
        return this._byteLimit + this._avail - this._pos;
    }

    public synchronized String readLine() throws IOException {
        int len = this.fillLine(this._buf.length);
        if (len < 0) {
            return null;
        }
        String s2 = null;
        if (this._encoding == null) {
            s2 = new String(this._buf, this._mark, len);
        } else {
            try {
                s2 = new String(this._buf, this._mark, len, this._encoding);
            }
            catch (UnsupportedEncodingException e2) {
                log.warn("EXCEPTION ", e2);
            }
        }
        this._mark = -1;
        return s2;
    }

    public int readLine(char[] c2, int off, int len) throws IOException {
        int read;
        int r2;
        int blen = this.fillLine(len);
        if (blen < 0) {
            return -1;
        }
        if (blen == 0) {
            return 0;
        }
        this._byteBuffer.setStream(this._mark, blen);
        for (read = 0; read < len && this._reader.ready() && (r2 = this._reader.read(c2, off + read, len - read)) > 0; read += r2) {
        }
        this._mark = -1;
        return read;
    }

    public int readLine(byte[] b2, int off, int len) throws IOException {
        if ((len = this.fillLine(len)) < 0) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        System.arraycopy(this._buf, this._mark, b2, off, len);
        this._mark = -1;
        return len;
    }

    public LineBuffer readLineBuffer() throws IOException {
        return this.readLineBuffer(this._buf.length);
    }

    public LineBuffer readLineBuffer(int len) throws IOException {
        int read;
        int r2;
        if ((len = this.fillLine(len > 0 ? len : this._buf.length)) < 0) {
            return null;
        }
        if (len == 0) {
            this._lineBuffer.size = 0;
            return this._lineBuffer;
        }
        this._byteBuffer.setStream(this._mark, len);
        this._lineBuffer.size = 0;
        for (read = 0; read < len && this._reader.ready() && (r2 = this._reader.read(this._lineBuffer.buffer, read, len - read)) > 0; read += r2) {
        }
        this._lineBuffer.size = read;
        this._mark = -1;
        return this._lineBuffer;
    }

    public synchronized int read() throws IOException {
        if (this._pos >= this._avail) {
            this.fill();
        }
        int b2 = this._pos >= this._avail ? -1 : this._buf[this._pos++] & 0xFF;
        return b2;
    }

    public synchronized int read(byte[] b2, int off, int len) throws IOException {
        int avail = this._avail - this._pos;
        if (avail <= 0) {
            this.fill();
            avail = this._avail - this._pos;
        }
        if (avail <= 0) {
            len = -1;
        } else {
            len = avail < len ? avail : len;
            System.arraycopy(this._buf, this._pos, b2, off, len);
            this._pos += len;
        }
        return len;
    }

    public long skip(long n2) throws IOException {
        int avail = this._avail - this._pos;
        if (avail <= 0) {
            this.fill();
            avail = this._avail - this._pos;
        }
        if (avail <= 0) {
            n2 = 0L;
        } else {
            n2 = (long)avail < n2 ? (long)avail : n2;
            this._pos = (int)((long)this._pos + n2);
        }
        return n2;
    }

    public synchronized int available() throws IOException {
        int in_stream = this.in.available();
        if (this._byteLimit >= 0 && in_stream > this._byteLimit) {
            in_stream = this._byteLimit;
        }
        return this._avail - this._pos + in_stream;
    }

    public synchronized void mark(int limit) throws IllegalArgumentException {
        if (limit > this._buf.length) {
            byte[] new_buf = new byte[limit];
            System.arraycopy(this._buf, this._pos, new_buf, this._pos, this._avail - this._pos);
            this._buf = new_buf;
            if (this._byteBuffer != null) {
                this._byteBuffer.setBuffer(this._buf);
            }
        }
        this._mark = this._pos;
    }

    public synchronized void reset() throws IOException {
        if (this._mark < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this._pos = this._mark;
        this._mark = -1;
    }

    public boolean markSupported() {
        return true;
    }

    private void fill() throws IOException {
        int saved;
        if (this._mark > 0) {
            saved = this._contents - this._mark;
            System.arraycopy(this._buf, this._mark, this._buf, 0, saved);
            this._pos -= this._mark;
            this._avail -= this._mark;
            this._contents = saved;
            this._mark = 0;
        } else if (this._mark < 0 && this._pos > 0) {
            saved = this._contents - this._pos;
            System.arraycopy(this._buf, this._pos, this._buf, 0, saved);
            this._avail -= this._pos;
            this._contents = saved;
            this._pos = 0;
        } else if (this._mark == 0 && this._pos > 0 && this._contents == this._buf.length) {
            this._mark = -1;
            this.fill();
            return;
        }
        int n2 = 0;
        this._eof = false;
        if (this._byteLimit == 0) {
            this._eof = true;
        } else {
            while (!this._eof && n2 == 0 && this._buf.length > this._contents) {
                int space = this._buf.length - this._contents;
                n2 = this.in.read(this._buf, this._contents, space);
                if (n2 <= 0) {
                    if (n2 == 0) {
                        Thread.yield();
                        int b2 = this.in.read();
                        if (b2 >= 0) {
                            n2 = 1;
                            this._buf[this._contents++] = (byte)b2;
                        } else {
                            this._eof = true;
                        }
                    } else {
                        this._eof = true;
                    }
                } else {
                    this._contents += n2;
                }
                this._avail = this._contents;
                if (this._byteLimit <= 0) continue;
                if (this._contents - this._pos >= this._byteLimit) {
                    this._avail = this._byteLimit + this._pos;
                }
                if (n2 > this._byteLimit) {
                    this._byteLimit = 0;
                    continue;
                }
                if (n2 >= 0) {
                    this._byteLimit -= n2;
                    continue;
                }
                if (n2 != -1) continue;
                throw new IOException("Premature EOF");
            }
        }
        if (this._avail - this._pos > 0 && this._lastCr && this._buf[this._pos] == 10) {
            this._seenCrLf = true;
            ++this._pos;
            if (this._mark >= 0) {
                ++this._mark;
            }
            this._lastCr = false;
            if (this._byteLimit >= 0 && this._newByteLimit) {
                if (this._avail < this._contents) {
                    ++this._avail;
                } else {
                    ++this._byteLimit;
                }
            }
            if (this._pos == this._avail) {
                this.fill();
            }
        }
        this._newByteLimit = false;
    }

    private int fillLine(int maxLen) throws IOException {
        this._mark = this._pos;
        if (this._pos >= this._avail) {
            this.fill();
        }
        if (this._pos >= this._avail) {
            return -1;
        }
        boolean cr2 = this._lastCr;
        boolean lf = false;
        this._lastCr = false;
        int len = 0;
        block4: while (this._pos <= this._avail) {
            while (this._pos == this._avail) {
                if (this._eof || this._mark == 0 && this._contents == this._buf.length) {
                    this._lastCr = !this._eof && this._buf[this._avail - 1] == 13;
                    cr2 = true;
                    lf = true;
                    break block4;
                }
                if (cr2 && this.in.available() == 0 && !this._seenCrLf) {
                    this._lastCr = true;
                    cr2 = true;
                    lf = true;
                    break block4;
                }
                this._pos = this._mark;
                this.fill();
                this._pos = len;
                cr2 = false;
            }
            byte b2 = this._buf[this._pos++];
            switch (b2) {
                case 10: {
                    if (cr2) {
                        this._seenCrLf = true;
                    }
                    lf = true;
                    break block4;
                }
                case 13: {
                    if (cr2 && this._pos > 1) {
                        --this._pos;
                        break block4;
                    }
                    cr2 = true;
                    continue block4;
                }
                default: {
                    if (cr2) {
                        if (this._pos == 1) {
                            cr2 = false;
                        } else {
                            --this._pos;
                            break block4;
                        }
                    }
                    if (++len != maxLen) continue block4;
                    if (this._mark != 0 && this._pos + 2 >= this._avail && this._avail < this._buf.length) {
                        this.fill();
                    }
                    if (this._pos < this._avail && this._buf[this._pos] == 13) {
                        cr2 = true;
                        ++this._pos;
                    }
                    if (this._pos < this._avail && this._buf[this._pos] == 10) {
                        lf = true;
                        ++this._pos;
                    }
                    if (cr2 || lf) break block4;
                    lf = true;
                    cr2 = true;
                    break block4;
                }
            }
        }
        if (!cr2 && !lf && len == 0) {
            len = -1;
        }
        return len;
    }

    public void destroy() {
        ByteArrayPool.returnByteArray(this._buf);
        this._byteBuffer = null;
        this._reader = null;
        this._lineBuffer = null;
        this._encoding = null;
    }

    public static class LineBuffer {
        public char[] buffer;
        public int size;

        public LineBuffer(int maxLineLength) {
            this.buffer = new char[maxLineLength];
        }

        public String toString() {
            return new String(this.buffer, 0, this.size);
        }
    }

    private static class ByteBuffer
    extends ByteArrayInputStream {
        ByteBuffer(byte[] buffer) {
            super(buffer);
        }

        void setBuffer(byte[] buffer) {
            this.buf = buffer;
        }

        void setStream(int offset, int length) {
            this.pos = offset;
            this.count = offset + length;
            this.mark = -1;
        }
    }
}

