/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.LogSupport;

public abstract class LifeCycleThread
implements LifeCycle,
Runnable {
    private static Log log = LogFactory.getLog(LifeCycleThread.class);
    private boolean _running;
    private boolean _daemon;
    private Thread _thread;

    public boolean isDaemon() {
        return this._daemon;
    }

    public void setDaemon(boolean d2) {
        this._daemon = d2;
    }

    public Thread getThread() {
        return this._thread;
    }

    public boolean isStarted() {
        return this._running;
    }

    public synchronized void start() throws Exception {
        if (this._running) {
            log.debug("Already started");
            return;
        }
        this._running = true;
        if (this._thread == null) {
            this._thread = new Thread(this);
            this._thread.setDaemon(this._daemon);
        }
        this._thread.start();
    }

    public synchronized void stop() throws InterruptedException {
        this._running = false;
        if (this._thread != null) {
            this._thread.interrupt();
            this._thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            while (this._running) {
                try {
                    this.loop();
                }
                catch (InterruptedException e2) {
                    LogSupport.ignore(log, e2);
                }
                catch (InterruptedIOException e3) {
                    LogSupport.ignore(log, e3);
                }
                catch (Exception e4) {
                    if (!this.exception(e4)) continue;
                    break;
                }
                catch (Error e5) {
                    if (!this.error(e5)) continue;
                    break;
                }
            }
        }
        finally {
            this._running = false;
        }
    }

    public boolean exception(Exception e2) {
        log.warn("EXCEPTION ", e2);
        return true;
    }

    public boolean error(Error e2) {
        log.warn("EXCEPTION ", e2);
        return true;
    }

    public abstract void loop() throws InterruptedException, InterruptedIOException, Exception;
}

