/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddrPort
implements Serializable {
    public static final String __0_0_0_0 = "0.0.0.0";
    private InetAddress _addr = null;
    private boolean _addrIsHost = false;
    private int _port = 0;

    public InetAddrPort() {
    }

    public InetAddrPort(int port) {
        this._port = port;
    }

    public InetAddrPort(InetAddress addr, int port) {
        this._addr = addr;
        this._port = port;
    }

    public InetAddrPort(String host, int port) throws UnknownHostException {
        this.setHost(host);
        this.setPort(port);
    }

    public InetAddrPort(String inetAddrPort) throws UnknownHostException {
        int c2 = inetAddrPort.indexOf(58);
        if (c2 >= 0) {
            String addr = inetAddrPort.substring(0, c2);
            if (addr.indexOf(47) > 0) {
                addr = addr.substring(addr.indexOf(47) + 1);
            }
            inetAddrPort = inetAddrPort.substring(c2 + 1);
            if (addr.length() > 0 && !__0_0_0_0.equals(addr)) {
                this._addrIsHost = !Character.isDigit(addr.charAt(0));
                this._addr = InetAddress.getByName(addr);
            }
        }
        this._port = Integer.parseInt(inetAddrPort);
    }

    public InetAddrPort(InetAddrPort address) {
        if (address != null) {
            this._addr = address._addr;
            this._port = address._port;
        }
    }

    public String getHost() {
        if (this._addr == null) {
            return __0_0_0_0;
        }
        return this._addrIsHost ? this._addr.getHostName() : this._addr.getHostAddress();
    }

    public void setHost(String host) throws UnknownHostException {
        this._addr = null;
        if (host != null) {
            if (host.indexOf(47) > 0) {
                host = host.substring(0, host.indexOf(47));
            }
            this._addrIsHost = !Character.isDigit(host.charAt(0));
            this._addr = InetAddress.getByName(host);
        }
    }

    public InetAddress getInetAddress() {
        return this._addr;
    }

    public void setInetAddress(InetAddress addr) {
        this._addrIsHost = false;
        this._addr = addr;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String toString() {
        return this.getHost() + ':' + this._port;
    }

    public Object clone() {
        return new InetAddrPort(this);
    }

    public int hashCode() {
        return this._port + (this._addr == null ? 0 : this._addr.hashCode());
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof InetAddrPort) {
            InetAddrPort addr = (InetAddrPort)o2;
            return addr._port == this._port && (addr._addr == this._addr || addr._addr != null && addr._addr.equals(this._addr));
        }
        return false;
    }
}

