/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.ThreadPool;

public class IO
extends ThreadPool {
    private static Log log = LogFactory.getLog(IO.class);
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static int bufferSize = Integer.getInteger("org.mortbay.util.IO.bufferSize", 8192);
    private static NullOS __nullStream = new NullOS();
    private static NullWrite __nullWriter = new NullWrite();

    public static IO instance() {
        return Singleton.__instance;
    }

    public static void copyThread(InputStream in, OutputStream out) {
        try {
            IO.instance().run(new Job(in, out));
        }
        catch (InterruptedException e2) {
            log.warn("EXCEPTION ", e2);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copyThread(Reader in, Writer out) {
        try {
            IO.instance().run(new Job(in, out));
        }
        catch (InterruptedException e2) {
            log.warn("EXCEPTION ", e2);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(in, out);
        return new String(out.toByteArray());
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i2 = 0; files != null && i2 < files.length; ++i2) {
                IO.delete(files[i2]);
            }
        }
        return file.delete();
    }

    public void handle(Object o2) {
        Job job = (Job)o2;
        try {
            if (job.in != null) {
                IO.copy(job.in, job.out, -1L);
            } else {
                IO.copy(job.read, job.write, -1L);
            }
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
            try {
                if (job.out != null) {
                    job.out.close();
                }
                if (job.write != null) {
                    job.write.close();
                }
            }
            catch (IOException e22) {
                LogSupport.ignore(log, e22);
            }
        }
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
        }
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
        }
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    private static class NullWrite
    extends Writer {
        private NullWrite() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] b2) {
        }

        public void write(char[] b2, int o2, int l2) {
        }

        public void write(int b2) {
        }

        public void write(String s2) {
        }

        public void write(String s2, int o2, int l2) {
        }
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b2) {
        }

        public void write(byte[] b2, int i2, int l2) {
        }

        public void write(int b2) {
        }
    }

    static class Job {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.read = null;
            this.write = null;
        }

        Job(Reader read, Writer write) {
            this.in = null;
            this.out = null;
            this.read = read;
            this.write = write;
        }
    }

    private static class Singleton {
        static final IO __instance = new IO();

        private Singleton() {
        }

        static {
            try {
                __instance.start();
            }
            catch (Exception e2) {
                log.fatal(e2);
                System.exit(1);
            }
        }
    }
}

