/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.TimeZone;
import org.mortbay.log.Frame;
import org.mortbay.log.LogImpl;
import org.mortbay.log.LogSink;
import org.mortbay.log.LogStream;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.DateCache;
import org.mortbay.util.MultiException;
import org.mortbay.util.RolloverFileOutputStream;
import org.mortbay.util.StringBufferWriter;
import org.mortbay.util.StringUtil;

public class OutputStreamLogSink
implements LogSink {
    private static final String __lineSeparator = System.getProperty("line.separator");
    private int _retainDays = 31;
    protected DateCache _dateFormat = new DateCache("HH:mm:ss.SSS");
    protected String _logTimezone;
    protected boolean _logTimeStamps = true;
    protected boolean _logLabels = true;
    protected boolean _logTags = true;
    protected boolean _logStackSize = true;
    protected boolean _logStackTrace = false;
    protected boolean _logOneLine = false;
    protected boolean _suppressStack = false;
    private String _filename;
    private boolean _append = true;
    protected boolean _flushOn = true;
    protected int _bufferSize = 2048;
    protected boolean _reopen = false;
    protected transient LogImpl _logImpl = null;
    protected transient boolean _started;
    protected transient OutputStream _out;
    protected transient ByteArrayISO8859Writer _buffer;
    private static final Class[] __noArgs = new Class[0];
    private static final String[] __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
    private static StringBufferWriter __stringBufferWriter = new StringBufferWriter();
    private static PrintWriter __printWriter = new PrintWriter(__stringBufferWriter);

    public OutputStreamLogSink() throws IOException {
        this._filename = System.getProperty("LOG_FILE");
        if (this._filename == null) {
            this._out = LogStream.STDERR_STREAM;
        }
    }

    public OutputStreamLogSink(String filename) {
        this._filename = filename;
    }

    public String getLogDateFormat() {
        return this._dateFormat.getFormatString();
    }

    public void setLogDateFormat(String logDateFormat) {
        this._dateFormat = new DateCache(logDateFormat);
        if (this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimezone() {
        return this._logTimezone;
    }

    public void setLogTimezone(String logTimezone) {
        this._logTimezone = logTimezone;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public String getLogTimeZone() {
        return this._logTimezone;
    }

    public void setLogTimeZone(String logTimezone) {
        this._logTimezone = logTimezone;
        if (this._dateFormat != null && this._logTimezone != null) {
            this._dateFormat.getFormat().setTimeZone(TimeZone.getTimeZone(this._logTimezone));
        }
    }

    public boolean isLogTimeStamps() {
        return this._logTimeStamps;
    }

    public void setLogTimeStamps(boolean logTimeStamps) {
        this._logTimeStamps = logTimeStamps;
    }

    public boolean isLogLabels() {
        return this._logLabels;
    }

    public void setLogLabels(boolean logLabels) {
        this._logLabels = logLabels;
    }

    public boolean isLogTags() {
        return this._logTags;
    }

    public void setLogTags(boolean logTags) {
        this._logTags = logTags;
    }

    public boolean isLogStackSize() {
        return this._logStackSize;
    }

    public void setLogStackSize(boolean logStackSize) {
        this._logStackSize = logStackSize;
    }

    public boolean isLogStackTrace() {
        return this._logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this._logStackTrace = logStackTrace;
    }

    public boolean isLogOneLine() {
        return this._logOneLine;
    }

    public void setLogOneLine(boolean logOneLine) {
        this._logOneLine = logOneLine;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean a2) {
        this._append = a2;
    }

    public boolean isSuppressStack() {
        return this._suppressStack;
    }

    public void setSuppressStack(boolean suppressStack) {
        this._suppressStack = suppressStack;
    }

    public synchronized void setOutputStream(OutputStream out) {
        this._reopen = this.isStarted() && out != out;
        this._filename = null;
        if (this._buffer != null) {
            this._buffer.resetWriter();
        }
        this._out = out;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public synchronized void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        if (this.isStarted() && this._filename != null && filename == null) {
            this._out = null;
        }
        this._reopen = this.isStarted() && (this._filename == null && filename != null || this._filename != null && !this._filename.equals(filename));
        this._filename = filename;
        if (!this.isStarted() && this._filename != null) {
            this._out = null;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._filename == null) {
            return null;
        }
        if (this._out == null || !(this._out instanceof RolloverFileOutputStream)) {
            return null;
        }
        return ((RolloverFileOutputStream)this._out).getDatedFilename();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int retainDays) {
        this._reopen = this.isStarted() && this._retainDays != retainDays;
        this._retainDays = retainDays;
    }

    public void setFlushOn(boolean on) {
        this._flushOn = on;
        if (on && this._out != null) {
            try {
                this._out.flush();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public boolean getFlushOn() {
        return this._flushOn;
    }

    public synchronized void log(String tag, Object o2, Frame frame, long time) {
        StringBuffer buf = new StringBuffer(160);
        if (this._logTimeStamps) {
            buf.append(this._dateFormat.format(time));
            buf.append(' ');
        }
        if (this._logTags) {
            buf.append(tag);
        }
        if (this._logLabels && frame != null) {
            buf.append(frame.toString());
        }
        if (this._logStackSize && frame != null) {
            buf.append(" >");
            if (frame.getDepth() < 10) {
                buf.append('0');
            }
            buf.append(Integer.toString(frame.getDepth()));
            buf.append("> ");
        }
        String nl = __lineSeparator;
        if (this._logLabels && !this._logOneLine && this._buffer.size() > 0) {
            buf.append(nl);
        }
        this.formatObject(buf, o2);
        if (this._logStackTrace && frame != null) {
            buf.append(nl);
            buf.append(frame.getStack());
        }
        this.log(buf.toString());
    }

    public synchronized void log(String formattedLog) {
        if (this._reopen || this._out == null) {
            this.stop();
            this.start();
        }
        try {
            this._buffer.write(formattedLog);
            this._buffer.write(StringUtil.__LINE_SEPARATOR);
            if (this._flushOn || this._buffer.size() > this._bufferSize) {
                this._buffer.writeTo(this._out);
                this._buffer.resetWriter();
                this._out.flush();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public synchronized void start() {
        this._buffer = new ByteArrayISO8859Writer(this._bufferSize);
        this._reopen = false;
        if (this._started) {
            return;
        }
        if (this._out == null && this._filename != null) {
            try {
                RolloverFileOutputStream rfos = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
                this._out = rfos;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (this._out == null) {
            this._out = LogStream.STDERR_STREAM;
        }
        this._started = true;
    }

    public synchronized void stop() {
        block9: {
            this._started = false;
            if (this._out != null) {
                block8: {
                    try {
                        if (this._buffer.size() > 0) {
                            this._buffer.writeTo(this._out);
                        }
                        this._out.flush();
                        this._buffer = null;
                    }
                    catch (Exception e2) {
                        if (this._logImpl == null || !this._logImpl.getDebug()) break block8;
                        e2.printStackTrace();
                    }
                }
                Thread.yield();
            }
            if (this._out != null && this._out != LogStream.STDERR_STREAM) {
                try {
                    this._out.close();
                }
                catch (Exception e3) {
                    if (this._logImpl == null || !this._logImpl.getDebug()) break block9;
                    e3.printStackTrace();
                }
            }
        }
        if (this._filename != null) {
            this._out = null;
        }
    }

    public boolean isStarted() {
        return this._started;
    }

    public void setLogImpl(LogImpl impl) {
        this._logImpl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void formatObject(StringBuffer buf, Object o2) {
        int i22;
        int init_size = buf.length();
        if (o2 == null) {
            buf.append("null");
        } else if (o2.getClass().isArray()) {
            int l2 = Array.getLength(o2);
            for (i22 = 0; i22 < l2; ++i22) {
                this.formatObject(buf, Array.get(o2, i22));
            }
        } else if (o2 instanceof Throwable) {
            Throwable ex = (Throwable)o2;
            buf.append('\n');
            if (this._suppressStack) {
                buf.append(ex.toString());
                buf.append("\nNo stack available\n--");
            } else {
                PrintWriter i22 = __printWriter;
                synchronized (i22) {
                    __stringBufferWriter.setStringBuffer(buf);
                    OutputStreamLogSink.expandThrowable(ex);
                    __printWriter.flush();
                }
            }
        } else {
            buf.append(o2.toString());
        }
        int end_size = buf.length();
        if (this._logOneLine) {
            for (i22 = init_size; i22 < end_size; ++i22) {
                char c2 = buf.charAt(i22);
                if (c2 == '\n') {
                    buf.setCharAt(i22, '|');
                    continue;
                }
                if (c2 != '\r') continue;
                buf.setCharAt(i22, '<');
            }
        }
    }

    private static void expandThrowable(Throwable ex) {
        ex.printStackTrace(__printWriter);
        if (ex instanceof MultiException) {
            MultiException mx = (MultiException)ex;
            for (int i2 = 0; i2 < mx.size(); ++i2) {
                __printWriter.print("[" + i2 + "]=");
                Exception ex2 = mx.getException(i2);
                OutputStreamLogSink.expandThrowable(ex2);
            }
        } else {
            for (int i3 = 0; i3 < __nestedEx.length; ++i3) {
                try {
                    Method getTargetException = ex.getClass().getMethod(__nestedEx[i3], __noArgs);
                    Throwable ex2 = (Throwable)getTargetException.invoke((Object)ex, (Object[])null);
                    if (ex2 == null) continue;
                    __printWriter.println(__nestedEx[i3] + "():");
                    OutputStreamLogSink.expandThrowable(ex2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

